/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze;

import javax.swing.JOptionPane;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.platform.Platform;

public class Application {
    private static void error(String msg) {
        System.err.println(msg);
        String skinProperty = System.getProperty("skins", "");
        if (skinProperty.indexOf("headless") == -1) {
            JOptionPane.showMessageDialog(null, msg, "Error starting SoftSqueeze", 0);
        }
        System.exit(-1);
    }

    public static void main(String[] args) {
        try {
            if (!Platform.JRE_1_4_PLUS) {
                Application.error("Please upgrade to Java 1.4");
            }
            Softsqueeze.main(args);
        }
        catch (NoClassDefFoundError e) {
            Application.error("Failed to find SoftSqueeze libraries.");
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer("Error starting SoftSqueeze: ");
            msg.append(e.getMessage());
            msg.append('\n');
            StackTraceElement[] stackTrace = e.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                msg.append(stackTrace[i].toString());
                msg.append('\n');
            }
            Application.error(msg.toString());
        }
    }
}

