/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze;

import com.l2fprod.gui.nativeskin.NativeSkin;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.InetAddress;
import javax.swing.JApplet;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.audio.AudioDecoder;
import org.titmuss.softsqueeze.audio.Player;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.config.ConfigDialog;
import org.titmuss.softsqueeze.config.ConfigListener;
import org.titmuss.softsqueeze.config.ConfigPopup;
import org.titmuss.softsqueeze.display.LcdDisplay;
import org.titmuss.softsqueeze.net.CliConnection;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.net.ProtocolListener;
import org.titmuss.softsqueeze.net.SSHTunnel;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.util.Util;

public class Softsqueeze
implements ConfigListener,
ProtocolListener {
    private static final Logger logger = Logger.getLogger((String)"softsqueeze");
    private static final String MIN_SLIMSERVER_VERSION = "6.5";
    private static final String MAX_SLIMSERVER_VERSION = "7.5";
    private boolean isSlimserverCheck = false;
    private JApplet applet;
    private Protocol wire;
    private Player player;
    private CliConnection cli;
    private LcdDisplay lcddisplay;
    private ConfigDialog configDialog;
    private Skin skin;
    private boolean skinLock = false;
    private int firmware;
    private static final int INIT = 0;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private int state = 0;
    private SSHTunnel sshTunnel;

    public Softsqueeze() {
        this(null);
    }

    public Softsqueeze(JApplet applet) {
        this.applet = applet;
        try {
            String logProperty = Config.getProperty("log");
            String[] logNames = Util.split(logProperty, ",");
            for (int i = 0; i < logNames.length; ++i) {
                Logger l = Logger.getLogger((String)logNames[i]);
                l.setLevel(Level.DEBUG);
            }
            boolean hasMP3Plugin = AudioDecoder.isMP3PluginInstalled();
            if (!Config.getBooleanProperty("has.mp3plugin") && hasMP3Plugin) {
                Config.putProperty("audio.mp3decoder", AudioDecoder.getDefaultMP3Decoder());
            }
            Config.putBooleanProperty("has.mp3plugin", hasMP3Plugin);
            this.wire = new Protocol();
            this.cli = new CliConnection();
            this.player = new Player(this);
            if (!Config.isHeadless()) {
                if (NativeSkin.isSupported()) {
                    System.loadLibrary("jawt");
                }
                this.lcddisplay = new LcdDisplay(this);
                this.openSkins();
            }
            this.wire.addProtocolListener("vers", this);
            this.wire.addProtocolListener("serv", this);
            this.wire.sendDiscoveryRequest(2, 23, Platform.parseMacAddress(Config.getProperty("macaddress")));
            if (Config.getSlimServerAddress().equals("")) {
                if (Config.isHeadless()) {
                    System.err.println("Please include the Squeezebox Server address on the command line. e.g. -Dslimserver=localhost");
                    System.exit(-1);
                } else {
                    this.openConfigDialog();
                }
            }
            Config.addConfigListener(this);
            this.connect();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception", (Throwable)e);
        }
    }

    public Protocol getProtocol() {
        return this.wire;
    }

    public LcdDisplay getLcdDisplay() {
        return this.lcddisplay;
    }

    public CliConnection getCLI() {
        return this.cli;
    }

    public JApplet getApplet() {
        return this.applet;
    }

    public void openConfigDialog() {
        if (this.configDialog == null) {
            this.configDialog = new ConfigDialog();
        }
        this.configDialog.showDialog(this.skin);
    }

    @Override
    public void configSet(String key, String value) {
        if (key.equals("slimserver") || key.startsWith("ssh") || key.endsWith("port") || key.equals("displayemulation")) {
            this.connect();
        } else if (key.startsWith("skin")) {
            this.openSkins();
            this.connect();
        }
    }

    public synchronized void openSkins() {
        String skinName = Config.getProperty("skin");
        if (this.skinLock) {
            return;
        }
        if (this.skin != null) {
            this.skin.dispose();
            this.skin = null;
        }
        if (skinName != null && !Config.isHeadless()) {
            this.skinLock = true;
            this.skin = new Skin(this, skinName);
            this.skinLock = false;
            if (this.skin == null) {
                logger.error((Object)("Cannot open skin " + skinName));
            }
        }
    }

    public void connect() {
        if (this.state == 1) {
            this.wire.sendBye();
        }
        if (this.sshTunnel != null) {
            this.sshTunnel.disconnect();
            this.sshTunnel = null;
        }
        if (Config.getSlimServerAddress() == null || Config.getSlimServerAddress().length() == 0) {
            return;
        }
        try {
            if (Config.useSSH()) {
                this.setDisplayText("Please wait.", "SSH connecting.");
                this.sshTunnel = new SSHTunnel();
                this.sshTunnel.connect();
            }
            this.setDisplayText("Please wait.", "Connecting to Slim Server.");
            InetAddress addr = InetAddress.getByName(Config.getSlimServerAddress());
            this.wire.connect(addr, Config.getSlimProtoPort());
        }
        catch (Exception e) {
            this.setDisplayText("Connection failed.", "Please check server settings.");
            logger.warn((Object)"Exception in connect", (Throwable)e);
        }
    }

    public void setDisplayText(String s1, String s2) {
        if (this.lcddisplay == null) {
            System.out.println(s1 + ": " + s2);
            return;
        }
        this.lcddisplay.setText(s1, s2);
    }

    public void exit() {
        if (this.state == 1) {
            this.sendIR(1, 1, 63232);
            this.wire.sendBye();
        }
        if (this.sshTunnel != null) {
            this.sshTunnel.disconnect();
            this.sshTunnel = null;
        }
        this.state = 2;
        this.skin.dispose();
        if (this.applet == null) {
            System.exit(0);
        }
    }

    @Override
    public void slimprotoCmd(String cmd, byte[] buf, int off, int len) {
        if (cmd.equals("vers") && !this.isSlimserverCheck) {
            String v = new String(buf, off, len).trim();
            Config.putProperty("serverversion", v);
            int min = Softsqueeze.compareVersion(MIN_SLIMSERVER_VERSION, v);
            if (min > 0) {
                ConfigPopup.showErrorDialog("You have connected to Squeezebox Server " + v + ", but this version of SoftSqueeze\n requires Squeezebox Server " + MIN_SLIMSERVER_VERSION + " or greater. Please upgrade your Squeezebox Server.", "Please upgrade Squeezebox Server");
                this.openConfigDialog();
                return;
            }
            int max = Softsqueeze.compareVersion(MAX_SLIMSERVER_VERSION, v);
            if (max < 0) {
                ConfigPopup.showOnceDialog("checkslimserver7.5", "", "This version of SoftSqueeze is optimised for Squeezebox Server 7.5 but you are running Squeezebox Server " + v + ".\n", "Some problems may occur.");
            }
            this.isSlimserverCheck = true;
        } else if (cmd.equals("serv")) {
            int addr = Protocol.unpackN4(buf, off);
            switch (addr) {
                case 0: {
                    Config.setSlimNetworkServer(null);
                    break;
                }
                case 1: {
                    Config.setSlimNetworkServer("service.us.squeezenetwork.com");
                    break;
                }
                default: {
                    StringBuffer ipaddrBuf = new StringBuffer();
                    ipaddrBuf.append(Integer.toString(addr >> 24 & 0xFF));
                    ipaddrBuf.append(".");
                    ipaddrBuf.append(Integer.toString(addr >> 24 & 0xFF));
                    ipaddrBuf.append(".");
                    ipaddrBuf.append(Integer.toString(addr >> 24 & 0xFF));
                    ipaddrBuf.append(".");
                    ipaddrBuf.append(Integer.toString(addr >> 24 & 0xFF));
                    Config.setSlimNetworkServer(ipaddrBuf.toString());
                }
            }
            try {
                this.player.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connect();
        }
    }

    @Override
    public void slimprotoConnected() {
        this.firmware = Config.getIntegerProperty("firmwareversion");
        int deviceid = Config.getIntegerProperty("deviceid");
        if (this.skin != null) {
            deviceid = this.skin.getDeviceId();
        }
        String macAddress = Config.getProperty("macaddress");
        boolean isGraphics = this.lcddisplay != null && this.lcddisplay.getModel() != 0;
        this.wire.sendHELO(deviceid, this.firmware, Platform.parseMacAddress(macAddress), isGraphics, this.state != 0);
        this.state = 1;
        this.sendIR(1, 1, 63233);
    }

    @Override
    public void slimprotoDisconnected() {
        logger.warn((Object)"Lost contact with Slim Server");
        this.state = 2;
    }

    public void sendIR(int format, int noBits, int irCode) {
        if (this.state != 1) {
            return;
        }
        this.wire.sendIR(format, noBits, irCode);
    }

    public void sendButton(int code) {
        if (this.state != 1) {
            return;
        }
        this.wire.sendButton(code);
    }

    public void sendKnob(int position, int sync) {
        if (this.state != 1) {
            return;
        }
        this.wire.sendKnob(position, sync);
    }

    public void sendANIC() {
        this.wire.sendANIC();
    }

    private static int compareVersion(String v1, String v2) {
        String[] s1 = Util.split(v1, ".ab");
        String[] s2 = Util.split(v2, ".ab");
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int cmp = s1[i].compareTo(s2[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return s1.length <= s2.length ? 0 : 1;
    }

    public static void main(String[] args) {
        Platform.init();
        Config.init();
        new Softsqueeze();
    }

    static {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                String nativeLF = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(nativeLF);
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

