/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.AudioFormat;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.audio.AudioBufferListener;
import org.titmuss.softsqueeze.audio.AudioEvent;

public class AudioBuffer
extends InputStream {
    private static final Logger logger = Logger.getLogger((String)"audiobuffer.verbose");
    public static AudioFormat DEFAULT_AUDIO_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    private long bufferSize = 262144L;
    private long readPtr = 0L;
    private long writePtr = 0L;
    private boolean closed = false;
    private boolean loopBuffer = false;
    private long loopPtr = 0L;
    private boolean flush = false;
    private boolean underrun = true;
    private HashSet listeners = new HashSet();
    private AudioFormat audioFormat;
    private SortedMap writeEvents = new TreeMap();
    private SortedMap readEvents = new TreeMap();
    private byte[] buf;
    private OutputStream copy;

    public AudioBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buf = new byte[bufferSize];
        this.audioFormat = DEFAULT_AUDIO_FORMAT;
    }

    public synchronized AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        if (this.audioFormat.matches(audioFormat)) {
            return;
        }
        this.audioFormat = audioFormat;
        this.addReadEvent(0L, new AudioEvent(this, 6));
    }

    public synchronized void setOutputStream(OutputStream copy) {
        this.copy = copy;
    }

    public synchronized void addListener(AudioBufferListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(AudioBufferListener l) {
        this.listeners.remove(l);
    }

    public synchronized void addWriteEvent(long offset, AudioEvent event) {
        long readPos = this.writePtr + offset;
        ArrayList<AudioEvent> events = (ArrayList<AudioEvent>)this.writeEvents.get(new Long(readPos));
        if (events == null) {
            events = new ArrayList<AudioEvent>();
            this.writeEvents.put(new Long(readPos), events);
        }
        events.add(event);
    }

    public synchronized void addReadEvent(long offset, AudioEvent event) {
        long readPos = this.writePtr + offset;
        ArrayList<AudioEvent> events = (ArrayList<AudioEvent>)this.readEvents.get(new Long(readPos));
        if (events == null) {
            events = new ArrayList<AudioEvent>();
            this.readEvents.put(new Long(readPos), events);
        }
        events.add(event);
    }

    public synchronized void sendEvent(AudioEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((AudioBufferListener)i.next()).bufferEvent(event);
        }
    }

    public synchronized void setRepeat(boolean repeat) {
        this.loopPtr = this.writePtr;
        this.loopBuffer = repeat;
    }

    public synchronized boolean isRepeat() {
        return this.loopBuffer;
    }

    public synchronized long getReadPtr() {
        return this.readPtr % this.bufferSize;
    }

    public synchronized long getWritePtr() {
        return this.writePtr % this.bufferSize;
    }

    public long getReadCount() {
        return this.readPtr;
    }

    public long getWriteCount() {
        return this.writePtr;
    }

    public synchronized int getBufferSize() {
        return (int)this.bufferSize;
    }

    @Override
    public synchronized int available() throws IOException {
        int avail = (int)(this.writePtr - this.readPtr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("avil R=" + this.readPtr + " W=" + this.writePtr + " A=" + avail));
        }
        return avail;
    }

    public synchronized int freeSpace() {
        int free = (int)(this.bufferSize - this.writePtr + this.readPtr);
        logger.debug((Object)("free R=" + this.readPtr + " W=" + this.writePtr + " F=" + free));
        return free;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.notifyAll();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((AudioBufferListener)i.next()).bufferEvent(new AudioEvent(this, 0));
        }
        if (this.copy != null) {
            this.copy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(InputStream stream) throws IOException {
        int buflen;
        int ptr;
        int free;
        AudioBuffer audioBuffer = this;
        synchronized (audioBuffer) {
            free = this.freeSpace();
            while (free <= 0) {
                if (this.closed) {
                    return -1;
                }
                logger.debug((Object)("buf W=" + this.writePtr + " R=" + this.readPtr + " Buffer full, waiting ..."));
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((AudioBufferListener)i.next()).bufferEvent(new AudioEvent(this, 5));
                }
                this.flush = false;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted wait during fill()");
                }
                if (this.flush) {
                    return 0;
                }
                free = this.freeSpace();
            }
            if (this.closed) {
                return -1;
            }
            ptr = (int)(this.writePtr % this.bufferSize);
            buflen = Math.min(free, (int)(this.bufferSize - (long)ptr));
        }
        int n = stream.read(this.buf, ptr, buflen);
        if (this.copy != null && n > 0) {
            this.copy.write(this.buf, ptr, n);
        }
        AudioBuffer audioBuffer2 = this;
        synchronized (audioBuffer2) {
            Long writePos;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buf W=" + this.writePtr + " R=" + this.readPtr + " F=" + free + " #=" + n));
            }
            if (n == -1) {
                this.close();
            } else {
                this.writePtr += (long)n;
            }
            this.notifyAll();
            while (!this.writeEvents.isEmpty() && this.writePtr >= (writePos = (Long)this.writeEvents.firstKey())) {
                List events = (List)this.writeEvents.remove(writePos);
                for (AudioEvent event : events) {
                    Iterator i = this.listeners.iterator();
                    while (i.hasNext()) {
                        ((AudioBufferListener)i.next()).bufferEvent(event);
                    }
                }
            }
            return n;
        }
    }

    public synchronized int write(byte[] b, int off, int len) throws IOException {
        Long writePos;
        while (this.freeSpace() < len - off) {
            if (this.closed) {
                return -1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buf R=" + this.readPtr + " W=" + this.writePtr + " Buffer full, waiting ..."));
            }
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((AudioBufferListener)i.next()).bufferEvent(new AudioEvent(this, 5));
            }
            this.flush = false;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted wait during write()");
            }
            if (!this.flush) continue;
            return 0;
        }
        if (this.closed) {
            return -1;
        }
        int ptr = (int)(this.writePtr % this.bufferSize);
        int n = Math.min(len, (int)(this.bufferSize - (long)ptr));
        System.arraycopy(b, off, this.buf, ptr, n);
        int r = len - off - n;
        if (r > 0) {
            System.arraycopy(b, off + n, this.buf, 0, r);
            n += r;
        }
        if (this.copy != null) {
            this.copy.write(b, off, n);
        }
        this.writePtr += (long)n;
        this.notifyAll();
        while (!this.writeEvents.isEmpty() && this.writePtr >= (writePos = (Long)this.writeEvents.firstKey())) {
            List events = (List)this.writeEvents.remove(writePos);
            for (AudioEvent event : events) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((AudioBufferListener)i.next()).bufferEvent(event);
                }
            }
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int ok = this.read(b, 0, 1);
        return ok < 0 ? -1 : b[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        Long readPos;
        int ptr;
        int size = this.available();
        while (size == 0) {
            Iterator i;
            if (this.loopBuffer && this.closed && this.readPtr == this.writePtr) {
                this.readPtr = this.loopPtr;
                i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((AudioBufferListener)i.next()).bufferEvent(new AudioEvent(this, 2));
                }
                break;
            }
            if (!this.underrun && this.readPtr == this.writePtr) {
                logger.debug((Object)"audio buffer underrun");
                this.underrun = true;
                i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((AudioBufferListener)i.next()).bufferEvent(new AudioEvent(this, 1));
                }
            }
            if (this.closed) {
                return -1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buf R=" + this.readPtr + " W=" + this.writePtr + " Buffer empty, waiting ..."));
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted wait during read()");
            }
            size = this.available();
        }
        this.underrun = false;
        int n = Math.min(len = Math.min(size, len), (int)(this.bufferSize - (long)(ptr = (int)(this.readPtr % this.bufferSize))));
        if (n < 0) {
            return -1;
        }
        System.arraycopy(this.buf, ptr, b, off, n);
        int r = len - off - n;
        if (r > 0 && size > n) {
            System.arraycopy(this.buf, 0, b, off + n, r);
            n += r;
        }
        this.readPtr += (long)n;
        this.notifyAll();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buf R=" + this.readPtr + " W=" + this.writePtr + " #=" + n));
        }
        while (!this.readEvents.isEmpty() && this.readPtr >= (readPos = (Long)this.readEvents.firstKey())) {
            List events = (List)this.readEvents.remove(readPos);
            for (AudioEvent event : events) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((AudioBufferListener)i.next()).bufferEvent(event);
                }
            }
        }
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        int num = Math.min(this.available(), (int)n);
        this.readPtr += (long)num;
        return num;
    }

    public synchronized void flush() throws IOException {
        this.writePtr = 0L;
        this.readPtr = 0L;
        this.flush = true;
        this.notifyAll();
    }

    public synchronized void flush(long ptr) throws IOException {
        this.writePtr = ptr;
        if (this.readPtr >= this.writePtr) {
            this.readPtr = this.writePtr;
            this.flush = true;
        }
        this.notifyAll();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        logger.error((Object)("mark called " + readlimit));
    }

    @Override
    public void reset() throws IOException {
        logger.error((Object)"reset called");
    }
}

