/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.titmuss.softsqueeze.audio.AudioBuffer;

public class AudioBufferTest
extends TestCase {
    private int chunkSize = 10240;
    private int bufSize = this.chunkSize * 4;
    private byte[] data = new byte[this.bufSize * 10];
    private byte[] tmp = new byte[this.bufSize];
    private Random r = new Random();

    public void testSimpleRead() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        int len = this.r.nextInt(2048);
        try {
            int bw = audioBuffer.write(this.data, 0, len);
            int br = audioBuffer.read(this.tmp, 0, this.tmp.length);
            AudioBufferTest.assertEquals((int)bw, (int)br);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testClosedRead() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        try {
            audioBuffer.close();
            int br = audioBuffer.read(this.tmp, 0, this.tmp.length);
            AudioBufferTest.assertTrue((br < 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testClosedWriteBytes() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        try {
            audioBuffer.close();
            int bw = audioBuffer.write(this.data, 0, 1);
            AudioBufferTest.assertTrue((bw < 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testReadWriteBytes1() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        try {
            int n;
            int nr = 0;
            int br = 0;
            while ((double)br < (double)this.chunkSize * 3.5) {
                br += audioBuffer.write(this.data, br, br + this.chunkSize / 3);
                ++nr;
            }
            audioBuffer.close();
            int nw = 0;
            int bw = 0;
            while ((n = audioBuffer.read(this.tmp, 0, this.chunkSize / 5)) >= 0) {
                ++nw;
                boolean ok = true;
                for (int i = 0; i < n; ++i) {
                    ok = ok || this.data[bw + i] == this.tmp[i];
                }
                AudioBufferTest.assertTrue((boolean)ok);
                bw += n;
            }
            AudioBufferTest.assertEquals((int)br, (int)bw);
            System.err.println("testReadWrite1 br=" + br + " nr=" + nr + " nw=" + nw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testReadWriteBytes2() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        try {
            int n;
            int nr = 0;
            int br = 0;
            while ((double)br < (double)this.chunkSize * 3.5) {
                br += audioBuffer.write(this.data, br, br + (int)((double)this.chunkSize * 1.3));
                ++nr;
            }
            audioBuffer.close();
            int nw = 0;
            int bw = 0;
            while ((n = audioBuffer.read(this.tmp, 0, (int)((double)this.chunkSize * 1.5))) >= 0) {
                ++nw;
                boolean ok = true;
                for (int i = 0; i < n; ++i) {
                    ok = ok || this.data[bw + i] == this.tmp[i];
                }
                AudioBufferTest.assertTrue((boolean)ok);
                bw += n;
            }
            AudioBufferTest.assertEquals((int)br, (int)bw);
            System.err.println("testReadWrite2 br=" + br + " nr=" + nr + " nw=" + nw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testThreadedReadWriteBytes() {
        AudioBuffer audioBuffer = new AudioBuffer(this.bufSize);
        new Reader(audioBuffer);
        try {
            int nr = 0;
            int br = 0;
            while (br < this.bufSize * 9) {
                int n = this.r.nextInt((int)((double)this.chunkSize * 1.9));
                br += audioBuffer.write(this.data, br, br + n);
                ++nr;
            }
            audioBuffer.close();
            System.err.println("testThreadedReadWriteBytes br=" + br + " nr=" + nr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestRunner.run(AudioBufferTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.r.nextBytes(this.data);
    }

    class Reader
    extends Thread {
        AudioBuffer audioBuffer;

        Reader(AudioBuffer audioBuffer) {
            this.audioBuffer = audioBuffer;
            this.start();
        }

        @Override
        public void run() {
            try {
                int nw = 0;
                int bw = 0;
                while (true) {
                    int n = AudioBufferTest.this.r.nextInt((int)((double)AudioBufferTest.this.chunkSize * 1.9));
                    n = this.audioBuffer.read(AudioBufferTest.this.tmp, 0, n);
                    if (n < 0) break;
                    ++nw;
                    boolean ok = true;
                    for (int i = 0; i < n; ++i) {
                        ok = ok || AudioBufferTest.this.data[bw + i] == AudioBufferTest.this.tmp[i];
                    }
                    Assert.assertTrue((boolean)ok);
                    bw += n;
                }
                System.err.println("Reader bw=" + bw + " nw=" + nw);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

