/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.FormatConversionProvider;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import org.apache.log4j.Logger;
import org.kc7bfi.jflac.sound.spi.FlacEncoding;
import org.kc7bfi.jflac.sound.spi.FlacFormatConvertionProvider;
import org.titmuss.softsqueeze.audio.AudioBuffer;
import org.titmuss.softsqueeze.audio.AudioEvent;
import org.titmuss.softsqueeze.audio.AudioException;
import org.titmuss.softsqueeze.config.Config;

public class AudioDecoder
implements Runnable {
    private static final Logger vlogger = Logger.getLogger((String)"javasound.verbose");
    private static final Logger logger = Logger.getLogger((String)"javasound");
    private static final int DEFAULT_BUFFER_SIZE = 128000;
    public static final AudioFormat.Encoding MPEG1L3 = new Encoding("MPEG1L3");
    public static final AudioFormat.Encoding FLAC = FlacEncoding.FLAC;
    public static final AudioFormat.Encoding OGG = VorbisEncoding.VORBISENC;
    private static final HashMap MP3_DECODERS = new HashMap();
    private static int audioDecoderCount = 0;
    private AudioInputStream audioInputStream;
    private AudioBuffer outputBuffer;
    private long outputBufferPtr;
    private int lineBufferSize;
    private int sampleSizeInBits = 16;
    private boolean bigEndian = false;
    private Object lock = new Object();
    private boolean paused = true;
    private boolean playing = true;
    private boolean flush = false;
    private byte[] buf = new byte[128000];
    private int bufLen = 0;
    private int slowStart = 2048;

    public AudioDecoder(AudioBuffer decoderBuffer, AudioBuffer outputBuffer, float replayGain) throws AudioException {
        this.outputBuffer = outputBuffer;
        this.outputBufferPtr = outputBuffer.getWriteCount();
        logger.debug((Object)("new decoder. ptr=" + this.outputBufferPtr));
        this.lineBufferSize = Config.getIntegerProperty("player.lineBufferSize");
        try {
            AudioFormat audioFormat;
            int maxSpin = 5;
            while (--maxSpin > 0 && decoderBuffer.available() < 1024) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (decoderBuffer.getAudioFormat().getEncoding() == MPEG1L3) {
                String mp3decoder = Config.getProperty("audio.mp3decoder");
                Class<?> mp3fileReaderClass = Class.forName(((String[])MP3_DECODERS.get(mp3decoder))[0]);
                AudioFileReader fileReader = (AudioFileReader)mp3fileReaderClass.newInstance();
                this.audioInputStream = fileReader.getAudioInputStream(new BufferedInputStream(decoderBuffer));
                audioFormat = this.audioInputStream.getFormat();
            } else {
                audioFormat = decoderBuffer.getAudioFormat();
                this.audioInputStream = new AudioInputStream(decoderBuffer, audioFormat, -1L);
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, this.lineBufferSize);
            boolean isSupportedDirectly = AudioSystem.isLineSupported(info);
            if (!isSupportedDirectly) {
                logger.debug((Object)("conversion required for " + audioFormat + " [" + audioFormat.getClass().getName() + "]"));
                AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), this.sampleSizeInBits, audioFormat.getChannels(), audioFormat.getChannels() * (this.sampleSizeInBits / 8), audioFormat.getSampleRate(), this.bigEndian);
                if (audioFormat.getEncoding().toString().startsWith("MPEG")) {
                    String mp3decoder = Config.getProperty("audio.mp3decoder");
                    Class<?> mp3decoderClass = Class.forName(((String[])MP3_DECODERS.get(mp3decoder))[1]);
                    FormatConversionProvider fcp = (FormatConversionProvider)mp3decoderClass.newInstance();
                    this.audioInputStream = fcp.getAudioInputStream(targetFormat, this.audioInputStream);
                } else {
                    this.audioInputStream = audioFormat.getEncoding().equals(FLAC) ? new FlacFormatConvertionProvider().getAudioInputStream(targetFormat, this.audioInputStream) : AudioSystem.getAudioInputStream(targetFormat, this.audioInputStream);
                }
                logger.debug((Object)("CONVERSION PROVIDER: " + this.audioInputStream));
            }
            outputBuffer.setAudioFormat(this.audioInputStream.getFormat());
            outputBuffer.addReadEvent(0L, new AudioEvent(outputBuffer, 3));
            outputBuffer.addReadEvent(0L, new AudioEvent(outputBuffer, 8, replayGain));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"MP3 Decoder Unavailable", (Throwable)e);
            throw new AudioException("MP3 Decoder is unavailable");
        }
        catch (InstantiationException e) {
            logger.error((Object)"MP3 Decoder Unavailable", (Throwable)e);
            throw new AudioException("MP3 Decoder is unavailable");
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"MP3 Decoder Unavailable", (Throwable)e);
            throw new AudioException("MP3 Decoder is unavailable");
        }
        catch (UnsupportedAudioFileException e) {
            logger.error((Object)"Unsupported Audio Stream", (Throwable)e);
            throw new AudioException("Unsupported Audio Stream");
        }
        catch (IOException e) {
            logger.error((Object)"IOException", (Throwable)e);
            throw new AudioException("IOException", e);
        }
        Thread t = new Thread((Runnable)this, "AudioDecoder-" + audioDecoderCount++);
        t.setDaemon(true);
        t.start();
    }

    public static String getDefaultMP3Decoder() {
        return AudioDecoder.getMP3Decoders()[0];
    }

    public static String[] getMP3Decoders() {
        ArrayList<String> decoders = new ArrayList<String>();
        for (Map.Entry e : MP3_DECODERS.entrySet()) {
            try {
                Class.forName(((String[])e.getValue())[1]);
                decoders.add((String)e.getKey());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return decoders.toArray(new String[decoders.size()]);
    }

    public static boolean isMP3PluginInstalled() {
        boolean hasMP3Plugin = false;
        String[] mp3decoders = AudioDecoder.getMP3Decoders();
        for (int i = 0; i < mp3decoders.length; ++i) {
            if (!mp3decoders[i].equalsIgnoreCase("Java MP3 Plugin")) continue;
            return true;
        }
        return false;
    }

    public void play() {
        this.unpause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
            this.flush = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.debug((Object)"decoder started");
            int n = 0;
            while (n >= 0 && this.playing) {
                if (this.paused) {
                    Object object = this.lock;
                    synchronized (object) {
                        logger.debug((Object)"decoder paused (waiting)");
                        while (this.paused) {
                            this.lock.wait();
                        }
                    }
                    logger.debug((Object)"decoder playing");
                }
                n = this.decodeFrame();
            }
            this.audioInputStream.close();
            if (this.flush) {
                logger.debug((Object)("decoder flushing output buffer readPtr=" + this.outputBuffer.getReadCount() + " writePtr=" + this.outputBuffer.getWriteCount() + " ptr=" + this.outputBufferPtr));
                this.outputBuffer.flush(this.outputBufferPtr);
            }
            this.outputBuffer.sendEvent(new AudioEvent(this.outputBuffer, 9));
            logger.debug((Object)"decoder stopped");
        }
        catch (Exception e) {
            logger.warn((Object)"player thread exception ", (Throwable)e);
        }
    }

    private int decodeFrame() throws IOException {
        int br;
        int fillLen = this.buf.length - this.bufLen;
        if (this.slowStart < this.buf.length) {
            fillLen = Math.min(this.slowStart, fillLen);
            logger.debug((Object)("decodeFrame: fill buffer. available=" + this.outputBuffer.available() + " fillLen=" + fillLen + " slowStart " + this.slowStart));
            this.slowStart = Math.min(this.slowStart * 2, this.buf.length);
        }
        if ((br = this.audioInputStream.read(this.buf, this.bufLen, fillLen)) < 0) {
            return -1;
        }
        this.bufLen += br;
        int bw = this.outputBuffer.write(this.buf, 0, this.bufLen);
        if (bw < 0) {
            return -1;
        }
        if (bw < this.bufLen) {
            System.arraycopy(this.buf, bw, this.buf, 0, this.bufLen - bw);
            vlogger.warn((Object)("audioDecoder did not write (" + bw + ") the same number of bytes as read (" + this.bufLen + ")"));
        }
        this.bufLen -= bw;
        return bw;
    }

    static {
        MP3_DECODERS.put("Java MP3 Plugin", new String[]{"com.sun.media.codec.audio.mp3.JS_MP3FileReader", "com.sun.media.codec.audio.mp3.JS_MP3ConversionProvider"});
        MP3_DECODERS.put("JLayer", new String[]{"javazoom.spi.mpeg.sampled.file.MpegAudioFileReader", "javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider"});
    }

    private static class Encoding
    extends AudioFormat.Encoding {
        protected Encoding(String name) {
            super(name);
        }
    }
}

