/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.audio.AudioBuffer;
import org.titmuss.softsqueeze.audio.AudioBufferListener;
import org.titmuss.softsqueeze.audio.AudioEvent;
import org.titmuss.softsqueeze.audio.AudioException;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.visualizer.Visualizer;

public class AudioMixer
implements Runnable,
AudioBufferListener {
    private static final Logger vlogger = Logger.getLogger((String)"javasound.verbose");
    private static final Logger logger = Logger.getLogger((String)"javasound");
    private static int audioLineCount = 0;
    private Mixer mixer;
    private SourceDataLine line;
    private FloatControl gainControl;
    private AudioBuffer audioBuffer;
    private AudioFormat audioFormat;
    private double leftLevel = 1.0;
    private double rightLevel = 1.0;
    private double replayGain = 1.0;
    private byte[] buf;
    private int lineSize;
    private int bufSize = 0;
    private int bufLen = 0;
    private int bufCount = 0;
    private int frameSize;
    private float frameRate;
    private long framePositionOffset = 0L;
    private Visualizer visualizer;
    private static final int PAUSE = 0;
    private static final int FLUSH = 1;
    private static final int PLAY = 2;
    private static final int STOP = 3;
    private static final int RESET = 4;
    private volatile int inState = 0;
    private volatile int toState = 0;
    private float dB = 0.0f;
    private Thread mixerThread;
    private long lastFramePos = 0L;
    private long writeTime = 0L;
    private long readTime = 0L;
    private long bufDuration = 0L;
    private int slowStart = 0;
    private int skipFrames = 0;
    private static final int SLOW_START_SIZE = 2048;
    private boolean useDb = true;

    public AudioMixer(AudioBuffer audioBuffer) throws AudioException, LineUnavailableException {
        this.audioBuffer = audioBuffer;
        audioBuffer.addListener(this);
        this.initLine();
        this.mixerThread = new Thread((Runnable)this, "AudioMixer-" + audioLineCount++);
        this.mixerThread.setDaemon(true);
        this.mixerThread.setPriority(8);
        this.mixerThread.start();
    }

    private void initLine() throws AudioException, LineUnavailableException {
        String mixerName = Config.getProperty("audio.mixer");
        Mixer.Info mixerInfo = this.getMixerInfo(mixerName);
        if (mixerInfo == null) {
            logger.error((Object)("JavaSoundPlayer: mixer not found: " + mixerName));
            throw new AudioException("Cannot find mixer " + mixerName);
        }
        logger.debug((Object)("MIXER: " + mixerInfo.getName()));
        this.mixer = AudioSystem.getMixer(mixerInfo);
        int lineBufferSize = Config.getIntegerProperty("audio.lineBufferSize");
        this.audioFormat = this.audioBuffer.getAudioFormat();
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat, lineBufferSize);
        this.line = (SourceDataLine)this.mixer.getLine(lineInfo);
        this.line.open(this.audioFormat, lineBufferSize);
        this.framePositionOffset = 0L;
        if (logger.isDebugEnabled()) {
            Control[] ctls = this.line.getControls();
            for (int i = 0; i < ctls.length; ++i) {
                logger.debug((Object)("Control: " + ctls[i]));
            }
        }
        if (this.line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.gainControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
            this.gainControl.setValue(this.dB);
            this.useDb = true;
        } else if (this.line.isControlSupported(FloatControl.Type.VOLUME)) {
            this.gainControl = (FloatControl)this.line.getControl(FloatControl.Type.VOLUME);
            this.gainControl.setValue((float)Math.pow(10.0, (double)this.dB / 20.0) * this.gainControl.getMaximum());
            this.useDb = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Volume Control: type=" + this.gainControl.getType() + ", min=" + this.gainControl.getMinimum() + ", max=" + this.gainControl.getMaximum() + ", precision=" + this.gainControl.getPrecision() + ", updatePeriod=" + this.gainControl.getUpdatePeriod() + ", value=" + this.gainControl.getValue() + ", units=" + this.gainControl.getUnits() + ", minL=" + this.gainControl.getMinLabel() + ", midL=" + this.gainControl.getMidLabel() + ", maxL=" + this.gainControl.getMaxLabel()));
        }
        this.lineSize = this.line.getBufferSize();
        this.frameSize = this.audioFormat.getFrameSize();
        this.frameRate = this.audioFormat.getFrameRate();
        this.buf = new byte[this.lineSize];
        this.bufSize = this.buf.length;
        logger.debug((Object)("LINE BUFFER SIZE: " + this.lineSize));
        logger.debug((Object)("**** MIXER AUDIO FORMAT " + this.audioFormat));
    }

    public void setVolume(double leftLevel, double rightLevel) {
        this.leftLevel = leftLevel;
        this.rightLevel = rightLevel;
        this.setVolume();
    }

    private void setVolume() {
        double gainPreRg = (this.leftLevel + this.rightLevel) / 2.0;
        double gainPostRg = gainPreRg * this.replayGain;
        this.dB = (float)(Math.log(gainPostRg) / Math.log(10.0) * 20.0);
        if (this.useDb) {
            this.gainControl.setValue(this.dB);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setVolume(): gain(pre)=" + gainPreRg + ", replayGain=" + this.replayGain + ", gain(post)=" + gainPostRg + ", dB=" + this.dB + ", min=" + this.gainControl.getMinimum() + ", max=" + this.gainControl.getMaximum()));
            }
        } else {
            float volume = (float)gainPostRg * this.gainControl.getMaximum();
            this.gainControl.setValue(volume);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setVolume(): gain(pre)=" + gainPreRg + ", replayGain=" + this.replayGain + ", gain(post)=" + gainPostRg + ", dB=" + this.dB + ", volume=" + volume + ", min=" + this.gainControl.getMinimum() + ", max=" + this.gainControl.getMaximum()));
            }
        }
    }

    public void setVisualizer(Visualizer newVisualizer) {
        if (this.visualizer != null) {
            this.visualizer.stop();
        }
        if (newVisualizer != null) {
            newVisualizer.setAudioFormat(this.audioFormat);
            newVisualizer.init();
            if (this.inState == 2) {
                newVisualizer.play();
            }
        }
        this.visualizer = newVisualizer;
    }

    public long getElapsedMilliseconds() {
        long framePos = (long)this.line.getFramePosition() - this.framePositionOffset;
        if (framePos < this.lastFramePos) {
            this.lastFramePos = framePos;
            framePos += 29L;
        } else {
            this.lastFramePos = framePos;
        }
        return (long)((double)framePos / (double)this.frameRate * 1000.0);
    }

    public synchronized void pause(int interval) {
        if (!this.line.isRunning()) {
            return;
        }
        logger.debug((Object)("pause line inState=" + this.inState + ", interval=" + interval));
        this.line.stop();
        if (interval != 0) {
            try {
                Thread.sleep(interval + 2000);
            }
            catch (InterruptedException e) {
                logger.debug((Object)"pause sleep interrupted");
            }
            finally {
                this.line.start();
            }
        } else {
            this.toState = 0;
        }
        this.notifyAll();
    }

    public synchronized void play(long atTime) {
        if (this.line.isRunning()) {
            return;
        }
        logger.debug((Object)("play line inState=" + this.inState));
        this.toState = 2;
        if (atTime != 0L) {
            long interval = atTime - System.currentTimeMillis();
            while (this.toState == 2 && interval > 0L && interval < 2000L) {
                try {
                    this.notifyAll();
                    this.wait(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                interval = atTime - System.currentTimeMillis();
            }
        }
        this.line.start();
        this.notifyAll();
    }

    public synchronized void stop() {
        logger.debug((Object)("stop line inState=" + this.inState));
        this.line.stop();
        this.toState = 3;
        this.notifyAll();
        if (this.visualizer != null) {
            this.visualizer.stop();
        }
    }

    public synchronized void reset() {
        logger.debug((Object)("reset line inState=" + this.inState));
        this.toState = 4;
        this.notifyAll();
    }

    public synchronized void flush() throws IOException {
        if (this.inState != 2 && this.inState != 0) {
            return;
        }
        logger.debug((Object)("flush line inState=" + this.inState));
        this.line.stop();
        this.toState = 1;
        this.notifyAll();
        this.mixerThread.interrupt();
        while (this.inState != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void drain() {
        if (this.inState != 2) {
            return;
        }
        logger.debug((Object)("drain line inState=" + this.inState));
        this.line.drain();
        this.line.stop();
        this.skipFrames = 0;
        this.toState = 0;
        this.notifyAll();
        this.mixerThread.interrupt();
    }

    public synchronized void skipAhead(int msInterval) {
        logger.debug((Object)("skipAhead " + msInterval + " frames left to skip=" + this.skipFrames));
        if (this.skipFrames > 0 || this.inState != 2) {
            return;
        }
        this.skipFrames = (int)(this.frameRate * (float)msInterval / 1000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AudioMixer audioMixer;
            logger.debug((Object)"audio mixer started");
            int n = 0;
            while (this.toState != 3) {
                if (this.toState == 1) {
                    this.flushSamples();
                }
                if (this.toState == 0 || this.toState == 1) {
                    logger.debug((Object)("audio mixer paused (stopping player) available=" + this.audioBuffer.available()));
                    this.line.stop();
                    if (this.visualizer != null) {
                        this.visualizer.pause();
                    }
                    audioMixer = this;
                    synchronized (audioMixer) {
                        this.inState = 0;
                        this.notifyAll();
                    }
                    while (this.toState != 2) {
                        audioMixer = this;
                        synchronized (audioMixer) {
                            while (this.toState != 2) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                    break;
                                }
                            }
                        }
                        if (this.toState != 1) continue;
                        this.flushSamples();
                    }
                    audioMixer = this;
                    synchronized (audioMixer) {
                        this.inState = 2;
                        this.notifyAll();
                    }
                    logger.debug((Object)("audio mixer playing available=" + this.audioBuffer.available()));
                    this.bufDuration = 0L;
                    this.slowStart = 2048;
                    if (this.visualizer != null) {
                        this.visualizer.play();
                    }
                }
                if (this.toState == 4) {
                    audioMixer = this;
                    synchronized (audioMixer) {
                        this.toState = this.inState;
                        logger.debug((Object)("audio mixer reset state = " + this.inState));
                        this.line.stop();
                        this.line.close();
                        this.skipFrames = 0;
                        this.initLine();
                        if (this.inState == 2) {
                            this.line.start();
                        }
                        if (this.visualizer != null) {
                            this.visualizer.setAudioFormat(this.audioFormat);
                        }
                        continue;
                    }
                }
                n = this.playSamples();
                if (n != 0) continue;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug((Object)"audio mixer stopped");
            this.line.stop();
            this.line.flush();
            this.line.close();
            audioMixer = this;
            synchronized (audioMixer) {
                this.inState = 3;
                this.notifyAll();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"audio mixer exception ", (Throwable)e);
        }
    }

    private void flushSamples() throws IOException {
        logger.debug((Object)"flushing line");
        this.line.stop();
        this.line.flush();
        this.line.start();
        this.bufLen = 0;
        this.skipFrames = 0;
        this.audioBuffer.flush();
        this.framePositionOffset = this.line.getFramePosition();
        if (this.visualizer != null) {
            this.visualizer.flush();
        }
    }

    private int playSamples() throws AudioException {
        int fillLen;
        int lineAvail = this.line.available();
        boolean fillBuf = this.slowStart < this.lineSize;
        do {
            fillLen = this.buf.length - this.bufLen;
            if (!this.line.isRunning() && fillLen + this.bufLen > lineAvail) {
                fillLen = lineAvail - this.bufLen;
            } else if (fillBuf) {
                fillLen = Math.min(this.slowStart, fillLen);
            }
            int br = 0;
            if (fillLen > 0) {
                try {
                    br = this.audioBuffer.read(this.buf, this.bufLen, fillLen);
                    if (br < 0) {
                        return br;
                    }
                    this.bufLen += br;
                    if (br < fillLen) {
                        logger.debug((Object)("playFrame: short read br=" + br + " fillLen=" + fillLen));
                    }
                }
                catch (IOException e) {
                    br = 0;
                }
            }
            if (vlogger.isDebugEnabled()) {
                vlogger.debug((Object)("playFrame: bytes read=" + br + " bufLen=" + this.bufLen + " fillLen=" + fillLen + " available=" + (int)((double)((float)lineAvail / (float)this.lineSize) * 100.0) + "%"));
            }
            if (this.skipFrames <= 0) continue;
            int skipBytes = this.skipFrames * this.frameSize;
            if (skipBytes > this.bufLen) {
                skipBytes = this.bufLen - this.bufLen % this.frameSize;
            }
            if (skipBytes <= 0) continue;
            if (skipBytes < this.bufLen) {
                System.arraycopy(this.buf, skipBytes, this.buf, 0, this.bufLen - skipBytes);
                this.bufLen -= skipBytes;
            } else {
                this.bufLen = 0;
            }
            int skippedFrames = skipBytes / this.frameSize;
            this.skipFrames -= skippedFrames;
            this.framePositionOffset -= (long)skippedFrames;
        } while (this.skipFrames > 0);
        this.readTime = System.currentTimeMillis();
        long readElapsed = this.readTime - this.writeTime;
        int bw = 0;
        if (this.inState == 2 || this.inState == 0) {
            bw = this.line.write(this.buf, 0, this.bufLen);
            if (bw < 0) {
                return bw;
            }
            this.writeTime = System.currentTimeMillis();
            if (vlogger.isDebugEnabled()) {
                vlogger.debug((Object)("playFrame: bytes written=" + bw + ",open:" + this.line.isOpen()));
            }
            if (this.visualizer != null) {
                this.visualizer.write(this.buf, 0, bw);
            }
        } else {
            bw = 0;
        }
        if (bw < this.bufLen) {
            System.arraycopy(this.buf, bw, this.buf, 0, this.bufLen - bw);
            if (vlogger.isDebugEnabled()) {
                vlogger.warn((Object)("playFrame did not write (" + bw + ") the same number of bytes as read (" + this.bufLen + ")"));
            }
        }
        this.bufLen -= bw;
        this.bufCount += bw;
        if (fillBuf) {
            logger.debug((Object)("playFrame: fill buffer. available=" + this.line.available() + " lineSize=" + this.lineSize + " fillLen=" + fillLen + " bw=" + bw + " slowStart=" + this.slowStart));
            this.slowStart = Math.min(this.slowStart * 2, this.lineSize);
        }
        if (this.bufDuration > 0L) {
            long writeElapsed = this.writeTime - this.readTime;
            if (vlogger.isDebugEnabled()) {
                vlogger.debug((Object)("readTook=" + readElapsed + "ms writeTook=" + writeElapsed + "ms bufferedData=" + this.bufDuration + "ms"));
            }
            if (writeElapsed > this.bufDuration + 150L) {
                logger.debug((Object)("Detected delay writing to audio buffer readTook=" + readElapsed + "ms writeTook=" + writeElapsed + "ms bufferedData=" + this.bufDuration + "ms"));
            }
        }
        this.bufDuration = (long)((float)((this.line.getBufferSize() - this.line.available()) / this.frameSize) / this.frameRate * 1000.0f);
        return bw;
    }

    private Mixer.Info getMixerInfo(String mixerName) {
        if (mixerName == null) {
            return AudioSystem.getMixer(null).getMixerInfo();
        }
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < aInfos.length; ++i) {
            if (!aInfos[i].getName().equals(mixerName)) continue;
            return aInfos[i];
        }
        return null;
    }

    public static String[] getJavaSoundMixers() {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        ArrayList<String> mixers = new ArrayList<String>();
        block0: for (int i = 0; i < mixerInfos.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            Line.Info[] infos = mixer.getSourceLineInfo();
            logger.debug((Object)("found mixer " + mixerInfos[i].getName() + " supports " + infos.length + " lines"));
            for (int j = 0; j < infos.length; ++j) {
                if (!(infos[j] instanceof DataLine.Info)) continue;
                mixers.add(mixerInfos[i].getName());
                continue block0;
            }
        }
        return mixers.toArray(new String[mixers.size()]);
    }

    public static String getDefaultJavaSoundMixer() {
        Mixer.Info info = AudioSystem.getMixer(null).getMixerInfo();
        return info.getName();
    }

    @Override
    public synchronized void bufferEvent(AudioEvent event) {
        switch (event.getId()) {
            case 6: {
                this.reset();
                break;
            }
            case 3: {
                this.framePositionOffset = this.line.getFramePosition();
                break;
            }
            case 8: {
                this.replayGain = event.getReplayGain();
                this.setVolume();
            }
        }
    }
}

