/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.audio.AudioBuffer;
import org.titmuss.softsqueeze.audio.AudioEvent;

public class AudioStream
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)"javasound");
    private static final int DEFAULT_BUFFER_SIZE = 128000;
    private static int audioStreamCount = 0;
    private InputStream audioStream;
    private AudioBuffer audioBuffer;
    private Object lock = new Object();
    private boolean playing = true;
    private int metaint = -1;
    private int bytesUntilMetadata = -1;

    public AudioStream(InputStream audioStream, AudioBuffer audioBuffer, int metaint) {
        this.audioStream = audioStream;
        this.audioBuffer = audioBuffer;
        this.metaint = metaint;
        if (metaint > 0) {
            this.bytesUntilMetadata = metaint;
        }
        Thread t = new Thread((Runnable)this, "AudioStream-" + audioStreamCount++);
        t.setDaemon(true);
        t.start();
    }

    public boolean isOpen() {
        return this.playing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.playing = false;
            this.lock.notifyAll();
        }
    }

    @Override
    public void run() {
        logger.debug((Object)"audio stream started");
        try {
            int n = 0;
            byte[] buf = new byte[128000];
            while (n >= 0 && this.playing) {
                if (this.bytesUntilMetadata > 0) {
                    n = this.audioStream.read(buf, 0, this.bytesUntilMetadata);
                    this.bytesUntilMetadata -= n;
                } else {
                    if (this.bytesUntilMetadata == 0) {
                        this.bytesUntilMetadata = this.metaint;
                        int blockCount = this.audioStream.read();
                        if (blockCount == 0) continue;
                        int blockSize = blockCount * 16;
                        for (n = 0; n < blockSize; n += this.audioStream.read(buf, 0, blockSize - n)) {
                        }
                        String metadata = new String(buf, 0, blockSize);
                        logger.debug((Object)("ICY METADATA:" + metadata));
                        this.audioBuffer.addReadEvent(0L, new AudioEvent(this.audioBuffer, 7, metadata));
                        continue;
                    }
                    n = this.audioStream.read(buf, 0, buf.length);
                    if (n == -1) break;
                }
                n = this.audioBuffer.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in AudioStream", (Throwable)e);
        }
        try {
            this.playing = false;
            this.audioBuffer.close();
            logger.debug((Object)"audio stream closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

