/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.audio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.audio.AudioBuffer;
import org.titmuss.softsqueeze.audio.AudioBufferListener;
import org.titmuss.softsqueeze.audio.AudioDecoder;
import org.titmuss.softsqueeze.audio.AudioEvent;
import org.titmuss.softsqueeze.audio.AudioException;
import org.titmuss.softsqueeze.audio.AudioMixer;
import org.titmuss.softsqueeze.audio.AudioStream;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.config.ConfigListener;
import org.titmuss.softsqueeze.config.ConfigPopup;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.net.ProtocolListener;
import org.titmuss.softsqueeze.visualizer.Visualizer;
import org.titmuss.softsqueeze.visualizer.VisualizerSpectrumAnalyser;
import org.titmuss.softsqueeze.visualizer.VisualizerVUMeter;

public class Player
implements ProtocolListener,
AudioBufferListener,
ConfigListener {
    private static final Logger logger = Logger.getLogger((String)"player");
    private static final Logger vlogger = Logger.getLogger((String)"player.verbose");
    public static final int DEFAULT_BUFFER_SIZE = 128000;
    private Softsqueeze squeeze;
    private Socket audioSocket;
    private PushbackInputStream audioInputStream;
    private AudioMixer audioMixer;
    private AudioDecoder audioDecoder;
    private AudioStream audioStream;
    private AudioBuffer decoderBuffer;
    private AudioBuffer outputBuffer;
    private byte format;
    private int crossfade;
    private int state;
    private boolean autostart;
    private boolean directStream;
    private long statusTime;
    private Object lock = new Object();
    private boolean running = true;
    private int pcmSampleSize;
    private int pcmSampleRate;
    private int pcmChannels;
    private boolean pcmEndian;
    private int autostartThreshold;
    private byte transitionPeriod;
    private byte transitionType;
    private boolean loopSong;
    private float replayGain;
    private int interval;
    private String ipaddr;
    private int port;
    private String httpHeaders;
    private float leftLevel = 0.0f;
    private float rightLevel = 0.0f;
    private Visualizer visualizer;
    private byte[] visualizerFrame = new byte[0];
    private String lastMetaData = null;
    public static final int DISCONNECTED = 0;
    public static final int CONNECTED = 1;
    public static final int BUFFERING = 2;
    public static final int PLAYING = 3;
    public static final int PAUSED = 4;
    private static final int DECODER_BUFFER_SIZE = 0x100000;
    private static final int OUTPUT_BUFFER_SIZE = 3528000;
    private static final int OUTPUT_BUFFER_THRESHOLD = 1;

    public Player(Softsqueeze squeeze) {
        this.squeeze = squeeze;
        this.state = 0;
        squeeze.getProtocol().addProtocolListener("strm", this);
        squeeze.getProtocol().addProtocolListener("cont", this);
        squeeze.getProtocol().addProtocolListener("body", this);
        squeeze.getProtocol().addProtocolListener("audg", this);
        squeeze.getProtocol().addProtocolListener("visu", this);
        squeeze.getProtocol().addProtocolListener("stat", this);
        squeeze.getProtocol().addProtocolListener("visg", this);
        Config.addConfigListener(this);
        this.outputBuffer = new AudioBuffer(3528000);
        this.outputBuffer.addListener(this);
        this.initMixer();
        Thread t = new Thread((Runnable)new PlayerStatus(), "Player Status");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void configSet(String key, String value) {
        if (key.equals("audio.mixer") || key.equals("audio.lineBufferSize")) {
            this.initMixer();
        }
    }

    public void initMixer() {
        try {
            if (this.audioMixer != null) {
                this.audioMixer.stop();
            }
            this.audioMixer = new AudioMixer(this.outputBuffer);
            this.audioMixer.setVolume(this.leftLevel, this.rightLevel);
            this.audioMixer.setVisualizer(this.visualizer);
            if (this.state == 3) {
                this.audioMixer.play(0L);
            }
        }
        catch (AudioException e) {
            logger.error((Object)"Changing mixer", (Throwable)e);
        }
        catch (LineUnavailableException e) {
            ConfigPopup.showErrorDialog("Sorry SoftSqueeze could not find a sound card on your computer.", "No Sound Card Detected");
        }
    }

    @Override
    public void slimprotoCmd(String cmd, byte[] buf, int off, int len) {
        if (cmd.equals("strm")) {
            char scmd = this.parseStream(buf, off, len);
            try {
                switch (scmd) {
                    case 's': {
                        this.connect();
                        this.autostart();
                        break;
                    }
                    case 'u': {
                        this.start(this.interval);
                        break;
                    }
                    case 'p': {
                        this.pause(this.interval);
                        break;
                    }
                    case 'q': {
                        this.disconnect();
                        break;
                    }
                    case 'f': {
                        this.flush();
                        break;
                    }
                    case 't': {
                        this.sendStatus("STMt", this.interval);
                        break;
                    }
                    case 'a': {
                        this.skipAhead(this.interval);
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unknown strm command " + scmd));
                        break;
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"strm IO error", (Throwable)e);
            }
            catch (AudioException e) {
                logger.error((Object)"strm Audio error", (Throwable)e);
            }
        } else if (cmd.equals("stat")) {
            try {
                this.sendStatus("stat");
            }
            catch (IOException scmd) {}
        } else if (cmd.equals("cont")) {
            try {
                int metaint = Protocol.unpackN4(buf, off);
                this.loopSong = (buf[off + 4] & 1) == 1;
                this.cont(metaint);
            }
            catch (AudioException e) {
                logger.error((Object)"cont Audio error", (Throwable)e);
            }
        } else if (cmd.equals("body")) {
            try {
                int length = Protocol.unpackN4(buf, off);
                this.body(length);
            }
            catch (IOException e) {
                logger.error((Object)"cont Audio error", (Throwable)e);
            }
        } else if (cmd.equals("audg")) {
            int oldLeft = Protocol.unpackN4(buf, off);
            int oldRight = Protocol.unpackN4(buf, off + 4);
            this.leftLevel = Protocol.unpackFixedPoint(buf, off + 10);
            this.rightLevel = Protocol.unpackFixedPoint(buf, off + 14);
            logger.debug((Object)("audg oldLeft=" + oldLeft + " oldRight=" + oldRight + " newLeft=" + this.leftLevel + " newRight=" + this.rightLevel));
            this.audioMixer.setVolume(this.leftLevel, this.rightLevel);
        } else if (cmd.equals("visu")) {
            int frameLen = len - off;
            if (frameLen == this.visualizerFrame.length) {
                int i = 0;
                while (i < this.visualizerFrame.length && buf[off + i] == this.visualizerFrame[i++]) {
                }
                if (frameLen == i) {
                    return;
                }
            }
            this.visualizerFrame = new byte[frameLen];
            System.arraycopy(buf, off, this.visualizerFrame, 0, frameLen);
            byte visType = buf[off];
            switch (visType) {
                case 1: {
                    this.visualizer = new VisualizerVUMeter(this.squeeze, buf, off, len);
                    break;
                }
                case 2: {
                    this.visualizer = new VisualizerSpectrumAnalyser(this.squeeze, buf, off, len);
                    break;
                }
                default: {
                    this.visualizer = null;
                }
            }
            this.audioMixer.setVisualizer(this.visualizer);
        } else if (cmd.equals("visg")) {
            VisualizerVUMeter.uploadGraphic(buf, off, len);
        }
    }

    @Override
    public void slimprotoConnected() {
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.audioMixer.setVisualizer(this.visualizer);
    }

    @Override
    public void slimprotoDisconnected() {
        this.audioMixer.setVisualizer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException, AudioException {
        logger.debug((Object)("connect: state " + this.state));
        Object object = this.lock;
        synchronized (object) {
            int i;
            int bufLen;
            int n;
            if (this.audioSocket != null) {
                this.audioSocket.close();
            }
            logger.debug((Object)("http connect: ipaddr=" + this.ipaddr + " port=" + this.port));
            this.audioSocket = new Socket(this.ipaddr, this.port);
            int tcpwindow = Config.getIntegerProperty("audio.tcpwindowsize");
            if (tcpwindow > 0) {
                this.audioSocket.setReceiveBufferSize(tcpwindow);
                Config.putIntegerProperty("audio.tcpwindowsize", this.audioSocket.getReceiveBufferSize());
            }
            this.audioInputStream = new PushbackInputStream(this.audioSocket.getInputStream(), 128000);
            OutputStream audioOutputStream = this.audioSocket.getOutputStream();
            this.sendStatus("STMc");
            if (this.httpHeaders.endsWith("\r\n\r\n\r\n")) {
                this.httpHeaders = this.httpHeaders.substring(0, this.httpHeaders.length() - 2);
            }
            logger.debug((Object)("http write headers: " + this.httpHeaders));
            audioOutputStream.write(this.httpHeaders.getBytes());
            audioOutputStream.flush();
            byte[] buf = new byte[2048];
            for (bufLen = 0; bufLen < buf.length; bufLen += n) {
                n = this.audioInputStream.read(buf, bufLen, buf.length - bufLen);
                if (n != -1) continue;
                logger.debug((Object)("end of stream reading headers: " + bufLen));
                break;
            }
            if (bufLen == 0) {
                this.squeeze.getProtocol().sendDsco(3);
                throw new AudioException("Cannot read http headers");
            }
            for (i = 0; i < bufLen - 5 && (buf[i] != 13 || buf[i + 1] != 10 || buf[i + 2] != 13 || buf[i + 3] != 10); ++i) {
            }
            logger.debug((Object)("http read header: (len " + (i += 4) + "/" + bufLen + ") " + new String(buf, 0, i)));
            this.audioInputStream.unread(buf);
            this.audioInputStream.skip(i);
            this.sendStatus("STMh");
            this.state = 1;
            if (this.directStream) {
                this.squeeze.getProtocol().sendResp(new String(buf, 0, i));
            } else {
                this.initStream(-1);
            }
        }
    }

    private void cont(int metaint) throws AudioException {
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                return;
            }
            default: {
                throw new IllegalStateException("Cannot cont in state: " + this.state);
            }
        }
        logger.debug((Object)("http cont: metaint=" + metaint + " loop=" + this.loopSong));
        this.initStream(metaint);
    }

    private void body(int length) throws IOException {
        switch (this.state) {
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot body in state: " + this.state);
            }
        }
        logger.debug((Object)("http body: length=" + length));
        int bufLen = length > 0 ? length : Integer.MAX_VALUE;
        byte[] buf = new byte[4096];
        int n = this.audioInputStream.read(buf, 0, Math.min(bufLen, buf.length));
        while (n > 0 && bufLen > 0) {
            this.squeeze.getProtocol().sendBody(new String(buf, 0, n));
            n = this.audioInputStream.read(buf, 0, Math.min(bufLen -= n, buf.length));
        }
        this.squeeze.getProtocol().sendBody("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStream(int metaint) throws AudioException {
        Object object = this.lock;
        synchronized (object) {
            AudioFormat audioFormat;
            logger.debug((Object)("initStream: state " + this.state));
            if (this.format == 109) {
                audioFormat = new AudioFormat(AudioDecoder.MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false);
            } else if (this.format == 102) {
                audioFormat = new AudioFormat(AudioDecoder.FLAC, 44100.0f, -1, 2, -1, -1.0f, false);
            } else if (this.format == 112) {
                float[] pcmSampleRates = new float[]{11025.0f, 22050.0f, 32000.0f, 44100.0f, 48000.0f, 8000.0f, 12000.0f, 16000.0f, 24000.0f, 96000.0f};
                int[] pcmSampleWidths = new int[]{8, 16, 24, 32};
                float sampleRate = pcmSampleRates[this.pcmSampleRate];
                int sizeInBits = pcmSampleWidths[this.pcmSampleSize];
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, this.pcmChannels, this.pcmChannels * (sizeInBits / 8), sampleRate, this.pcmEndian);
            } else if (this.format == 111) {
                audioFormat = new AudioFormat(AudioDecoder.OGG, 44100.0f, -1, 2, -1, -1.0f, false);
            } else {
                throw new AudioException("Unknown audio format requested: " + this.format);
            }
            this.decoderBuffer = new AudioBuffer(0x100000);
            this.decoderBuffer.setAudioFormat(audioFormat);
            this.decoderBuffer.addListener(this);
            this.decoderBuffer.addWriteEvent(this.autostartThreshold, new AudioEvent(this.decoderBuffer, 4));
            this.outputBuffer.addWriteEvent(1L, new AudioEvent(this.outputBuffer, 4));
            if (this.loopSong) {
                this.decoderBuffer.setRepeat(true);
            }
            this.audioStream = new AudioStream(this.audioInputStream, this.decoderBuffer, metaint);
            this.audioDecoder = new AudioDecoder(this.decoderBuffer, this.outputBuffer, this.replayGain);
            this.state = 2;
            this.audioDecoder.play();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        logger.debug((Object)("disconnect: state " + this.state));
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                return;
            }
            if (this.state > 2) {
                this.audioDecoder.stop();
                this.decoderBuffer.close();
                this.audioStream.stop();
                this.audioMixer.flush();
            }
            this.audioSocket.close();
            this.audioInputStream = null;
            this.audioSocket = null;
            this.audioStream = null;
            this.decoderBuffer = null;
            this.audioDecoder = null;
            if (this.autostart) {
                this.sendStatus("STMf");
            }
            this.state = 0;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        logger.debug((Object)("flush: state " + this.state));
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                return;
            }
            this.audioDecoder.flush();
            this.audioStream = null;
            this.decoderBuffer = null;
            this.audioDecoder = null;
            this.state = 3;
            this.lock.notifyAll();
        }
    }

    private void autostart() throws IOException, AudioException {
        logger.debug((Object)("autostart: state " + this.state));
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("Cannot autostart in disconnected state");
            }
            case 1: 
            case 3: {
                return;
            }
            case 4: {
                this.unpause();
                return;
            }
        }
        long fullness = this.getBufferFullness();
        logger.debug((Object)("autostart: fullness=" + fullness + " threshold=" + this.autostartThreshold));
        if (fullness < (long)this.autostartThreshold) {
            return;
        }
        if (!this.autostart) {
            this.sendStatus("STMl");
        } else {
            this.start(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(int atJiffies) throws IOException, AudioException {
        logger.debug((Object)("start: state " + this.state + ", atJiffies=" + atJiffies));
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 3) {
                return;
            }
            if (this.state == 0) {
                this.connect();
            }
            this.audioMixer.play(atJiffies != 0 ? this.squeeze.getProtocol().getEpoch() + (long)atJiffies : 0L);
            this.state = 3;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpause() throws IOException {
        logger.debug((Object)("start: state " + this.state));
        Object object = this.lock;
        synchronized (object) {
            this.audioMixer.play(0L);
            this.sendStatus("STMr");
            this.state = 3;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause(int interval) throws IOException {
        logger.debug((Object)("pause: state " + this.state + ", interval " + interval));
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 3) {
                return;
            }
            this.audioMixer.pause(interval);
            if (interval == 0) {
                this.sendStatus("STMp");
                this.state = 4;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipAhead(int interval) throws IOException {
        logger.debug((Object)("skipahead: interval " + interval));
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 3) {
                return;
            }
            this.audioMixer.skipAhead(interval);
            this.lock.notifyAll();
        }
    }

    private void sendStatus(String status) throws IOException {
        this.sendStatus(status, 0);
    }

    private void sendStatus(String status, int timestamp) throws IOException {
        int decoderFullness;
        byte crlf = 0;
        byte masInit = this.format;
        byte masMode = 1;
        if (this.decoderBuffer == null) {
            decoderFullness = 0;
            logger.debug((Object)("buffer null state " + this.state));
        } else if (this.state == 2) {
            decoderFullness = (int)this.decoderBuffer.getWriteCount();
            logger.debug((Object)("write count " + this.decoderBuffer.getWriteCount() + " available " + this.decoderBuffer.available()));
        } else {
            decoderFullness = this.decoderBuffer.available();
            vlogger.debug((Object)("write count " + this.decoderBuffer.getWriteCount() + " available " + this.decoderBuffer.available()));
        }
        long bytesRx = this.decoderBuffer == null ? 0L : this.decoderBuffer.getWriteCount();
        byte signal = -1;
        int outputFullness = this.outputBuffer.available();
        long elapsedMilliseconds = this.audioMixer.getElapsedMilliseconds();
        this.statusTime = System.currentTimeMillis();
        if (vlogger.isDebugEnabled()) {
            if (this.decoderBuffer != null) {
                logger.debug((Object)("decode: " + (double)((float)this.decoderBuffer.available() / (float)this.decoderBuffer.getBufferSize()) * 100.0 + " avail=" + this.decoderBuffer.available() + " size=" + this.decoderBuffer.getBufferSize()));
            }
            logger.debug((Object)("output: " + (double)((float)this.outputBuffer.available() / (float)this.outputBuffer.getBufferSize()) * 100.0 + " avail=" + this.outputBuffer.available() + " size=" + this.outputBuffer.getBufferSize()));
            vlogger.debug((Object)("status=" + status + " fullness=" + decoderFullness + " bytesRx=" + bytesRx + " elapsedMilliseconds=" + elapsedMilliseconds));
        } else if (!status.equals("STMt") && logger.isDebugEnabled()) {
            logger.debug((Object)("status=" + status + " fullness=" + decoderFullness + " bytesRx=" + bytesRx + " elapsedMilliseconds=" + elapsedMilliseconds));
        }
        this.squeeze.getProtocol().sendStat(status, crlf, masInit, masMode, 0x100000, decoderFullness, bytesRx, signal, 3528000, outputFullness, elapsedMilliseconds, timestamp);
    }

    @Override
    public void bufferEvent(AudioEvent event) {
        AudioBuffer buffer = (AudioBuffer)event.getSource();
        try {
            switch (event.getId()) {
                case 1: {
                    vlogger.debug((Object)("buffer underrun; audioStream=" + this.audioStream + " isOpen=" + (this.audioStream != null && this.audioStream.isOpen() ? "open" : "closed")));
                    if (buffer != this.outputBuffer || this.audioStream != null && this.audioStream.isOpen()) break;
                    this.audioMixer.drain();
                    this.sendStatus("STMu");
                    break;
                }
                case 3: {
                    this.sendStatus("STMs");
                    break;
                }
                case 4: {
                    if (this.state != 2) break;
                    this.autostart();
                    break;
                }
                case 0: {
                    if (buffer == this.decoderBuffer) {
                        this.squeeze.getProtocol().sendDsco(0);
                    }
                    if (buffer != this.decoderBuffer || this.state != 2) break;
                    logger.debug((Object)"audio stream closed while buffering, starting playback");
                    this.start(0);
                    break;
                }
                case 9: {
                    if (buffer != this.outputBuffer) break;
                    this.sendStatus("STMd");
                    break;
                }
                case 7: {
                    if (!event.getMetadata().equals(this.lastMetaData)) {
                        this.squeeze.getProtocol().sendMeta(event.getMetadata());
                    }
                    this.lastMetaData = event.getMetadata();
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"buffer underrun IO error", (Throwable)e);
        }
        catch (AudioException e) {
            logger.error((Object)"audio exception", (Throwable)e);
        }
    }

    private int getBufferFullness() throws IOException {
        if (this.outputBuffer.available() < 1) {
            return 0;
        }
        return (int)this.decoderBuffer.getWriteCount();
    }

    private char parseStream(byte[] buf, int start, int len) {
        char cmd = (char)buf[start];
        byte autostartFlag = buf[start + 1];
        String spdifEnable = new String(buf, start + 8, 1);
        this.transitionPeriod = buf[start + 9];
        this.transitionType = buf[start + 10];
        this.loopSong = buf[start + 11] == 49;
        switch (cmd) {
            case 's': {
                this.format = buf[start + 2];
                this.pcmSampleSize = buf[start + 3] - 48;
                this.pcmSampleRate = buf[start + 4] - 48;
                this.pcmChannels = buf[start + 5] - 48;
                this.pcmEndian = "0".equals(new String(buf, start + 6, 1));
                this.autostart = autostartFlag == 49 || autostartFlag == 51;
                this.directStream = autostartFlag == 50 || autostartFlag == 51 || autostartFlag == 52;
                this.autostartThreshold = (buf[start + 7] & 0xFF) * 1024;
                this.replayGain = Protocol.unpackFixedPoint(buf, start + 14);
                if (this.replayGain != 0.0f) break;
                this.replayGain = 1.0f;
                break;
            }
            case 'a': 
            case 'p': 
            case 't': 
            case 'u': {
                this.interval = Protocol.unpackN4(buf, start + 14);
            }
        }
        this.port = Protocol.unpackN2(buf, start + 18);
        StringBuffer ipaddrBuf = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            ipaddrBuf.append(Integer.toString(buf[start + 20 + i] & 0xFF));
            if (i >= 3) continue;
            ipaddrBuf.append(".");
        }
        this.ipaddr = ipaddrBuf.toString();
        if (this.ipaddr.equals("0.0.0.0")) {
            this.ipaddr = Config.getSlimServerAddress();
        }
        this.httpHeaders = new String(buf, start + 24, len - start - 24);
        logger.debug((Object)("httpRequest=" + this.httpHeaders));
        logger.debug((Object)("parsed strm: command=" + cmd + " format=" + this.format + " crossfade=" + this.crossfade + " replygain=" + this.replayGain + " ipaddr=" + this.ipaddr + " port=" + this.port + " autostart=" + this.autostart + " autostartThreshold=" + this.autostartThreshold));
        return cmd;
    }

    private class PlayerStatus
    implements Runnable {
        private PlayerStatus() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = Player.this.lock;
            synchronized (object) {
                while (Player.this.running) {
                    while (Player.this.state != 2 && Player.this.state != 3) {
                        try {
                            Player.this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    long timeout = Player.this.statusTime - System.currentTimeMillis() + 1000L;
                    while ((Player.this.state == 3 || Player.this.state == 2) && timeout > 0L) {
                        try {
                            Player.this.lock.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        timeout = Player.this.statusTime - System.currentTimeMillis() + 1000L;
                    }
                    try {
                        Player.this.sendStatus("STMt");
                    }
                    catch (IOException e) {
                        logger.error((Object)"PlayerStatus IO Error", (Throwable)e);
                    }
                }
                return;
            }
        }
    }
}

