/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.config;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Applet;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.audio.AudioDecoder;
import org.titmuss.softsqueeze.audio.AudioMixer;
import org.titmuss.softsqueeze.config.ConfigListener;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.util.Util;

public class Config {
    private static Logger logger = Logger.getLogger((String)"config");
    private static final String CONFIG_VERSION = "5";
    private static char[] crypt = "qatu63hoxxoh0zrhd0djf5zkc6e38cpw".toCharArray();
    private static Config instance;
    private static ArrayList listeners;
    private Applet applet;
    private Preferences prefs = null;
    private HashMap config = new HashMap();
    private HashMap defval = new HashMap();
    private static String slimNetwork;

    public static Config init() {
        return Config.init(null);
    }

    public static Config init(Applet applet) {
        if (instance == null) {
            instance = new Config(applet);
        }
        return instance;
    }

    public static void addConfigListener(ConfigListener listener) {
        listeners.add(listener);
    }

    public static void removeConfigListener(ConfigListener listener) {
        listeners.remove(listener);
    }

    public static void setSlimNetworkServer(String slimNetworkAddr) {
        slimNetwork = slimNetworkAddr;
    }

    public static boolean useSSH() {
        if (slimNetwork != null) {
            return false;
        }
        return Config.getBooleanProperty("sshtunnel");
    }

    public static String getSlimServerAddress() {
        if (slimNetwork != null) {
            return slimNetwork;
        }
        if (Config.getBooleanProperty("sshtunnel")) {
            return "127.0.0.1";
        }
        return Config.getProperty("slimserver");
    }

    public static String getSSHProxy() {
        if (slimNetwork != null) {
            return "None";
        }
        return Config.getProperty("sshproxy");
    }

    public static String getSSHProxyHost() {
        return Config.getProperty("sshproxyhost");
    }

    public static int getSSHProxyPort() {
        return Config.getIntegerProperty("sshproxyport");
    }

    public static int getServerHttpPort() {
        if (slimNetwork != null) {
            return 9000;
        }
        return Config.getIntegerProperty("httpport");
    }

    public static int getServerWebPort() {
        if (slimNetwork != null) {
            return 9000;
        }
        if (Config.getBooleanProperty("sshtunnel")) {
            return Config.getIntegerProperty("httpport") + 1;
        }
        return Config.getIntegerProperty("httpport");
    }

    public static int getSlimProtoPort() {
        if (slimNetwork != null) {
            return 3483;
        }
        return Config.getIntegerProperty("slimport");
    }

    public static char[] getPassword(String key) {
        try {
            String[] c = Util.split(Config.getProperty(key), ",");
            char[] password = new char[c.length];
            for (int i = 0; i < c.length; ++i) {
                password[i] = (char)Integer.parseInt(c[i], 16);
            }
            return Config.crypt(password);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            return new char[0];
        }
    }

    public static void putPassword(String key, char[] password) {
        if (password == null) {
            Config.putProperty(key, "");
            return;
        }
        password = Config.crypt(password);
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < password.length; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(Integer.toString(password[i], 16));
        }
        Config.putProperty(key, b.toString());
    }

    private static char[] crypt(char[] password) {
        int j = 0;
        for (int i = 0; i < password.length; ++i) {
            int n = i;
            char c = (char)(password[n] ^ crypt[j++]);
            password[n] = c;
            password[i] = c;
            if (j < crypt.length) continue;
            j = 0;
        }
        return password;
    }

    public static boolean isHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        String skin = Config.getProperty("skins");
        if (skin == null) {
            skin = Config.getProperty("skin");
        }
        return skin != null && skin.equalsIgnoreCase("headless");
    }

    public static String getProperty(String key) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        return instance._getProperty(key);
    }

    public static boolean getBooleanProperty(String key) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        return instance._getBooleanProperty(key);
    }

    public static int getIntegerProperty(String key) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        return instance._getIntegerProperty(key);
    }

    public static void putProperty(String key, String val) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        instance._putProperty(key, val);
    }

    public static void putBooleanProperty(String key, boolean val) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        instance._putBooleanProperty(key, val);
    }

    public static void putIntegerProperty(String key, int val) {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        instance._putIntegerProperty(key, val);
    }

    public static void resetProperties() {
        if (instance == null) {
            throw new IllegalStateException("Config is not initialised");
        }
        instance._loadProp(true);
    }

    private Config(Applet applet) {
        this.applet = applet;
        boolean doReset = false;
        if (Platform.JRE_1_4_PLUS) {
            this.prefs = Preferences.userNodeForPackage(Softsqueeze.class);
            String reset = System.getProperty("deletePreferences", "false");
            if (reset.equalsIgnoreCase("true")) {
                doReset = true;
            }
            if (!this.prefs.get("version", "0").equals(CONFIG_VERSION)) {
                doReset = true;
            }
        }
        this._loadProp(doReset);
    }

    private void _loadProp(boolean reset) {
        String macaddress = this._getProperty("macaddress");
        if (reset) {
            logger.info((Object)"Reseting user preferences");
            try {
                this.prefs.removeNode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.prefs = Preferences.userNodeForPackage(Softsqueeze.class);
            this.prefs.put("version", CONFIG_VERSION);
            this.config.clear();
        }
        if (macaddress != null) {
            this._putProperty("macaddress", macaddress);
        }
        Properties props = new Properties();
        try {
            InputStream propsin = this.getClass().getResourceAsStream("/Softsqueeze.properties");
            if (propsin != null) {
                props.load(propsin);
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error reading property file", (Throwable)e);
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            if (this._getProperty(key) == null) {
                this._putProperty(key, (String)e.getValue());
            }
            if (!key.equals("sshport") || this._getProperty(key).length() != 0) continue;
            this._putProperty(key, (String)e.getValue());
        }
        this._putProperty("softsqueezeversion", props.getProperty("softsqueezeversion"));
        this._putProperty("deviceid", props.getProperty("deviceid"));
        this._putProperty("firmwareversion", props.getProperty("firmwareversion"));
        if (this._getProperty("macaddress") == null) {
            this._putProperty("macaddress", Platform.macAddressToString(Platform.getMacAddress()));
        }
        if (this._getProperty("sshserver") == null) {
            this._putProperty("sshserver", this._getProperty("slimserver"));
        }
        if (this._getProperty("audio.mixer") == null) {
            this._putProperty("audio.mixer", AudioMixer.getDefaultJavaSoundMixer());
        }
        if (this._getProperty("audio.mp3decoder") == null) {
            this._putProperty("audio.mp3decoder", AudioDecoder.getDefaultMP3Decoder());
        }
    }

    private String _getProperty(String key) {
        if (this.config.containsKey(key)) {
            return (String)this.config.get(key);
        }
        String val = (String)this.defval.get(key);
        if (Platform.JRE_1_4_PLUS) {
            val = this.prefs.get(key, val);
        }
        String prop = null;
        prop = this.applet == null ? System.getProperty(key, null) : this.applet.getParameter(key);
        val = prop == null ? val : prop;
        this.config.put(key, val);
        logger.debug((Object)("getProperty " + key + "=" + val));
        return val;
    }

    private boolean _getBooleanProperty(String key) {
        String val = this._getProperty(key);
        return val == null ? false : val.equals("true");
    }

    private int _getIntegerProperty(String key) {
        try {
            String val = this._getProperty(key);
            return val == null ? -1 : Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void _putProperty(String key, String val) {
        logger.debug((Object)("putProperty " + key + "=" + val));
        String old = this.config.put(key, val);
        if (Platform.JRE_1_4_PLUS) {
            this.prefs.put(key, val);
        }
        if (val.equals(old)) {
            return;
        }
        logger.debug((Object)("property changed key=" + key + " val=" + val + " old=" + old));
        ArrayList clone = (ArrayList)listeners.clone();
        for (ConfigListener l : clone) {
            l.configSet(key, val);
        }
    }

    private void _putBooleanProperty(String key, boolean val) {
        this._putProperty(key, val ? "true" : "false");
    }

    private void _putIntegerProperty(String key, int val) {
        this._putProperty(key, Integer.toString(val));
    }

    static {
        listeners = new ArrayList();
        slimNetwork = null;
    }
}

