/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.titmuss.softsqueeze.audio.AudioDecoder;
import org.titmuss.softsqueeze.audio.AudioMixer;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigDialog
implements ItemListener {
    private Logger logger = Logger.getLogger((String)"config");
    private JTabbedPane tabbedPane;
    private DefaultComboBoxModel slimserverAddr = new DefaultComboBoxModel();
    private DefaultComboBoxModel softsqueezeSkin = new DefaultComboBoxModel<String>(new String[]{"excession", "lcd", "slimdevices", "woodgrain"});
    private DefaultComboBoxModel softsqueezeDisplay = new DefaultComboBoxModel<String>(new String[]{"Squeezebox2", "Graphics", "Noritake"});
    private DefaultComboBoxModel sshProxyTypeModel = new DefaultComboBoxModel<String>(new String[]{"None", "HTTP", "Socks 5"});
    private HashMap slimservers;
    private JComboBox slimserverAddr1 = new JComboBox(this.slimserverAddr);
    private JComboBox softsqueezeSkin1 = new JComboBox(this.softsqueezeSkin);
    private JLabel javaVersion = new JLabel();
    private JLabel softsqueezeVersion = new JLabel();
    private JLabel slimserverVersion = new JLabel();
    private JComboBox slimserverAddr2 = new JComboBox(this.slimserverAddr);
    private JComboBox softsqueezeSkin2 = new JComboBox(this.softsqueezeSkin);
    private JComboBox softsqueezeDisplay1 = new JComboBox(this.softsqueezeDisplay);
    private JCheckBox softsqueezeOnTop = new JCheckBox();
    private JCheckBox systemtray = new JCheckBox();
    private JCheckBox touchscreenMode = new JCheckBox();
    private JComboBox audioMixer = new JComboBox();
    private JComboBox audioMP3Decoder = new JComboBox();
    private JButton getJavaMP3Decoder = new JButton("Download Java MP3 Plugin");
    private JTextPane helpJavaMP3Decoder = new JTextPane();
    private JTextField audioBufferSize = new JTextField(20);
    private JCheckBox saveStream = new JCheckBox();
    private JTextField saveFolder = new JTextField(20);
    private JButton saveFolderFile = new JButton("File");
    private JTextField slimserverHttpPort = new JTextField(6);
    private JTextField slimserverSlimPort = new JTextField(6);
    private JTextField softsqueezeMacAddress = new JTextField(20);
    private JTextField tcpWindowSize = new JTextField(20);
    private JCheckBox sshTunnel = new JCheckBox();
    private JTextField sshPort = new JTextField(6);
    private JComboBox sshServerAddr = new JComboBox();
    private JTextField sshUsername = new JTextField(20);
    private JPasswordField sshPassword = new JPasswordField(20);
    private JCheckBox sshStorePassword = new JCheckBox();
    private JTextField sshKeys = new JTextField(20);
    private JButton sshKeysFile = new JButton("File ...");
    private JTextField sshPortForward = new JTextField(20);
    private JComboBox sshProxy = new JComboBox(this.sshProxyTypeModel);
    private JTextField sshProxyHost = new JTextField(20);
    private JTextField sshProxyPort = new JTextField(20);
    private JCheckBox debugAudioBuffer = new JCheckBox();
    private JCheckBox debugAudioBufferVerbose = new JCheckBox();
    private JCheckBox debugConfig = new JCheckBox();
    private JCheckBox debugGraphics = new JCheckBox();
    private JCheckBox debugJavaSound = new JCheckBox();
    private JCheckBox debugJavaSoundVerbose = new JCheckBox();
    private JCheckBox debugPlatform = new JCheckBox();
    private JCheckBox debugPlayer = new JCheckBox();
    private JCheckBox debugPlayerVerbose = new JCheckBox();
    private JCheckBox debugSearch = new JCheckBox();
    private JCheckBox debugSkin = new JCheckBox();
    private JCheckBox debugSlimproto = new JCheckBox();
    private JCheckBox debugCli = new JCheckBox();
    private JCheckBox debugSoftsqueeze = new JCheckBox();
    private JCheckBox debugSsh = new JCheckBox();
    private JCheckBox debugVisualizer = new JCheckBox();
    private JTextArea console = new JTextArea(20, 60);
    private JButton clearConsole = new JButton("Clear");
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private Insets ci = new Insets(1, 1, 1, 1);
    private JPanel skinPanel;
    private ArrayList selectFields = new ArrayList();
    private Skin skin;

    public ConfigDialog() {
        this.tabbedPane = new JTabbedPane();
        JPanel basicPanel = new JPanel(this.gridbag);
        basicPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Basic", basicPanel);
        this.add(basicPanel, "Squeezebox Server Hostname", this.slimserverAddr1);
        this.separator(basicPanel);
        this.add(basicPanel, "SoftSqueeze Skin", this.softsqueezeSkin1);
        this.separator(basicPanel);
        this.add(basicPanel, "Java version", this.javaVersion);
        this.add(basicPanel, "SoftSqueeze version", this.softsqueezeVersion);
        this.add(basicPanel, "Squeezebox Server version", this.slimserverVersion);
        this.padding(basicPanel);
        this.skinPanel = new JPanel(this.gridbag);
        this.skinPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Skin", this.skinPanel);
        JPanel audioPanel = new JPanel(this.gridbag);
        audioPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Audio", audioPanel);
        this.add(audioPanel, "Audio mixer", this.audioMixer);
        this.add(audioPanel, "Audio buffer size", this.audioBufferSize);
        this.add(audioPanel, "MP3 Decoder", this.audioMP3Decoder);
        this.add(audioPanel, null, this.helpJavaMP3Decoder);
        this.add(audioPanel, null, this.getJavaMP3Decoder);
        this.padding(audioPanel);
        JPanel netPanel = new JPanel(this.gridbag);
        netPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Networking", netPanel);
        this.add(netPanel, "Squeezebox Server Hostname", this.slimserverAddr2);
        this.add(netPanel, "Squeezebox Server HTTP Port", this.slimserverHttpPort);
        this.add(netPanel, "Squeezebox Server SlimProto Port", this.slimserverSlimPort);
        this.separator(netPanel);
        this.add(netPanel, "SoftSqueeze MAC Address", this.softsqueezeMacAddress);
        this.add(netPanel, "Tcp Window Size", this.tcpWindowSize);
        this.padding(netPanel);
        JPanel sshPanel = new JPanel(this.gridbag);
        sshPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("SSH", sshPanel);
        this.add(sshPanel, "Use SSH tunnel", this.sshTunnel);
        this.add(sshPanel, "SSH server", this.sshServerAddr);
        this.add(sshPanel, "SSH port", this.sshPort);
        this.add(sshPanel, "SSH username", this.sshUsername);
        this.add(sshPanel, "SSH password", this.sshPassword);
        this.add(sshPanel, "Store password", this.sshStorePassword);
        this.add(sshPanel, "SSH private keys", this.sshKeys, this.sshKeysFile);
        this.add(sshPanel, "Forward additional ports", this.sshPortForward);
        this.separator(sshPanel);
        this.add(sshPanel, "SSH Proxy", this.sshProxy);
        this.add(sshPanel, "SSH Proxy host", this.sshProxyHost);
        this.add(sshPanel, "SSH Proxy port", this.sshProxyPort);
        this.padding(sshPanel);
        JPanel debugPanel = new JPanel(this.gridbag);
        debugPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Debug", debugPanel);
        this.add(debugPanel, "Audio Buffer", this.debugAudioBuffer);
        this.add(debugPanel, "Audio Buffer (verbose)", this.debugAudioBufferVerbose);
        this.add(debugPanel, "Configuration", this.debugConfig);
        this.add(debugPanel, "Graphics", this.debugGraphics);
        this.add(debugPanel, "Java Sound", this.debugJavaSound);
        this.add(debugPanel, "Java Sound (verbose)", this.debugJavaSoundVerbose);
        this.add(debugPanel, "Platform", this.debugPlatform);
        this.add(debugPanel, "Player", this.debugPlayer);
        this.add(debugPanel, "Player (verbose)", this.debugPlayerVerbose);
        this.add(debugPanel, "Search", this.debugSearch);
        this.add(debugPanel, "Skin", this.debugSkin);
        this.add(debugPanel, "Slimproto (verbose)", this.debugSlimproto);
        this.add(debugPanel, "Cli (verbose)", this.debugCli);
        this.add(debugPanel, "SoftSqueeze", this.debugSoftsqueeze);
        this.add(debugPanel, "SSH", this.debugSsh);
        this.add(debugPanel, "Visualizer", this.debugVisualizer);
        this.padding(debugPanel);
        JPanel consolePanel = new JPanel(this.gridbag);
        consolePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add("Console", consolePanel);
        this.add(consolePanel, new JScrollPane(this.console, 22, 32));
        this.add(consolePanel, this.clearConsole);
        this.slimserverAddr1.setEditable(true);
        this.slimserverAddr2.setEditable(true);
        this.sshTunnel.addItemListener(this);
        this.sshServerAddr.setEditable(true);
        this.sshProxy.addItemListener(this);
        this.saveStream.addItemListener(this);
        this.saveFolderFile.addActionListener(new FileAction(audioPanel, "Save Streams Folder", this.saveFolder, 1));
        this.sshKeysFile.addActionListener(new FileAction(sshPanel, "Private Key File", this.sshKeys, 0));
        String[] audioMixers = AudioMixer.getJavaSoundMixers();
        for (int i = 0; i < audioMixers.length; ++i) {
            this.audioMixer.addItem(audioMixers[i]);
        }
        String[] audioMP3Decoders = AudioDecoder.getMP3Decoders();
        for (int i = 0; i < audioMP3Decoders.length; ++i) {
            this.audioMP3Decoder.addItem(audioMP3Decoders[i]);
        }
        this.helpJavaMP3Decoder.setOpaque(true);
        this.helpJavaMP3Decoder.setEditable(false);
        this.helpJavaMP3Decoder.setPreferredSize(new Dimension(200, 40));
        this.helpJavaMP3Decoder.setText("You do not have the 'Java MP3 Plugin' installed. This plugin is optional, but if installed it will improve SoftSqueeze's performance when playing MP3 files.");
        this.getJavaMP3Decoder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.displayUrl("http://softsqueeze.sourceforge.net/javamp3plugin.html");
            }
        });
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.addAppender((Appender)new LogAppender());
    }

    private void buildSkinConfig(String prefix, Element config) {
        this.selectFields.clear();
        this.skinPanel.removeAll();
        this.add(this.skinPanel, "Skin", this.softsqueezeSkin2);
        if (Platform.JRE_1_5_PLUS) {
            this.add(this.skinPanel, "Always on top", this.softsqueezeOnTop);
        }
        if (Platform.JRE_1_6_PLUS && SystemTray.isSupported()) {
            this.add(this.skinPanel, "Use system tray", this.systemtray);
        }
        this.add(this.skinPanel, "Touchscreen mode", this.touchscreenMode);
        this.separator(this.skinPanel);
        this.add(this.skinPanel, new JLabel("Skin Preferences"));
        if (config == null) {
            this.padding(this.skinPanel);
            return;
        }
        NodeList configList = config.getChildNodes();
        for (int i = 0; i < configList.getLength(); ++i) {
            Node n = configList.item(i);
            String type = n.getNodeName();
            if (!type.equals("Select")) continue;
            String id = ((Element)n).getAttribute("id");
            String value = Config.getProperty(prefix + id);
            String selectLabel = ((Element)n).getAttribute("label");
            ArrayList<ConfigOption> optionList = new ArrayList<ConfigOption>();
            ConfigOption defaultOption = null;
            NodeList selectList = ((Element)n).getChildNodes();
            for (int j = 0; j < selectList.getLength(); ++j) {
                Node optionNode = selectList.item(j);
                if (!optionNode.getNodeName().equals("Option")) continue;
                String optionValue = ((Element)optionNode).getAttribute("value");
                String optionLabel = Util.xmlGetText(optionNode);
                ConfigOption option = new ConfigOption(prefix + id, optionValue, optionLabel);
                optionList.add(option);
                if (value == null || !value.equals(optionValue)) continue;
                defaultOption = option;
            }
            ConfigOption[] optionArray = optionList.toArray(new ConfigOption[optionList.size()]);
            JComboBox<ConfigOption> selectBox = new JComboBox<ConfigOption>(optionArray);
            selectBox.setSelectedItem(defaultOption);
            this.selectFields.add(selectBox);
            this.add(this.skinPanel, selectLabel, selectBox);
        }
        this.padding(this.skinPanel);
    }

    private void setComponents() {
        String oldMP3Decoder;
        this.slimservers = Protocol.getDiscoveredServers();
        this.slimserverAddr.removeAllElements();
        String slimserverAddrConfig = Config.getProperty("slimserver");
        String slimserverAddrSelected = null;
        for (Map.Entry e : this.slimservers.entrySet()) {
            this.slimserverAddr.addElement(e.getKey());
            if (!e.getKey().equals(slimserverAddrConfig)) continue;
            slimserverAddrSelected = (String)e.getKey();
        }
        if (slimserverAddrSelected != null) {
            this.slimserverAddr.setSelectedItem(slimserverAddrSelected);
        } else if (!"".equals(slimserverAddrConfig)) {
            this.slimserverAddr.addElement(slimserverAddrConfig);
            this.slimserverAddr.setSelectedItem(slimserverAddrConfig);
        }
        this.javaVersion.setText(System.getProperty("java.version"));
        this.softsqueezeVersion.setText(Config.getProperty("softsqueezeversion"));
        this.slimserverVersion.setText(Config.getProperty("serverversion"));
        this.softsqueezeSkin.setSelectedItem(Config.getProperty("skin"));
        this.softsqueezeDisplay.setSelectedItem(Config.getProperty("skin.displayemulation"));
        this.softsqueezeOnTop.setSelected(Config.getBooleanProperty("skin.alwaysontop"));
        this.systemtray.setSelected(Config.getBooleanProperty("skin.systemtray"));
        this.touchscreenMode.setSelected(Config.getBooleanProperty("skin.touchscreen"));
        this.buildSkinConfig(this.skin.getConfigPrefix(), this.skin.getSkinConfig());
        String oldMixer = Config.getProperty("audio.mixer");
        if (oldMixer != null && oldMixer.length() > 0) {
            this.audioMixer.setSelectedItem(oldMixer);
        }
        if ((oldMP3Decoder = Config.getProperty("audio.mp3decoder")) != null && oldMP3Decoder.length() > 0) {
            this.audioMP3Decoder.setSelectedItem(oldMP3Decoder);
        }
        this.audioBufferSize.setText(Config.getProperty("audio.lineBufferSize"));
        this.saveStream.setSelected(Config.getBooleanProperty("savestream"));
        this.saveFolder.setText(Config.getProperty("savedir"));
        this.slimserverHttpPort.setText(Config.getProperty("httpport"));
        this.slimserverSlimPort.setText(Config.getProperty("slimport"));
        this.softsqueezeMacAddress.setText(Config.getProperty("macaddress"));
        this.tcpWindowSize.setText(Config.getProperty("audio.tcpwindowsize"));
        this.sshTunnel.setSelected(Config.getBooleanProperty("sshtunnel"));
        this.sshPort.setText(Config.getProperty("sshport"));
        this.sshServerAddr.removeAllItems();
        this.sshServerAddr.addItem("[ On Squeezebox Server ]");
        if (Config.getProperty("sshserver").equals(Config.getProperty("slimserver"))) {
            this.sshServerAddr.setSelectedIndex(0);
        } else {
            this.sshServerAddr.addItem(Config.getProperty("sshserver"));
            this.sshServerAddr.setSelectedIndex(1);
        }
        this.sshUsername.setText(Config.getProperty("sshusername"));
        this.sshPassword.setText(new String(Config.getPassword("sshpassword")));
        this.sshStorePassword.setSelected(!Config.getProperty("sshpassword").equals(""));
        this.sshKeys.setText(Config.getProperty("sshprivatekey"));
        this.sshPortForward.setText(Config.getProperty("sshforwardports"));
        this.sshProxy.setSelectedItem(Config.getProperty("sshproxy"));
        this.sshProxyHost.setText(Config.getProperty("sshproxyhost"));
        this.sshProxyPort.setText(Config.getProperty("sshproxyport"));
        this.debugAudioBuffer.setSelected(this.isLoggerDebug("audiobuffer"));
        this.debugAudioBufferVerbose.setSelected(this.isLoggerDebug("audiobuffer.verbose"));
        this.debugConfig.setSelected(this.isLoggerDebug("config"));
        this.debugGraphics.setSelected(this.isLoggerDebug("graphics"));
        this.debugJavaSound.setSelected(this.isLoggerDebug("javasound"));
        this.debugJavaSoundVerbose.setSelected(this.isLoggerDebug("javasound.verbose"));
        this.debugPlatform.setSelected(this.isLoggerDebug("platform"));
        this.debugPlayer.setSelected(this.isLoggerDebug("player"));
        this.debugPlayerVerbose.setSelected(this.isLoggerDebug("player.verbose"));
        this.debugSearch.setSelected(this.isLoggerDebug("search"));
        this.debugSkin.setSelected(this.isLoggerDebug("skin"));
        this.debugSlimproto.setSelected(this.isLoggerDebug("slimproto"));
        this.debugCli.setSelected(this.isLoggerDebug("cli"));
        this.debugSoftsqueeze.setSelected(this.isLoggerDebug("softsqueeze"));
        this.debugSsh.setSelected(this.isLoggerDebug("ssh"));
        this.debugVisualizer.setSelected(this.isLoggerDebug("visualizer"));
        this.enableComponents();
    }

    public void showDialog(Skin skin) {
        this.skin = skin;
        this.setComponents();
        ConfigDialog.setOpaqueChildren(this.tabbedPane, false);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sure = JOptionPane.showConfirmDialog(null, "Are you sure you want to reset your SoftSqueeze configuration", "Reset configuration", 2);
                if (sure != 0) {
                    return;
                }
                Config.resetProperties();
                ConfigDialog.this.setComponents();
            }
        });
        Object[] options = new Object[]{"OK", "Cancel", resetButton};
        int selected = JOptionPane.showOptionDialog(null, this.tabbedPane, "SoftSqueeze Preferences", 1, 3, null, options, options[0]);
        if (selected == 1 || selected == -1) {
            return;
        }
        this.setLoggerDebug("audiobuffer", this.debugAudioBuffer.isSelected());
        this.setLoggerDebug("audiobuffer.verbose", this.debugAudioBufferVerbose.isSelected());
        this.setLoggerDebug("config", this.debugConfig.isSelected());
        this.setLoggerDebug("graphics", this.debugGraphics.isSelected());
        this.setLoggerDebug("javasound", this.debugJavaSound.isSelected());
        this.setLoggerDebug("javasound.verbose", this.debugJavaSoundVerbose.isSelected());
        this.setLoggerDebug("platform", this.debugPlatform.isSelected());
        this.setLoggerDebug("player", this.debugPlayer.isSelected());
        this.setLoggerDebug("player.verbose", this.debugPlayerVerbose.isSelected());
        this.setLoggerDebug("search", this.debugSearch.isSelected());
        this.setLoggerDebug("skin", this.debugSkin.isSelected());
        this.setLoggerDebug("slimproto", this.debugSlimproto.isSelected());
        this.setLoggerDebug("cli", this.debugCli.isSelected());
        this.setLoggerDebug("softsqueeze", this.debugSoftsqueeze.isSelected());
        this.setLoggerDebug("ssh", this.debugSsh.isSelected());
        this.setLoggerDebug("visualizer", this.debugVisualizer.isSelected());
        String newServer = (String)this.slimserverAddr.getSelectedItem();
        Config.putProperty("slimserver", newServer);
        Config.putProperty("skin", (String)this.softsqueezeSkin.getSelectedItem());
        Config.putProperty("skin.displayemulation", (String)this.softsqueezeDisplay.getSelectedItem());
        Config.putBooleanProperty("skin.alwaysontop", this.softsqueezeOnTop.isSelected());
        Config.putBooleanProperty("skin.systemtray", this.systemtray.isSelected());
        Config.putBooleanProperty("skin.touchscreen", this.touchscreenMode.isSelected());
        Config.putProperty("audio.mixer", (String)this.audioMixer.getSelectedItem());
        Config.putProperty("audio.mp3decoder", (String)this.audioMP3Decoder.getSelectedItem());
        Config.putIntegerProperty("audio.lineBufferSize", Integer.parseInt(this.audioBufferSize.getText()));
        Config.putBooleanProperty("savestream", this.saveStream.isSelected());
        Config.putProperty("savedir", this.saveFolder.getText());
        Config.putProperty("httpport", this.slimserverHttpPort.getText());
        Config.putProperty("slimport", this.slimserverSlimPort.getText());
        Config.putProperty("macaddress", this.softsqueezeMacAddress.getText());
        if (this.tcpWindowSize.getText().length() > 0) {
            Config.putIntegerProperty("audio.tcpwindowsize", Integer.parseInt(this.tcpWindowSize.getText()));
        }
        Config.putBooleanProperty("sshtunnel", this.sshTunnel.isSelected());
        if (this.sshServerAddr.getSelectedIndex() == 0) {
            Config.putProperty("sshserver", (String)this.slimserverAddr.getSelectedItem());
        } else {
            Config.putProperty("sshserver", (String)this.sshServerAddr.getSelectedItem());
        }
        Config.putProperty("sshport", this.sshPort.getText());
        Config.putProperty("sshusername", this.sshUsername.getText());
        if (this.sshStorePassword.isSelected()) {
            Config.putPassword("sshpassword", this.sshPassword.getPassword());
        } else {
            Config.putPassword("sshpassword", null);
        }
        Config.putProperty("sshprivatekey", this.sshKeys.getText());
        Config.putProperty("sshforwardports", this.sshPortForward.getText());
        Config.putProperty("sshproxy", (String)this.sshProxy.getSelectedItem());
        Config.putProperty("sshproxyhost", this.sshProxyHost.getText());
        Config.putProperty("sshproxyport", this.sshProxyPort.getText());
        for (JComboBox select : this.selectFields) {
            ConfigOption option = (ConfigOption)select.getSelectedItem();
            Config.putProperty(option.getProperty(), option.getValue());
        }
    }

    private void add(JPanel panel, JComponent component) {
        this.add(panel, "", component, null);
    }

    private void add(JPanel panel, String label, JComponent component) {
        this.add(panel, label, component, null);
    }

    private void add(JPanel panel, String label, JComponent component, JComponent button) {
        JLabel jlabel = null;
        if (label != null) {
            if (label.length() > 0) {
                label = label + ":";
            }
            jlabel = new JLabel(label, 11);
            jlabel.setLabelFor(component);
        }
        this.add(panel, jlabel, component, button, 0.0);
    }

    private void add(JPanel panel, JComponent label, JComponent component, JComponent button, double weighty) {
        if (label != null) {
            panel.add(label);
            this.c.weightx = 0.0;
            this.c.weighty = weighty;
            this.c.gridwidth = 1;
            this.c.anchor = 18;
            this.c.fill = 0;
            this.c.insets = this.ci;
            this.gridbag.setConstraints(label, this.c);
        }
        panel.add(component);
        this.c.weightx = 1.0;
        this.c.weighty = weighty;
        this.c.gridwidth = -1;
        this.c.anchor = 18;
        this.c.fill = 2;
        this.c.insets = new Insets(2, 2, 2, 2);
        this.gridbag.setConstraints(component, this.c);
        if (button == null) {
            button = new JLabel();
        }
        panel.add(button);
        this.c.weightx = 0.0;
        this.c.weighty = weighty;
        this.c.gridwidth = 0;
        this.c.anchor = 18;
        this.c.fill = 2;
        this.c.insets = new Insets(2, 2, 2, 2);
        this.gridbag.setConstraints(button, this.c);
    }

    private void separator(JPanel panel) {
        this.add(panel, new JLabel(), new JSeparator(), null, 0.0);
    }

    private void padding(JPanel panel) {
        this.add(panel, null, new JLabel(), null, 1.0);
    }

    private static void setOpaqueChildren(JComponent comp, boolean enable) {
        comp.setOpaque(enable);
        Component[] comps = comp.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component cc = comps[i];
            if (!(cc instanceof JComponent) || cc instanceof JTextComponent || cc instanceof JList) continue;
            ConfigDialog.setOpaqueChildren((JComponent)comps[i], enable);
        }
    }

    private boolean isLoggerDebug(String name) {
        Logger logger = Logger.getLogger((String)name);
        return logger.getLevel() == Level.DEBUG;
    }

    private void setLoggerDebug(String name, boolean debug) {
        Logger logger = Logger.getLogger((String)name);
        logger.setLevel(debug ? Level.DEBUG : Level.INFO);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.sshTunnel || e.getSource() == this.sshProxy || e.getSource() == this.saveStream) {
            this.enableComponents();
        }
    }

    private void enableComponents() {
        boolean sshEnable = this.sshTunnel.isSelected();
        this.sshServerAddr.setEnabled(sshEnable);
        this.sshPort.setEnabled(sshEnable);
        this.sshUsername.setEnabled(sshEnable);
        this.sshPassword.setEnabled(sshEnable);
        this.sshStorePassword.setEnabled(sshEnable);
        this.sshKeys.setEnabled(sshEnable);
        this.sshKeysFile.setEnabled(sshEnable);
        this.sshPortForward.setEnabled(sshEnable);
        boolean sshProxyEnable = this.sshProxy.getSelectedIndex() > 0;
        this.sshProxy.setEnabled(sshEnable);
        this.sshProxyHost.setEnabled(sshEnable && sshProxyEnable);
        this.sshProxyPort.setEnabled(sshEnable && sshProxyEnable);
        boolean saveEnable = this.saveStream.isSelected();
        this.saveFolder.setEnabled(saveEnable);
        this.saveFolderFile.setEnabled(saveEnable);
        boolean hasMP3Plugin = AudioDecoder.isMP3PluginInstalled();
        this.getJavaMP3Decoder.setVisible(!hasMP3Plugin);
        this.helpJavaMP3Decoder.setVisible(!hasMP3Plugin);
    }

    private class ConfigOption {
        private String property;
        private String value;
        private String label;

        ConfigOption(String property, String value, String label) {
            this.property = property;
            this.value = value;
            this.label = label;
        }

        private String getProperty() {
            return this.property;
        }

        private String getValue() {
            return this.value;
        }

        private String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class FileAction
    implements ActionListener {
        private JPanel panel;
        private String title;
        private JTextField textfield;
        private int mode;

        FileAction(JPanel panel, String title, JTextField textfield, int mode) {
            this.panel = panel;
            this.title = title;
            this.textfield = textfield;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.title);
            chooser.setFileHidingEnabled(false);
            chooser.setFileSelectionMode(this.mode);
            int result = chooser.showOpenDialog(this.panel);
            if (result == 0) {
                this.textfield.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class LogAppender
    extends AppenderSkeleton {
        private Layout layout = new PatternLayout("%r [%t] %-5p %c - %m%n");

        private LogAppender() {
        }

        protected void append(LoggingEvent event) {
            ConfigDialog.this.console.append(this.layout.format(event));
            String[] throwable = event.getThrowableStrRep();
            if (throwable != null) {
                for (int i = 0; i < throwable.length; ++i) {
                    ConfigDialog.this.console.append(throwable[i]);
                    ConfigDialog.this.console.append("\n");
                }
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return true;
        }
    }
}

