/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.debug;

import org.apache.log4j.Logger;

public class StreamDebug {
    private static final Logger logger = Logger.getLogger((String)"audiobuffer");
    private static final int MAX_BYTES = 100;
    private int cnt = 0;
    private int idx = 0;
    private int nzb = 0;
    private String name;
    private StringBuffer str = new StringBuffer();

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public StreamDebug(String name) {
        this.name = name;
        this.str.append(name);
        this.str.append(": ");
    }

    public void write(byte[] buf, int ptr, int len) {
        while (this.cnt < 100 && ptr < len) {
            int b = buf[ptr++] & 0xFF;
            ++this.idx;
            if (b == 0 || b == 255) continue;
            if (this.nzb + 1 != this.idx) {
                this.str.append("[");
                this.str.append(Integer.toHexString(this.idx));
                this.str.append("]");
            }
            this.str.append(Integer.toHexString(b & 0xFF));
            this.str.append(" ");
            ++this.cnt;
            this.nzb = this.idx;
            if (this.cnt != 100) continue;
            logger.debug((Object)this.str.toString());
        }
        this.idx += len - ptr;
    }

    public void close() {
        if (this.cnt < 100) {
            logger.debug((Object)this.str.toString());
        }
        logger.debug((Object)(this.name + ": stream length = " + this.idx));
    }
}

