/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.display.Frame;
import org.titmuss.softsqueeze.display.LcdDisplay;
import org.titmuss.softsqueeze.net.Protocol;

public class FrameNoritake
implements Frame {
    private static final Logger logger = Logger.getLogger((String)"graphics");
    public static final int VFD_X_OFFSET = 40;
    public static final int VFD_Y_OFFSET = 8;
    private byte[] frame = new byte[640];
    private byte[] cgram = new byte[2048];
    private int cgramAddr = 0;
    private int ddramAddr = 0;
    private int entryMode = 1;
    private boolean setDdram = true;
    private boolean fontLoaded = false;

    public FrameNoritake(LcdDisplay display, byte[] buf, int start, int len) {
        if (!this.fontLoaded) {
            this.loadFont();
            this.fontLoaded = true;
        }
        for (int i = start; i < len; i += 2) {
            int code = Protocol.unpackN2(buf, i);
            if ((code & 0xFF00) == 0) {
                logger.warn((Object)"vfd delay request by server - this is not implemented");
                continue;
            }
            if ((code & 0xFF00) == 512) {
                if ((code & 0x80) == 128) {
                    this.ddramAddr = code & 0x7F;
                    this.setDdram = true;
                    logger.debug((Object)("ddram address set " + this.ddramAddr));
                    continue;
                }
                if ((code & 0x40) == 64) {
                    this.cgramAddr = code & 0x3F;
                    this.setDdram = false;
                    logger.debug((Object)("cgram address set " + this.cgramAddr));
                    continue;
                }
                if ((code & 0x20) == 32) {
                    byte brightness = buf[i + 7];
                    display.setBrightness(brightness);
                    i += 6;
                    logger.debug((Object)("function set - brightness " + brightness));
                    continue;
                }
                if ((code & 0x10) == 16) {
                    logger.warn((Object)"cursor or display shift - not implmented");
                    continue;
                }
                if ((code & 8) == 8) {
                    boolean displayOn = (code & 4) == 4;
                    display.setDisplayOn(displayOn);
                    logger.debug((Object)"display/cursor on/off");
                    continue;
                }
                if ((code & 4) == 4) {
                    this.entryMode = code & 3;
                    logger.debug((Object)("entryMode set to " + this.entryMode + " (code " + Integer.toString(code, 2) + ")"));
                    continue;
                }
                if ((code & 2) == 2) {
                    this.ddramAddr = 0;
                    this.setDdram = true;
                    logger.debug((Object)"cursor home");
                    continue;
                }
                if ((code & 1) == 1) {
                    for (int j = 0; j < this.frame.length; ++j) {
                        this.frame[j] = 0;
                    }
                    this.ddramAddr = 0;
                    this.entryMode = 2;
                    logger.debug((Object)"display clear");
                    continue;
                }
                logger.warn((Object)"vfd unrecognised instruction");
                continue;
            }
            if ((code & 0xFF00) == 768) {
                int j;
                int c;
                if (this.setDdram) {
                    c = (code & 0xFF) * 8;
                    int ptr = 0;
                    if (this.ddramAddr < 64) {
                        ptr += this.ddramAddr * 12;
                        for (j = 0; j < 5; ++j) {
                            this.frame[ptr] = this.cgram[c++];
                            ptr += 2;
                        }
                    } else {
                        ptr += 1 + (this.ddramAddr - 64) * 12;
                        for (j = 0; j < 5; ++j) {
                            this.frame[ptr] = (byte)((this.cgram[c++] & 0xFF) >> 1);
                            ptr += 2;
                        }
                    }
                    if (this.entryMode == 0) {
                        --this.ddramAddr;
                        if (this.ddramAddr < 0) {
                            this.ddramAddr = 103;
                        }
                    } else if (this.entryMode == 1) {
                        logger.debug((Object)"vfd shift - not implemented");
                    } else if (this.entryMode == 2) {
                        ++this.ddramAddr;
                    }
                    if (this.ddramAddr >= 104) {
                        this.ddramAddr = 0;
                        continue;
                    }
                    if (this.entryMode != 3) continue;
                    logger.debug((Object)"vfd shift - not implemented");
                    continue;
                }
                c = code & 0xFF;
                int idx = (int)((double)this.cgramAddr / 8.0) * 8 + 4;
                for (j = 0; j < 5; ++j) {
                    int n = idx;
                    this.cgram[n] = (byte)(this.cgram[n] << 1);
                    int n2 = idx--;
                    this.cgram[n2] = (byte)(this.cgram[n2] | c & 1);
                    c = (byte)(c >> 1);
                }
                if (this.entryMode == 0) {
                    --this.cgramAddr;
                    if (this.cgramAddr < 0) {
                        this.cgramAddr = 63;
                    }
                } else if (this.entryMode == 1) {
                    logger.debug((Object)"vfd shift - not implemented");
                } else if (this.entryMode == 2) {
                    ++this.cgramAddr;
                }
                if (this.cgramAddr >= 63) {
                    this.cgramAddr = 0;
                    continue;
                }
                if (this.entryMode != 3) continue;
                logger.debug((Object)"vfd shift - not implemented");
                continue;
            }
            logger.warn((Object)("vfd invalid code " + Integer.toString(code, 16)));
        }
    }

    public FrameNoritake(String line1, String line2) {
        int j;
        int ptr;
        int c;
        int i;
        if (!this.fontLoaded) {
            this.loadFont();
            this.fontLoaded = true;
        }
        logger.debug((Object)("setText. line1=" + line1 + " line2=" + line2));
        byte[] bytes1 = line1.getBytes();
        byte[] bytes2 = line2.getBytes();
        for (int j2 = 0; j2 < this.frame.length; ++j2) {
            this.frame[j2] = 0;
        }
        for (i = 0; i < bytes1.length; ++i) {
            c = bytes1[i] * 8;
            ptr = i * 12;
            for (j = 0; j < 5; ++j) {
                this.frame[ptr] = this.cgram[c++];
                ptr += 2;
            }
        }
        for (i = 0; i < bytes2.length; ++i) {
            c = bytes2[i] * 8;
            ptr = 1 + i * 12;
            for (j = 0; j < 5; ++j) {
                this.frame[ptr] = this.cgram[c++];
                ptr += 2;
            }
        }
    }

    @Override
    public void render(Graphics g, int width, int offset, Color[] color) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
        g2.fillRect(0, 0, 320, 32);
        g2.setComposite(AlphaComposite.SrcOver);
        g.setColor(color[3]);
        int x = 40;
        int y = 8;
        int col = 0;
        for (int i = 0; i < this.frame.length; ++i) {
            int j;
            int xcol = x + col++;
            byte dots = this.frame[i];
            for (j = 7; j >= 0; --j) {
                if ((dots & 1) > 0) {
                    g.fillRect(xcol, y + j, 1, 1);
                }
                dots = (byte)(dots >> 1);
            }
            dots = this.frame[++i];
            for (j = 7; j >= 0; --j) {
                if ((dots & 1) > 0) {
                    g.fillRect(xcol, y + j + 8, 1, 1);
                }
                dots = (byte)(dots >> 1);
            }
        }
    }

    private void loadFont() {
        try {
            InputStream is = this.getClass().getResourceAsStream("vfdfont.txt");
            if (is == null) {
                logger.warn((Object)"Cannot load VfDisplay font");
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            int cgramAddr = 0;
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) {
                    line = br.readLine();
                    continue;
                }
                if (line.startsWith("-") || line.startsWith("X")) {
                    for (int i = 0; i < 5; ++i) {
                        if (line.charAt(i) == 'X') {
                            int n = cgramAddr + i;
                            this.cgram[n] = (byte)(this.cgram[n] | 1);
                        }
                        int n = cgramAddr + i;
                        this.cgram[n] = (byte)(this.cgram[n] << 1);
                    }
                } else {
                    int idx = Integer.parseInt(line.substring(0, 2), 16);
                    cgramAddr = idx * 8;
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Cannot load VfDisplay font", (Throwable)e);
        }
    }
}

