/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.config.ConfigListener;
import org.titmuss.softsqueeze.display.Frame;
import org.titmuss.softsqueeze.display.FrameD;
import org.titmuss.softsqueeze.display.FrameE;
import org.titmuss.softsqueeze.display.FrameF;
import org.titmuss.softsqueeze.display.FrameNoritake;
import org.titmuss.softsqueeze.display.LcdDisplayListener;
import org.titmuss.softsqueeze.display.Screen;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.net.ProtocolListener;
import org.titmuss.softsqueeze.visualizer.Visualizer;

public class LcdDisplay
implements ProtocolListener,
ConfigListener,
ImageObserver,
Runnable {
    private static final Logger logger = Logger.getLogger((String)"graphics");
    public static final int DISPLAY_NORITAKE = 0;
    public static final int DISPLAY_SQUEEZEBOXG = 1;
    public static final int DISPLAY_SQUEEZEBOX2 = 2;
    public static final int TOTAL_SCREENS = 2;
    public static final int SCREEN_WIDTH = 320;
    public static final int SCREEN_HEIGHT = 32;
    public static final int FRAME_WIDTH = 640;
    public static final int FRAME_HEIGHT = 32;
    private Softsqueeze squeeze;
    private int model;
    private int maxBrightness;
    private int tranDelay;
    private int brightness = 0;
    private boolean displayOn = true;
    private HashSet listeners = new HashSet();
    private static final Color DEFAULT_FGCOLOUR = new Color(3336730);
    private static final Color DEFAULT_BGCOLOUR = Color.BLACK;
    private Color[] colours = new Color[4];
    private AlphaComposite compositeIn;
    private AlphaComposite compositeOver;
    private Image renderLive;
    private Image renderVis;
    private Screen[] screens = new Screen[2];

    public LcdDisplay(Softsqueeze squeeze) {
        this.squeeze = squeeze;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        this.renderLive = gc.createCompatibleImage(640, 32, 1);
        this.renderVis = gc.createCompatibleImage(640, 32, 2);
        for (int i = 0; i < 2; ++i) {
            this.screens[i] = new Screen(i * 320, gc);
        }
        Thread t = new Thread((Runnable)this, "Display animation");
        t.setDaemon(true);
        t.start();
        squeeze.getProtocol().addProtocolListener("grfd", this);
        squeeze.getProtocol().addProtocolListener("grfe", this);
        squeeze.getProtocol().addProtocolListener("grff", this);
        squeeze.getProtocol().addProtocolListener("grfb", this);
        squeeze.getProtocol().addProtocolListener("vfdc", this);
        Config.addConfigListener(this);
        this.setEmulation(Config.getProperty("skin.displayemulation"));
    }

    @Override
    public void configSet(String key, String value) {
        if (key.equals("displayemulation")) {
            this.setEmulation(value);
        }
    }

    @Override
    public void slimprotoCmd(String cmd, byte[] buf, int off, int len) {
        if (cmd.equals("grfd")) {
            int offset = Protocol.unpackN2(buf, off);
            switch (this.model) {
                case 1: {
                    FrameD frame = new FrameD(buf, off + 2, len - off - 2, false);
                    this.renderDisplay(cmd, 'c', 0, frame, offset, 320);
                    break;
                }
                case 2: {
                    char transition = (char)buf[off + 2];
                    byte tParam = buf[off + 3];
                    int width = (len - off - 4) / 2;
                    FrameD frame = new FrameD(buf, off + 4, len - off - 4, true);
                    this.renderDisplay(cmd, 'c', tParam, frame, offset, width);
                    break;
                }
            }
        } else if (cmd.equals("grfe")) {
            int offset = Protocol.unpackN2(buf, off);
            char transition = (char)buf[off + 2];
            byte tParam = buf[off + 3];
            int width = (len - off - 4) / 4;
            FrameE frame = new FrameE(buf, off + 4, len - off - 4);
            this.renderDisplay(cmd, transition, tParam, frame, offset, width);
        } else if (cmd.equals("grff")) {
            int offset = Protocol.unpackN2(buf, off);
            char transition = (char)buf[off + 2];
            byte tParam = buf[off + 3];
            int width = (len - off - 4) / 8;
            FrameF frame = new FrameF(buf, off + 4, len - off - 4);
            this.renderDisplay(cmd, transition, tParam, frame, offset, width);
        } else if (cmd.equals("grfb")) {
            this.setBrightness(Protocol.unpackN2(buf, off));
        } else if (cmd.equals("vfdc")) {
            FrameNoritake frame = new FrameNoritake(this, buf, off, len);
            this.renderDisplay(cmd, 'c', 0, frame, 0, 320);
        }
    }

    @Override
    public void slimprotoConnected() {
        this.clearDisplay();
    }

    @Override
    public void slimprotoDisconnected() {
        this.clearDisplay();
        this.setText("Problem: Lost contact with Slim Server.", "Check the software is running.");
    }

    public void updateVisualizer(Visualizer visualizer) {
        visualizer.render(this.renderVis.getGraphics(), this.colours);
        this.updateDisplay();
    }

    private void setEmulation(String displayType) {
        if (displayType.equalsIgnoreCase("Noritake")) {
            this.model = 0;
            this.maxBrightness = 32;
        } else if (displayType.equalsIgnoreCase("Graphics")) {
            this.model = 1;
            this.maxBrightness = 32;
        } else {
            this.model = 2;
            this.maxBrightness = 8;
        }
        this.setColour(DEFAULT_FGCOLOUR, DEFAULT_BGCOLOUR);
        this.setBrightness(this.maxBrightness);
    }

    public void setText(String str1, String str2) {
        this.setBrightness(this.maxBrightness);
        FrameNoritake frame = new FrameNoritake(str1, str2);
        this.renderDisplay("vfdc", 'c', 0, frame, 0, 320);
    }

    public void setBrightness(int b) {
        if (this.model == 2) {
            switch (b) {
                case 65535: {
                    b = 0;
                    break;
                }
                case 0: {
                    b = 1;
                    break;
                }
                case 1: {
                    b = 2;
                    break;
                }
                case 3: {
                    b = 4;
                    break;
                }
                case 4: {
                    b = 8;
                    break;
                }
                default: {
                    b = 8;
                }
            }
        }
        this.brightness = Math.min(b, this.maxBrightness);
        float f = 1.0f - (float)Math.pow(1.0f - (float)this.brightness / (float)this.maxBrightness, 2.0);
        this.compositeIn = AlphaComposite.getInstance(5, f);
        this.compositeOver = AlphaComposite.getInstance(3, f);
        logger.debug((Object)("brightness=" + this.brightness + " f=" + f));
        this.updateDisplay();
    }

    public void setDisplayOn(boolean displayOn) {
        this.displayOn = displayOn;
        this.updateDisplay();
    }

    public void setColour(Color fg, Color bg) {
        this.colours[3] = new Color(fg.getRed(), fg.getGreen(), fg.getBlue());
        this.colours[2] = new Color((int)((float)this.colours[3].getRed() * 0.8f), (int)((float)this.colours[3].getGreen() * 0.8f), (int)((float)this.colours[3].getBlue() * 0.8f));
        this.colours[1] = new Color((int)((float)this.colours[2].getRed() * 0.6f), (int)((float)this.colours[2].getGreen() * 0.6f), (int)((float)this.colours[2].getBlue() * 0.6f));
        this.colours[0] = bg;
        this.updateDisplay();
    }

    public void clearDisplay() {
        this.renderDisplay("grfe", 'c', 0, new FrameE(new byte[0], 0, 0), 0, 640);
    }

    public void addListener(LcdDisplayListener panel) {
        this.listeners.add(panel);
        this.updateDisplay();
    }

    public void removeListener(LcdDisplayListener panel) {
        this.listeners.remove(panel);
    }

    public boolean isDisplayOn() {
        return this.displayOn;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public int getMaxBrightness() {
        return this.maxBrightness;
    }

    public int getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderDisplay(String cmd, char transition, int tParam, Frame frame, int offset, int width) {
        logger.debug((Object)("renderDisplay cmd=" + cmd + " tran=" + transition + " tParam=" + tParam + " width=" + width));
        int newTranDelay = 0;
        if (offset == 0 && width == 640) {
            this.screens[0].renderFrame(frame, 0, this.colours);
            this.screens[0].setTransition(transition, tParam);
            this.screens[1].renderFrame(frame, 320, this.colours);
            newTranDelay = this.screens[1].setTransition(transition, tParam);
        } else if (offset == 0 && width <= 320) {
            this.screens[0].renderFrame(frame, 0, this.colours);
            newTranDelay = this.screens[0].setTransition(transition, tParam);
        } else if (offset == 640 && width <= 320) {
            this.screens[1].renderFrame(frame, 0, this.colours);
            newTranDelay = this.screens[1].setTransition(transition, tParam);
        } else {
            logger.error((Object)("Cannot render display offset=" + offset + " width=" + width));
            return;
        }
        if (newTranDelay > 0) {
            LcdDisplay lcdDisplay = this;
            synchronized (lcdDisplay) {
                this.tranDelay = newTranDelay;
                this.notifyAll();
            }
        }
        this.updateDisplay();
    }

    protected void animiationComplete() {
        this.squeeze.sendANIC();
    }

    protected synchronized void updateDisplay() {
        logger.debug((Object)"request display repaint ...");
        if (this.listeners.size() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)this.renderLive.getGraphics();
        g.setColor(this.colours[0]);
        g.fillRect(0, 0, 640, 32);
        if (this.displayOn) {
            g.setComposite(this.compositeOver);
            g.drawImage(this.renderVis, 0, 0, this);
            g.setComposite(this.compositeOver);
            this.screens[1].updateScreen(g);
            this.screens[0].updateScreen(g);
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((LcdDisplayListener)i.next()).updateDisplay(this, this.renderLive);
        }
    }

    @Override
    public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void run() {
        while (true) {
            try {
                block7: while (true) {
                    if (this.tranDelay == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var1_2) {}
                        continue;
                    }
                    while (true) {
                        if (this.tranDelay > 0) ** break;
                        continue block7;
                        try {
                            this.wait(this.tranDelay);
                        }
                        catch (InterruptedException var1_3) {
                            // empty catch block
                        }
                        if (this.screens[0].animate()) {
                            this.animiationComplete();
                            this.tranDelay = 0;
                        }
                        if (this.screens[1].animate()) {
                            this.animiationComplete();
                            this.tranDelay = 0;
                        }
                        this.updateDisplay();
                    }
                    break;
                }
            }
            catch (Exception e) {
                LcdDisplay.logger.error((Object)"Error in graphics transition", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

