/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.display;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import org.titmuss.softsqueeze.display.Frame;

class Screen {
    private Image renderBuf;
    private Image renderOut;
    private int offset;
    private char tranType;
    private int tranDelay;
    private int frameX;
    private int frameY;
    private int frameWidth;
    private int frameHeight;
    private int tranX;
    private int tranY;
    private int incX;
    private int incY;
    private boolean animate = false;

    protected Screen(int offset, GraphicsConfiguration gc) {
        this.offset = offset;
        this.renderBuf = gc.createCompatibleImage(320, 32, 2);
        this.renderOut = gc.createCompatibleImage(320, 32, 2);
    }

    protected void renderFrame(Frame frame, int offset, Color[] colours) {
        Image tmp = this.renderBuf;
        this.renderBuf = this.renderOut;
        this.renderOut = tmp;
        frame.render(this.renderBuf.getGraphics(), 320, offset, colours);
    }

    protected void killAnimation() {
        this.animate = false;
    }

    protected void updateScreen(Graphics2D g) {
        if (!this.animate) {
            g.setClip(this.offset, 0, 320, 32);
            g.drawImage(this.renderBuf, this.offset, 0, null);
        } else {
            this.doUpdateScreen(g, this.renderBuf, this.renderOut, this.offset);
        }
    }

    protected synchronized int setTransition(char transition, int param) {
        this.tranType = transition;
        this.frameX = 0;
        this.tranX = 0;
        this.incX = 0;
        this.frameY = 0;
        this.tranY = 0;
        this.incY = 0;
        this.frameWidth = 320;
        this.frameHeight = 32;
        switch (transition) {
            case 'l': {
                this.animate = true;
                this.tranDelay = 5;
                this.frameX = -320;
                this.tranX = 0;
                this.incX = 1;
                break;
            }
            case 'r': {
                this.animate = true;
                this.tranDelay = 5;
                this.frameX = 320;
                this.tranX = 0;
                this.incX = -1;
                break;
            }
            case 'u': {
                this.animate = true;
                this.tranDelay = 10;
                this.frameY = -param;
                this.tranY = 0;
                this.incY = 1;
                this.frameHeight = param;
                break;
            }
            case 'd': {
                this.animate = true;
                this.tranDelay = 10;
                this.frameY = param;
                this.tranY = 0;
                this.incY = -1;
                this.frameHeight = param;
                break;
            }
            case 'L': {
                this.animate = true;
                this.tranDelay = 15;
                this.frameX = 8;
                this.tranX = 0;
                this.incX = -1;
                break;
            }
            case 'R': {
                this.animate = true;
                this.tranDelay = 15;
                this.frameX = -8;
                this.tranX = 0;
                this.incX = 1;
                break;
            }
            case 'U': {
                this.animate = true;
                this.tranDelay = 20;
                this.frameY = -8;
                this.tranY = 0;
                this.incY = 1;
                break;
            }
            case 'D': {
                this.animate = true;
                this.tranDelay = 20;
                this.frameY = 8;
                this.tranY = 0;
                this.incY = -1;
                break;
            }
            default: {
                this.animate = false;
                this.tranType = (char)99;
            }
        }
        return this.tranDelay;
    }

    protected synchronized boolean animate() {
        if (this.tranType == 'c') {
            return false;
        }
        if (this.frameX < -100 || this.frameX > 100) {
            this.frameX += this.incX * 12;
            this.tranX += this.incX * 12;
        } else if (this.frameX < -50 || this.frameX > 50) {
            this.frameX += this.incX * 4;
            this.tranX += this.incX * 4;
        } else if (this.frameX < -25 || this.frameX > 25) {
            this.frameX += this.incX * 2;
            this.tranX += this.incX * 2;
        } else {
            this.frameX += this.incX * 1;
            this.tranX += this.incX * 1;
        }
        if (this.frameY < -16 || this.frameY > 16) {
            this.frameY += this.incY * 2;
            this.tranY += this.incY * 2;
        } else {
            this.frameY += this.incY * 1;
            this.tranY += this.incY * 1;
        }
        if (this.frameX * this.incX > 0) {
            this.frameX = 0;
        }
        if (this.frameY * this.incY > 0) {
            this.frameY = 0;
        }
        if (this.frameX == 0 && this.frameY == 0) {
            this.tranType = (char)99;
            return true;
        }
        return false;
    }

    private synchronized void doUpdateScreen(Graphics2D g, Image renderBuf, Image renderTran, int offset) {
        switch (this.tranType) {
            case 'l': 
            case 'r': {
                g.setClip(offset, 0, 320, 32);
                g.drawImage(renderBuf, this.frameX + offset, this.frameY, null);
                g.drawImage(renderTran, this.tranX + offset, this.tranY, null);
                break;
            }
            case 'd': 
            case 'u': {
                int clipHeight = 32 - this.frameHeight;
                g.setClip(offset, 0, 320, clipHeight);
                g.drawImage(renderBuf, offset, 0, null);
                g.setClip(offset, clipHeight, 320, 32);
                g.drawImage(renderBuf, this.frameX + offset, this.frameY + clipHeight, this.frameX + offset + this.frameWidth, this.frameY + clipHeight + this.frameHeight, 0, clipHeight, this.frameWidth, clipHeight + this.frameHeight, null);
                g.drawImage(renderTran, this.tranX + offset, this.tranY + clipHeight, this.tranX + offset + this.frameWidth, this.tranY + clipHeight + this.frameHeight, 0, clipHeight, this.frameWidth, clipHeight + this.frameHeight, null);
                break;
            }
            case 'D': 
            case 'L': 
            case 'R': 
            case 'U': {
                g.setClip(offset, 0, 320, 32);
                g.drawImage(renderBuf, this.frameX + offset, this.frameY, null);
                break;
            }
            default: {
                g.setClip(offset, 0, 320, 32);
                g.drawImage(renderBuf, offset, 0, null);
            }
        }
    }
}

