/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.music;

import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.music.SongInfo;
import org.titmuss.softsqueeze.net.CliConnection;
import org.titmuss.softsqueeze.net.CliListener;
import org.titmuss.softsqueeze.net.CliMessage;
import org.titmuss.softsqueeze.net.CliParameterIterator;

public class SongList
extends AbstractTableModel
implements CliListener {
    private static final Logger logger = Logger.getLogger((String)"cli");
    public static final SongListButton PLAY_BUTTON = new SongListButton();
    public static final SongListButton ADD_BUTTON = new SongListButton();
    public static final SongListButton DOWN_BUTTON = new SongListButton();
    public static final SongListButton UP_BUTTON = new SongListButton();
    public static final SongListButton DELETE_BUTTON = new SongListButton();
    private int count = 0;
    private int playingSong = -1;
    private SongInfo[] songs = new SongInfo[0];
    private String playerid;
    private String command;
    private String search;
    private String[] columnName = new String[]{"Title", "Genre", "Artist", "Composer", "Band", "Album", "Duration", "Disc", "Track Num", "Year", "BPM", "Comment", "Format", "Bitrate", "play", "add", "down", "up", "delete"};
    private static final int CHUNK_SIZE = 10;
    private boolean[] loadedChunk = new boolean[1];
    private CliConnection cli;

    public void loadPlaylist(CliConnection cli, String aPlayerid) {
        this.cli = cli;
        this.command = "status";
        this.playerid = aPlayerid;
        this.invalidateSongList();
    }

    public void searchSongs(CliConnection cli, String searchParameters) {
        this.cli = cli;
        this.command = "titles";
        this.playerid = null;
        this.search = searchParameters;
        this.invalidateSongList();
    }

    public void clear() {
        if (this.count > 0) {
            this.count = 0;
            this.fireTableDataChanged();
        }
    }

    private void parseSongList(CliMessage msg) {
        String tag = null;
        String val = null;
        if (!msg.getCommand().equals("status") && !msg.getCommand().equals("titles")) {
            throw new IllegalArgumentException("Cannot build playlist with cli command " + msg.getCommand());
        }
        CliParameterIterator iterator = msg.getParameterIterator();
        boolean reset = false;
        int start = Integer.parseInt(iterator.nextParameter());
        int items = Integer.parseInt(iterator.nextParameter());
        while (iterator.hasNext()) {
            tag = iterator.nextTag();
            val = iterator.nextValue();
            if (tag.equals("id")) break;
            if (tag.equals("playlist_cur_index")) {
                this.playingSong = Integer.parseInt(val);
                continue;
            }
            if (tag.equals("playlist_tracks")) {
                this.count = Integer.parseInt(val);
                continue;
            }
            if (!tag.equals("count")) continue;
            this.count = Integer.parseInt(val);
        }
        if (this.songs.length != this.count) {
            reset = true;
            SongInfo[] tmp = new SongInfo[this.count];
            System.arraycopy(this.songs, 0, tmp, 0, Math.min(this.songs.length, this.count));
            this.songs = tmp;
            this.loadedChunk = new boolean[this.count / 10 + 1];
        }
        int index = start;
        block1: while (iterator.hasNext() && index < this.songs.length) {
            SongInfo song = new SongInfo();
            this.songs[index++] = song;
            song.setId(Integer.parseInt(val));
            while (iterator.hasNext()) {
                tag = iterator.nextTag();
                val = iterator.nextValue();
                if (tag.equals("playlist index")) continue;
                if (tag.equals("id")) continue block1;
                if (tag.equals("title")) {
                    song.setTitle(val);
                    continue;
                }
                if (tag.equals("genre")) {
                    song.setGenre(val);
                    continue;
                }
                if (tag.equals("genre_id")) {
                    song.setGenreId(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("artist")) {
                    song.setArtist(val);
                    continue;
                }
                if (tag.equals("artist_id")) {
                    song.setArtistId(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("composer")) {
                    song.setComposer(val);
                    continue;
                }
                if (tag.equals("band")) {
                    song.setBand(val);
                    continue;
                }
                if (tag.equals("album")) {
                    song.setAlbum(val);
                    continue;
                }
                if (tag.equals("album_id")) {
                    song.setAlbumId(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("duration")) {
                    song.setDuration(Double.parseDouble(val));
                    continue;
                }
                if (tag.equals("disc")) {
                    song.setDisc(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("disccount")) {
                    song.setDiscCount(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("tracknum")) {
                    song.setTrackNum(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("year")) {
                    song.setYear(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("bpm")) {
                    song.setBpm(Integer.parseInt(val));
                    continue;
                }
                if (tag.equals("comment")) {
                    song.setComment(val);
                    continue;
                }
                if (tag.equals("type")) {
                    song.setType(val);
                    continue;
                }
                if (tag.equals("bitrate")) {
                    song.setBitrate(val);
                    continue;
                }
                if (tag.equals("coverart")) {
                    song.setHasCoverart(val.equals("1"));
                    continue;
                }
                if (tag.equals("coverartThumb")) {
                    song.setHasCoverartThumb(val.equals("1"));
                    continue;
                }
                if (tag.equals("url")) {
                    song.setUrl(val);
                    continue;
                }
                logger.warn((Object)("UNKOWN TAG " + tag));
            }
        }
        this.fireTableDataChanged();
    }

    public int count() {
        return this.count;
    }

    public boolean isPlaying(int index) {
        return index == this.playingSong;
    }

    public SongInfo getSong(int index) {
        return this.songs[index];
    }

    private void invalidateSongList() {
        for (int i = 0; i < this.loadedChunk.length; ++i) {
            this.loadedChunk[i] = false;
        }
        this.lazyLoad(0);
    }

    private void lazyLoad(int index) {
        int chunk = index / 10;
        if (this.loadedChunk[chunk]) {
            return;
        }
        this.loadedChunk[chunk] = true;
        this.cli.queueMessage(this, this.getCommand(chunk));
    }

    private CliMessage getCommand(int chunk) {
        CliMessage msg = new CliMessage(this.playerid, this.command);
        msg.addParameter(Integer.toString(chunk * 10));
        msg.addParameter(Integer.toString(10));
        if (this.search != null) {
            msg.addParameter(this.search);
        }
        msg.addParameter("tag", "");
        return msg;
    }

    @Override
    public void cliMessage(CliMessage reply) {
        String cmd = reply.getCommand();
        if (cmd.equals("status") || cmd.equals("titles")) {
            this.parseSongList(reply);
        }
    }

    @Override
    public void cliConnected() {
    }

    @Override
    public void cliDisconnected() {
    }

    @Override
    public String getColumnName(int column) {
        return this.columnName[column];
    }

    @Override
    public int getRowCount() {
        return this.count();
    }

    @Override
    public int getColumnCount() {
        return this.columnName.length;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return SongListButton.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.count) {
            return null;
        }
        SongInfo song = this.songs[rowIndex];
        int chunk = rowIndex / 10;
        if (!this.loadedChunk[chunk]) {
            this.lazyLoad(rowIndex);
        }
        if (song == null || !this.loadedChunk[chunk]) {
            if (columnIndex == 0) {
                return "Loading ...";
            }
            return null;
        }
        switch (columnIndex) {
            case 0: {
                if (this.playingSong == rowIndex) {
                    return "** " + song.getTitle();
                }
                return song.getTitle();
            }
            case 1: {
                return song.getGenre();
            }
            case 2: {
                return song.getArtist();
            }
            case 3: {
                return song.getComposer();
            }
            case 4: {
                return song.getBand();
            }
            case 5: {
                return song.getAlbum();
            }
            case 6: {
                return Integer.toString((int)song.getDuration());
            }
            case 7: {
                return Integer.toString(song.getDiscCount()) + "/" + Integer.toString(song.getDisc());
            }
            case 8: {
                return Integer.toString(song.getTrackNum());
            }
            case 9: {
                return Integer.toString(song.getYear());
            }
            case 10: {
                return Integer.toString(song.getBpm());
            }
            case 11: {
                return song.getComment();
            }
            case 12: {
                return song.getType();
            }
            case 13: {
                return song.getBitrate();
            }
            case 14: {
                return PLAY_BUTTON;
            }
            case 15: {
                return ADD_BUTTON;
            }
            case 16: {
                return DOWN_BUTTON;
            }
            case 17: {
                return UP_BUTTON;
            }
            case 18: {
                return DELETE_BUTTON;
            }
        }
        return null;
    }

    public void actionPerformed(int rowIndex, int columnIndex) {
        if (this.command.equals("titles")) {
            columnIndex += 9;
        }
        switch (columnIndex) {
            case 14: {
                this.cli.queueMessage(this, new CliMessage(Config.getProperty("macaddress"), "playlistcontrol").addParameter("cmd", "load").addParameter("track_id", Integer.toString(this.songs[rowIndex].getId())));
                break;
            }
            case 15: {
                this.cli.queueMessage(this, new CliMessage(Config.getProperty("macaddress"), "playlistcontrol").addParameter("cmd", "add").addParameter("track_id", Integer.toString(this.songs[rowIndex].getId())));
                break;
            }
            case 5: 
            case 16: {
                this.cli.queueMessage(this, new CliMessage(this.playerid, "playlist").addParameter("move").addParameter(Integer.toString(rowIndex)).addParameter(Integer.toString(rowIndex + 1)));
                this.invalidateSongList();
                break;
            }
            case 6: 
            case 17: {
                this.cli.queueMessage(this, new CliMessage(this.playerid, "playlist").addParameter("move").addParameter(Integer.toString(rowIndex)).addParameter(Integer.toString(rowIndex - 1)));
                this.invalidateSongList();
                break;
            }
            case 7: 
            case 18: {
                this.cli.queueMessage(this, new CliMessage(this.playerid, "playlistcontrol").addParameter("cmd", "delete").addParameter("track_id", Integer.toString(this.songs[rowIndex].getId())));
                this.invalidateSongList();
            }
        }
    }

    public static class SongListButton {
    }
}

