/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.music;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.titmuss.softsqueeze.music.SongList;
import org.titmuss.softsqueeze.music.VisibilityColumnModel;

public class SongListTable
extends JPanel
implements TableModelListener,
ListSelectionListener {
    private SongList songList;
    private JTable table;
    private JLabel line;
    private JLabel buttonAdd;
    private JLabel buttonDelete;
    private JLabel buttonDown;
    private JLabel buttonPlay;
    private JLabel buttonUp;
    private VisibilityColumnModel columnModel;

    public SongListTable(SongList songList) {
        super(new BorderLayout());
        this.songList = songList;
        songList.addTableModelListener(this);
        this.buttonAdd = this._makeButton("/skin/slim/images/b_add.gif");
        this.buttonDelete = this._makeButton("/skin/slim/images/b_delete.gif");
        this.buttonDown = this._makeButton("/skin/slim/images/b_down.gif");
        this.buttonPlay = this._makeButton("/skin/slim/images/b_play.gif");
        this.buttonUp = this._makeButton("/skin/slim/images/b_up.gif");
        this.columnModel = new VisibilityColumnModel();
        this.table = new JTable(songList, this.columnModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.createDefaultColumnsFromModel();
        this.table.setDefaultRenderer(SongList.SongListButton.class, new SongListButtonRenderer());
        this.table.addMouseListener(new PopupListener());
        this.table.addMouseListener(new JTableButtonMouseListener());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.line = new JLabel();
        this.add((Component)this.line, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private JLabel _makeButton(String name) {
        URL url = this.getClass().getResource(name);
        return new JLabel(new ImageIcon(url));
    }

    public void setColumnVisible(Object identifier, boolean visible) {
        TableColumn aColumn = this.columnModel.getAllColumn(identifier);
        this.columnModel.setColumnVisible(aColumn, visible);
    }

    public void setAllColumnsVisible(boolean visible) {
        this.columnModel.setAllColumnsVisible(visible);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.line.setText("All titles (" + this.songList.getRowCount() + ")");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.line.setText("Selected titles (" + this.table.getSelectedRowCount() + ")");
    }

    class PopupListener
    extends MouseAdapter
    implements ItemListener {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu();
                Iterator i = SongListTable.this.columnModel.getAllColumns();
                while (i.hasNext()) {
                    TableColumn aColumn = (TableColumn)i.next();
                    boolean isVisible = SongListTable.this.columnModel.isVisible(aColumn);
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(aColumn.getIdentifier().toString(), isVisible);
                    item.addItemListener(this);
                    popup.add(item);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JMenuItem item = (JMenuItem)e.getItem();
            boolean visible = e.getStateChange() == 1;
            TableColumn aColumn = SongListTable.this.columnModel.getAllColumn(item.getText());
            SongListTable.this.columnModel.setColumnVisible(aColumn, visible);
        }
    }

    class JTableButtonMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private void forwardEvent(MouseEvent e) {
            TableColumnModel columnModel = SongListTable.this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / SongListTable.this.table.getRowHeight();
            if (row >= SongListTable.this.table.getRowCount() || row < 0 || column >= SongListTable.this.table.getColumnCount() || column < 0) {
                return;
            }
            SongList songList = (SongList)SongListTable.this.table.getModel();
            songList.actionPerformed(row, column);
        }
    }

    class SongListButtonRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == SongList.PLAY_BUTTON) {
                return SongListTable.this.buttonPlay;
            }
            if (value == SongList.ADD_BUTTON) {
                return SongListTable.this.buttonAdd;
            }
            if (value == SongList.DOWN_BUTTON) {
                return SongListTable.this.buttonDown;
            }
            if (value == SongList.UP_BUTTON) {
                return SongListTable.this.buttonUp;
            }
            if (value == SongList.DELETE_BUTTON) {
                return SongListTable.this.buttonDelete;
            }
            return null;
        }
    }
}

