/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.net.CliListener;
import org.titmuss.softsqueeze.net.CliMessage;

public class CliConnection {
    private static final Logger logger = Logger.getLogger((String)"cli");
    private static final int DISCONNECTED = 0;
    private static final int CONNECTED = 1;
    private Socket socket;
    private BufferedReader socketIn;
    private PrintWriter socketOut;
    private LinkedList sendQueue = new LinkedList();
    private LinkedList readQueue = new LinkedList();
    private HashMap listeners = new HashMap();
    private HashMap listenFilters = new HashMap();
    private Object lock = new Object();
    private InetAddress serverAddress;
    private int serverPort;
    private int toState = 0;
    private int inState = 0;
    private CliSend cliSend = new CliSend();
    private CliRead cliRead;

    public CliConnection() {
        this.cliSend.start();
        this.cliRead = new CliRead();
        this.cliRead.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetAddress addr, int port) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.disconnect();
            while (this.inState == 1) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.serverAddress = addr;
            this.serverPort = port;
            this.toState = 1;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected()) {
                return;
            }
            this.toState = 0;
            this.lock.notifyAll();
        }
    }

    public boolean isConnected() {
        return this.inState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessage(CliListener callback, CliMessage command) {
        Object object = this.lock;
        synchronized (object) {
            this.sendQueue.add(new MessageEntry(command, callback));
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(CliMessage filter, CliListener callback) {
        logger.debug((Object)("addFilter " + filter.toString()));
        Object object = this.lock;
        synchronized (object) {
            Integer count;
            if (this.listenFilters.size() == 0) {
                this.queueMessage(null, new CliMessage("listen").addParameter("1"));
            }
            if ((count = (Integer)this.listeners.get(callback)) == null) {
                this.listeners.put(callback, new Integer(1));
            } else {
                this.listeners.put(callback, new Integer(count + 1));
            }
            ArrayList<CliListener> l = (ArrayList<CliListener>)this.listenFilters.get(filter);
            if (l == null) {
                l = new ArrayList<CliListener>();
                this.listenFilters.put(filter, l);
            }
            l.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(CliMessage filter, CliListener callback) {
        logger.debug((Object)("removeFilter " + filter.toString()));
        Object object = this.lock;
        synchronized (object) {
            Integer count;
            ArrayList l = (ArrayList)this.listenFilters.get(filter);
            if (l == null) {
                return;
            }
            l.remove(callback);
            if (l.size() == 0) {
                this.listenFilters.remove(filter);
            }
            if ((count = (Integer)this.listeners.get(callback)) == null || count == 1) {
                this.listeners.remove(callback);
            } else {
                this.listeners.put(callback, new Integer(count - 1));
            }
            if (this.listenFilters.size() == 0) {
                this.queueMessage(null, new CliMessage("listen").addParameter("0"));
            }
        }
    }

    private class MessageEntry {
        CliListener callback;
        CliMessage message;

        MessageEntry(CliMessage command, CliListener callback) {
            this.message = command;
            this.callback = callback;
        }

        CliListener getCallback() {
            return this.callback;
        }

        CliMessage getMessage() {
            return this.message;
        }
    }

    private class CliRead
    extends Thread {
        private CliRead() {
            super("CliRead");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = CliConnection.this.lock;
                synchronized (object) {
                    while (CliConnection.this.toState != 1) {
                        try {
                            CliConnection.this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = CliConnection.this.lock;
                synchronized (object) {
                    logger.debug((Object)"CLI connecting ...");
                    boolean connected = false;
                    while (!connected) {
                        try {
                            CliConnection.this.socket = new Socket(CliConnection.this.serverAddress, CliConnection.this.serverPort);
                            CliConnection.this.socketIn = new BufferedReader(new InputStreamReader(CliConnection.this.socket.getInputStream()));
                            CliConnection.this.socketOut = new PrintWriter(CliConnection.this.socket.getOutputStream());
                            connected = true;
                        }
                        catch (IOException e) {
                            logger.debug((Object)"Cannot connect CLI socket", (Throwable)e);
                        }
                        if (connected) continue;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    logger.debug((Object)"CLI connected");
                    CliConnection.this.inState = 1;
                    CliConnection.this.lock.notifyAll();
                    for (Object l : CliConnection.this.listeners.keySet()) {
                        l.cliConnected();
                    }
                }
                while (CliConnection.this.toState == 1) {
                    try {
                        Object l;
                        String line = CliConnection.this.socketIn.readLine();
                        if (line == null) break;
                        logger.debug((Object)("got reply " + line));
                        CliMessage msg = CliMessage.parseMessage(line);
                        MessageEntry entry = null;
                        l = CliConnection.this.lock;
                        synchronized (l) {
                            if (!CliConnection.this.readQueue.isEmpty()) {
                                entry = (MessageEntry)CliConnection.this.readQueue.getFirst();
                                if (entry.getMessage().equals(msg)) {
                                    CliConnection.this.readQueue.removeFirst();
                                    CliConnection.this.lock.notifyAll();
                                } else {
                                    entry = null;
                                }
                            }
                        }
                        if (entry != null && entry.getCallback() != null) {
                            entry.getCallback().cliMessage(msg);
                        }
                        for (Map.Entry e : CliConnection.this.listenFilters.entrySet()) {
                            CliMessage filter = (CliMessage)e.getKey();
                            if (!msg.equals(filter)) continue;
                            ArrayList l2 = (ArrayList)e.getValue();
                            for (CliListener listener : l2) {
                                listener.cliMessage(msg);
                            }
                        }
                    }
                    catch (IOException e) {
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception in CliRead", (Throwable)e);
                    }
                }
                object = CliConnection.this.lock;
                synchronized (object) {
                    try {
                        CliConnection.this.socketOut.close();
                        CliConnection.this.socketIn.close();
                        CliConnection.this.socket.close();
                    }
                    catch (IOException msg) {
                        // empty catch block
                    }
                    logger.debug((Object)"CLI disconnected");
                    CliConnection.this.readQueue.clear();
                    CliConnection.this.listenFilters.clear();
                    CliConnection.this.inState = 0;
                    CliConnection.this.lock.notifyAll();
                    for (CliListener l : CliConnection.this.listeners.keySet()) {
                        l.cliDisconnected();
                    }
                }
            }
        }
    }

    private class CliSend
    extends Thread {
        private CliSend() {
            super("CliSend");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = CliConnection.this.lock;
                synchronized (object) {
                    while (CliConnection.this.inState != 1) {
                        try {
                            CliConnection.this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    MessageEntry entry;
                    Object object2 = CliConnection.this.lock;
                    synchronized (object2) {
                        while (CliConnection.this.sendQueue.isEmpty()) {
                            try {
                                CliConnection.this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        entry = (MessageEntry)CliConnection.this.sendQueue.removeFirst();
                        if (!CliConnection.this.isConnected()) {
                            continue;
                        }
                        CliConnection.this.readQueue.add(entry);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("send cli msg: " + entry.getMessage()));
                    }
                    CliConnection.this.socketOut.print(entry.getMessage() + "\n");
                    CliConnection.this.socketOut.flush();
                    object2 = CliConnection.this.lock;
                    synchronized (object2) {
                        while (!CliConnection.this.readQueue.isEmpty()) {
                            try {
                                CliConnection.this.lock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Exception in CliSend", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

