/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.net;

import java.util.ArrayList;
import org.titmuss.softsqueeze.net.CliParameterIterator;

public class CliMessage {
    private static final String[] globalCommands = new String[]{"login", "debug", "listen", "pref", "exit", "player", "rescan", "wipecache", "info", "genres", "artists", "albums", "songinfo", "titles", "songs", "playlists"};
    private char[] msg;
    private int idx;
    private String playerid;
    private String command;
    private ArrayList parameters = new ArrayList();

    public CliMessage(String command) {
        this(null, command);
    }

    public CliMessage(String playerid, String command) {
        if (command == null) {
            throw new IllegalArgumentException("Command cannot be null");
        }
        this.playerid = playerid;
        this.command = command;
    }

    private CliMessage(char[] msg) {
        this.msg = msg;
        this.playerid = this.parseNextParameter();
        for (int i = 0; i < globalCommands.length; ++i) {
            if (!this.playerid.equals(globalCommands[i])) continue;
            this.command = this.playerid;
            this.playerid = null;
            break;
        }
        if (this.command == null) {
            this.command = this.parseNextParameter();
        }
        while (this.idx < msg.length) {
            this.parameters.add(this.parseNextParameter());
        }
    }

    public static CliMessage parseMessage(String msg) {
        return new CliMessage(msg.toCharArray());
    }

    public CliMessage addParameter(String parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public CliMessage addParameter(String tag, String value) {
        this.parameters.add(tag + ":" + value);
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public String getPlayerid() {
        return this.playerid;
    }

    public CliParameterIterator getParameterIterator() {
        return new CliParameterIterator(this.parameters);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.playerid != null) {
            CliMessage.urlEncode(buf, this.playerid);
            buf.append(" ");
        }
        buf.append(this.command);
        for (String str : this.parameters) {
            buf.append(" ");
            CliMessage.urlEncode(buf, str);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CliMessage)) {
            return false;
        }
        CliMessage msg = (CliMessage)obj;
        if (this.playerid == null) {
            return msg.playerid == null && this.command.equals(msg.command);
        }
        return this.playerid.equals(msg.playerid) && this.command.equals(msg.command);
    }

    public int hashCode() {
        return this.command.hashCode();
    }

    private static void urlEncode(StringBuffer buf, String s) {
        char[] c = s.toCharArray();
        block3: for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '\u001f' || c[i] >= '\u007f') {
                buf.append('%');
                buf.append(Integer.toString(c[i], 16).toUpperCase());
                continue;
            }
            switch (c[i]) {
                case ' ': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buf.append('%');
                    buf.append(Integer.toString(c[i], 16).toUpperCase());
                    continue block3;
                }
                default: {
                    buf.append(c[i]);
                }
            }
        }
    }

    private String parseNextParameter() {
        StringBuffer tok = new StringBuffer();
        block4: while (this.idx < this.msg.length) {
            char c = this.msg[this.idx++];
            switch (c) {
                case ' ': {
                    return tok.toString();
                }
                case '%': {
                    c = (char)(CliMessage.convertHexDigit(this.msg[this.idx++]) << 4 | CliMessage.convertHexDigit(this.msg[this.idx++]));
                    tok.append(c);
                    continue block4;
                }
            }
            tok.append(c);
        }
        return tok.toString();
    }

    private static byte convertHexDigit(char b) {
        if (b >= '0' && b <= '9') {
            return (byte)(b - 48);
        }
        if (b >= 'a' && b <= 'f') {
            return (byte)(b - 97 + 10);
        }
        if (b >= 'A' && b <= 'F') {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }
}

