/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.net.ProtocolListener;

public class Protocol {
    private static Logger logger = Logger.getLogger((String)"slimproto");
    private static HashMap discoveredServers = new HashMap();
    private static int threadCount = 0;
    private long epoch;
    private HashMap commandListeners = new HashMap();
    private HashSet connectionListeners = new HashSet();
    private TcpSocket tcpSocket;
    private boolean helosent = false;
    private UdpSocket udpSocket;
    private boolean verbose = true;

    public Protocol() {
        this.epoch = System.currentTimeMillis();
        this.udpSocket = new UdpSocket();
        this.udpSocket.start();
    }

    public void addProtocolListener(String cmd, ProtocolListener listener) {
        ArrayList<ProtocolListener> l = (ArrayList<ProtocolListener>)this.commandListeners.get(cmd);
        if (l == null) {
            l = new ArrayList<ProtocolListener>();
            this.commandListeners.put(cmd, l);
        }
        l.add(listener);
        this.connectionListeners.add(listener);
    }

    public void removeProtocolListener(String cmd, ProtocolListener listener) {
        ArrayList l = (ArrayList)this.commandListeners.get(cmd);
        if (l == null) {
            return;
        }
        l.remove(listener);
        this.connectionListeners.add(listener);
    }

    public void connect(InetAddress addr, int port) {
        if (addr == null || port < 0) {
            logger.debug((Object)"Invalid server parameters");
            return;
        }
        this.tcpSocket = new TcpSocket(addr, port);
        this.tcpSocket.start();
    }

    public boolean isConnected() {
        if (this.tcpSocket == null) {
            return false;
        }
        return this.tcpSocket.isConnected();
    }

    public int getJiffies() {
        return (int)(System.currentTimeMillis() - this.epoch);
    }

    public static HashMap getDiscoveredServers() {
        return discoveredServers;
    }

    public void sendDiscoveryRequest(int deviceID, int revision, byte[] macaddress) {
        byte[] args = new byte[18];
        args[0] = 100;
        args[2] = (byte)deviceID;
        args[3] = (byte)revision;
        System.arraycopy(macaddress, 0, args, 12, 6);
        try {
            InetAddress broadcast = InetAddress.getByName("255.255.255.255");
            DatagramPacket p = new DatagramPacket(args, 18, broadcast, 3483);
            this.udpSocket.send(p);
        }
        catch (IOException e) {
            logger.error((Object)"Sending broadcast packet", (Throwable)e);
        }
    }

    public void sendHELO(int deviceID, int revision, byte[] macaddress, boolean isGraphics, boolean isReconnect) {
        if (!this.isConnected()) {
            return;
        }
        try {
            byte[] args = new byte[10];
            args[0] = (byte)deviceID;
            args[1] = (byte)revision;
            System.arraycopy(macaddress, 0, args, 2, 6);
            int channelList = 0;
            if (isGraphics) {
                channelList |= 0x8000;
            }
            if (isReconnect) {
                channelList |= 0x4000;
            }
            Protocol.packN2(args, 8, channelList);
            this.sendCommand("HELO", args);
            this.helosent = true;
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendHelo", (Throwable)e);
        }
    }

    public void sendIR(int format, int noBits, int irCode) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            byte[] args = new byte[10];
            Protocol.packN4(args, 0, this.getJiffies());
            args[4] = (byte)format;
            args[5] = (byte)noBits;
            Protocol.packN4(args, 6, irCode);
            this.sendCommand("IR  ", args);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendIR", (Throwable)e);
        }
    }

    public void sendButton(int code) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            byte[] args = new byte[8];
            Protocol.packN4(args, 0, this.getJiffies());
            Protocol.packN4(args, 4, code);
            this.sendCommand("BUTN", args);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendBUTN", (Throwable)e);
        }
    }

    public void sendKnob(int position, int sync) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            byte[] args = new byte[9];
            Protocol.packN4(args, 0, this.getJiffies());
            Protocol.packN4(args, 4, position);
            args[8] = (byte)sync;
            this.sendCommand("KNOB", args);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendIR", (Throwable)e);
        }
    }

    public void sendANIC() {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            this.sendCommand("ANIC", new byte[0]);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendIR", (Throwable)e);
        }
    }

    public void sendStat(String code, byte crlf, byte masInit, byte masMode, int rptr, int wptr, long bytesRx, byte wirelessSignal, int outputBufferSize, int outputBufferFullness, long elapsedMilliseconds, int timestamp) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            byte[] args = new byte[51];
            System.arraycopy(code.getBytes(), 0, args, 0, 4);
            args[4] = crlf;
            args[5] = masInit;
            args[6] = masMode;
            Protocol.packN4(args, 7, rptr);
            Protocol.packN4(args, 11, wptr);
            Protocol.packN8(args, 15, bytesRx);
            Protocol.packN2(args, 23, wirelessSignal);
            Protocol.packN4(args, 25, this.getJiffies());
            Protocol.packN4(args, 29, outputBufferSize);
            Protocol.packN4(args, 33, outputBufferFullness);
            Protocol.packN4(args, 37, (int)(elapsedMilliseconds / 1000L));
            Protocol.packN4(args, 41, 0);
            Protocol.packN4(args, 43, (int)elapsedMilliseconds);
            Protocol.packN4(args, 47, timestamp);
            this.sendCommand("STAT", args);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendStat", (Throwable)e);
        }
    }

    public void sendDsco(int code) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            byte[] args = new byte[]{(byte)code};
            this.sendCommand("DSCO", args);
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendDsco", (Throwable)e);
        }
    }

    public void sendBody(String body) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            this.sendCommand("BODY", body.getBytes());
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendMeta", (Throwable)e);
        }
    }

    public void sendResp(String headers) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            this.sendCommand("RESP", headers.getBytes());
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendMeta", (Throwable)e);
        }
    }

    public void sendMeta(String metadata) {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            this.sendCommand("META", metadata.getBytes());
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendMeta", (Throwable)e);
        }
    }

    public void sendBye() {
        if (!this.isConnected() || !this.helosent) {
            return;
        }
        try {
            this.sendCommand("BYE!", new byte[1]);
            this.tcpSocket.close();
            this.tcpSocket = null;
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in sendBye", (Throwable)e);
        }
    }

    private void sendCommand(String cmd, byte[] args) throws IOException {
        int len = args.length;
        byte[] buf = new byte[len + 8];
        System.arraycopy(cmd.getBytes(), 0, buf, 0, 4);
        Protocol.packN4(buf, 4, len);
        System.arraycopy(args, 0, buf, 8, args.length);
        this.tcpSocket.write(buf);
        logger.debug((Object)("tcp send: " + cmd + " length=" + len));
    }

    private void socketConnected(TcpSocket socket) {
        if (this.tcpSocket != socket) {
            return;
        }
        logger.debug((Object)"command socket connected");
        for (ProtocolListener p : this.connectionListeners) {
            p.slimprotoConnected();
        }
    }

    private void socketDisconnected(TcpSocket socket) {
        if (this.tcpSocket != socket) {
            return;
        }
        logger.debug((Object)"command socket disconnected");
        for (ProtocolListener p : this.connectionListeners) {
            p.slimprotoDisconnected();
        }
    }

    private void socketCommand(byte[] buf, int offset, int len) {
        ArrayList l;
        String cmd = new String(buf, offset, 4);
        offset += 4;
        if (logger.isDebugEnabled()) {
            if (this.verbose) {
                StringBuffer str = new StringBuffer();
                str.append("tcp recv: " + cmd + " ");
                for (int i = offset; i < len; ++i) {
                    str.append(Integer.toString(buf[i] & 0xFF, 16));
                    str.append(" ");
                }
                logger.debug((Object)str.toString());
            } else {
                logger.debug((Object)("tcp recv: " + cmd + " length=" + len));
            }
        }
        if ((l = (ArrayList)this.commandListeners.get(cmd)) == null) {
            return;
        }
        for (ProtocolListener p : l) {
            p.slimprotoCmd(cmd, buf, offset, len);
        }
    }

    public static int unpackN2(byte[] buf, int pos) {
        return (buf[pos++] & 0xFF) << 8 | buf[pos] & 0xFF;
    }

    public static int unpackN4(byte[] buf, int pos) {
        return (buf[pos++] & 0xFF) << 24 | (buf[pos++] & 0xFF) << 16 | (buf[pos++] & 0xFF) << 8 | buf[pos] & 0xFF;
    }

    public static float unpackFixedPoint(byte[] buf, int pos) {
        int v = Protocol.unpackN4(buf, pos);
        return (float)((v & 0xFFFF0000) >> 16) + (float)(v & 0xFFFF) / 65535.0f;
    }

    public static void packN2(byte[] buf, int pos, int arg) {
        buf[pos++] = (byte)(arg >> 8 & 0xFF);
        buf[pos] = (byte)(arg >> 0 & 0xFF);
    }

    public static void packN4(byte[] buf, int pos, int arg) {
        buf[pos++] = (byte)(arg >> 24 & 0xFF);
        buf[pos++] = (byte)(arg >> 16 & 0xFF);
        buf[pos++] = (byte)(arg >> 8 & 0xFF);
        buf[pos] = (byte)(arg >> 0 & 0xFF);
    }

    public static void packN8(byte[] buf, int pos, long arg) {
        buf[pos++] = (byte)(arg >> 56 & 0xFFL);
        buf[pos++] = (byte)(arg >> 48 & 0xFFL);
        buf[pos++] = (byte)(arg >> 40 & 0xFFL);
        buf[pos++] = (byte)(arg >> 32 & 0xFFL);
        buf[pos++] = (byte)(arg >> 24 & 0xFFL);
        buf[pos++] = (byte)(arg >> 16 & 0xFFL);
        buf[pos++] = (byte)(arg >> 8 & 0xFFL);
        buf[pos++] = (byte)(arg >> 0 & 0xFFL);
    }

    public long getEpoch() {
        return this.epoch;
    }

    private class UdpSocket
    extends Thread {
        private DatagramSocket socket;

        UdpSocket() {
            super("SlimUDP-" + threadCount++);
            try {
                this.socket = new DatagramSocket();
                logger.debug((Object)"SlimUDP socket open");
            }
            catch (IOException e) {
                logger.error((Object)"Error with udp socket", (Throwable)e);
            }
        }

        void send(DatagramPacket p) throws IOException {
            this.socket.send(p);
        }

        @Override
        public void run() {
            logger.debug((Object)"SlimUDP thread started");
            try {
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (true) {
                    this.socket.receive(packet);
                    if (Protocol.this.verbose) {
                        StringBuffer str = new StringBuffer();
                        str.append("udp recv: ");
                        for (int i = 0; i < packet.getLength(); ++i) {
                            str.append(Integer.toString(buf[i] & 0xFF, 16));
                            str.append(" ");
                        }
                        logger.debug((Object)str.toString());
                    }
                    if (buf[0] == 68) {
                        String servername = new String(buf, 1, packet.getLength()).trim();
                        discoveredServers.put(servername, packet.getAddress().getHostAddress());
                        continue;
                    }
                    Protocol.this.socketCommand(buf, 0, buf.length);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error with udp socket", (Throwable)e);
                return;
            }
        }
    }

    private class TcpSocket
    extends Thread {
        private InetAddress addr;
        private int port;
        private Socket socket;
        private boolean connected;
        private boolean closeSocket;

        TcpSocket(InetAddress addr, int port) {
            super("SlimTCP-" + threadCount++);
            this.connected = false;
            this.closeSocket = false;
            this.addr = addr;
            this.port = port;
        }

        boolean isConnected() {
            return this.connected;
        }

        void close() throws IOException {
            this.closeSocket = true;
            if (this.socket != null) {
                this.socket.close();
            }
        }

        void write(byte[] buf) throws IOException {
            OutputStream stream = this.socket.getOutputStream();
            stream.write(buf);
        }

        int blockingRead(InputStream stream, byte[] b, int off, int len) throws IOException {
            int total;
            int ok;
            for (total = 0; total < len; total += ok) {
                ok = stream.read(b, off + total, len - total);
                if (ok >= 0) continue;
                return ok;
            }
            return total;
        }

        @Override
        public synchronized void run() {
            byte[] buf = new byte[4048];
            logger.debug((Object)"SlimTCP thread started");
            while (!this.closeSocket) {
                while (!this.connected) {
                    logger.debug((Object)("connecting command socket " + this.addr + ":" + this.port));
                    try {
                        this.socket = new Socket(this.addr, this.port);
                        this.socket.setTcpNoDelay(true);
                        this.connected = true;
                        Protocol.this.helosent = false;
                    }
                    catch (IOException e) {
                        logger.debug((Object)("cannot connect to " + this.addr + ":" + this.port));
                    }
                    if (this.connected) continue;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
                Protocol.this.socketConnected(this);
                block11: while (true) {
                    try {
                        while (true) {
                            InputStream stream;
                            int ok;
                            if ((ok = this.blockingRead(stream = this.socket.getInputStream(), buf, 0, 2)) < 0) {
                                logger.debug((Object)"end of stream detected reading header");
                                break block11;
                            }
                            int len = Protocol.unpackN2(buf, 0);
                            ok = this.blockingRead(stream, buf, 0, len);
                            if (ok < 0 || ok != len) {
                                logger.debug((Object)"end of stream detected reading frame");
                                break block11;
                            }
                            Protocol.this.socketCommand(buf, 0, len);
                        }
                    }
                    catch (IOException e) {
                        logger.debug((Object)"ioexception reading from slimproto", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception processing frame ", (Throwable)e);
                        continue;
                    }
                    break;
                }
                logger.debug((Object)"command socket disconnected");
                this.connected = false;
                Protocol.this.helosent = false;
                Protocol.this.socketDisconnected(this);
                this.notifyAll();
            }
            try {
                logger.debug((Object)"closing command socket");
                this.socket.close();
            }
            catch (IOException e) {
                logger.error((Object)"Exception closing command socket", (Throwable)e);
            }
        }
    }
}

