/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.net;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.skin.OptionPanel;
import org.titmuss.softsqueeze.util.Util;

public class SSHTunnel {
    private static Logger logger = Logger.getLogger((String)"ssh");
    private JSch jsch = null;
    private Session session1;
    private Session session2;

    public SSHTunnel() {
        try {
            this.jsch = new JSch();
            File dotSsh = new File(System.getProperty("user.home"), ".ssh");
            if (!dotSsh.exists()) {
                dotSsh.mkdirs();
            }
            File knownHosts = new File(dotSsh, "known_hosts");
            this.jsch.setKnownHosts(knownHosts.getAbsolutePath());
            String privatekey = Config.getProperty("sshprivatekey");
            if (privatekey.length() > 0) {
                logger.debug((Object)("Setting ssh identity " + privatekey));
                this.jsch.addIdentity(privatekey);
            }
        }
        catch (JSchException e) {
            logger.error((Object)"Cannot initialise jsch", (Throwable)e);
        }
    }

    public void connect() throws IOException {
        try {
            String username;
            if (this.session1 != null && this.session1.isConnected()) {
                return;
            }
            SshUserInfo userInfo = new SshUserInfo();
            String slimserver = Config.getProperty("slimserver");
            String sshserver = Config.getProperty("sshserver");
            int port = Config.getIntegerProperty("sshport");
            String forward = Config.getProperty("sshforwardports");
            String sshProxy = Config.getSSHProxy();
            String sshProxyHost = Config.getSSHProxyHost();
            int sshProxyPort = Config.getSSHProxyPort();
            if (slimserver.equals(sshserver)) {
                slimserver = "127.0.0.1";
            }
            if ((username = userInfo.getUsername()) == null) {
                userInfo.promptUsernameAndPassword("Username and password for " + slimserver);
                username = userInfo.getUsername();
            }
            int slimport = Config.getSlimProtoPort();
            int httpport = Config.getServerHttpPort();
            int webport = Config.getServerWebPort();
            this.session1 = this.jsch.getSession(username, sshserver, port);
            this.session1.setUserInfo((UserInfo)userInfo);
            if (sshProxy.equals("Socks 5")) {
                this.session1.setProxy((Proxy)new ProxySOCKS5(sshProxyHost, sshProxyPort));
            } else if (sshProxy.equals("HTTP")) {
                this.session1.setProxy((Proxy)new ProxyHTTP(sshProxyHost, sshProxyPort));
            }
            this.session1.connect();
            this.session1.setPortForwardingL(slimport, slimserver, slimport);
            this.session1.setPortForwardingL(webport, slimserver, httpport);
            String[] forwards = Util.split(forward, ",");
            for (int i = 0; i < forwards.length; ++i) {
                int fport = Integer.parseInt(forwards[i]);
                if (fport == slimport || fport == httpport) continue;
                this.session1.setPortForwardingL(fport, slimserver, fport);
            }
            this.session2 = this.jsch.getSession(username, sshserver, port);
            this.session2.setUserInfo((UserInfo)userInfo);
            userInfo.passwordSet = true;
            if (sshProxy.equals("Socks 5")) {
                this.session2.setProxy((Proxy)new ProxySOCKS5(sshProxyHost, sshProxyPort));
            } else if (sshProxy.equals("HTTP")) {
                this.session2.setProxy((Proxy)new ProxyHTTP(sshProxyHost, sshProxyPort));
            }
            this.session2.connect();
            this.session2.setPortForwardingL(httpport, slimserver, httpport);
        }
        catch (JSchException e) {
            logger.error((Object)"Cannot connect ssh tunnel", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public void disconnect() {
        if (this.session1 != null) {
            this.session1.disconnect();
            this.session1 = null;
        }
        if (this.session2 != null) {
            this.session2.disconnect();
            this.session2 = null;
        }
    }

    private class SshUserInfo
    implements UserInfo {
        String username;
        char[] password;
        char[] passphrase;
        boolean passwordSet = false;
        JTextField usernameField = new JTextField(20);
        JPasswordField passwordField = new JPasswordField(20);
        JPasswordField passphraseField = new JPasswordField(20);
        JCheckBox storePassword = new JCheckBox();

        public SshUserInfo() {
            this.username = Config.getProperty("sshusername");
            if (this.username != null && this.username.equals("")) {
                this.username = null;
            }
            this.password = Config.getPassword("sshpassword");
            if (this.password != null && this.password.equals("")) {
                this.password = null;
            }
            if (this.password != null) {
                this.passwordSet = true;
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return new String(this.password);
        }

        public String getPassphrase() {
            return new String(this.passphrase);
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, "SoftSqueeze: " + message);
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int result = JOptionPane.showOptionDialog(null, str, "SoftSqueeze: Warning", -1, 2, null, options, options[0]);
            return result == 0;
        }

        public boolean promptPassphrase(String message) {
            OptionPanel ob = new OptionPanel();
            ob.add((Component)new JLabel("Passphrase"), (Component)this.passphraseField);
            int result = JOptionPane.showConfirmDialog(null, ob, "SoftSqueeze: " + message, 2);
            if (result == 0) {
                this.passphrase = this.passphraseField.getPassword();
                return true;
            }
            return false;
        }

        public boolean promptUsernameAndPassword(String message) {
            int result;
            OptionPanel ob = new OptionPanel();
            ob.add((Component)new JLabel("Username"), (Component)this.usernameField);
            ob.add((Component)new JLabel("Password"), (Component)this.passwordField);
            if (Config.getBooleanProperty("enablestorepassword")) {
                ob.add((Component)new JLabel("Store password"), (Component)this.storePassword);
            }
            if ((result = JOptionPane.showConfirmDialog(null, ob, "SoftSqueeze: " + message, 2)) == 0) {
                this.username = this.usernameField.getText();
                this.password = this.passwordField.getPassword();
                Config.putProperty("sshusername", this.username);
                if (this.storePassword.isSelected()) {
                    Config.putPassword("sshpassword", this.password);
                } else {
                    Config.putPassword("sshpassword", null);
                }
                this.passwordSet = true;
                return true;
            }
            return false;
        }

        public boolean promptPassword(String message) {
            int result;
            if (this.passwordSet) {
                this.passwordSet = false;
                return true;
            }
            OptionPanel ob = new OptionPanel();
            ob.add((Component)new JLabel("Password"), (Component)this.passwordField);
            if (Config.getBooleanProperty("enablestorepassword")) {
                ob.add((Component)new JLabel("Store password?"), (Component)this.storePassword);
            }
            if ((result = JOptionPane.showConfirmDialog(null, ob, "SoftSqueeze: " + message, 2)) == 0) {
                this.password = this.passwordField.getPassword();
                if (this.storePassword.isSelected()) {
                    Config.putPassword("sshpassword", this.password);
                } else {
                    Config.putPassword("sshpassword", null);
                }
                return true;
            }
            return false;
        }
    }
}

