/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.titmuss.softsqueeze.platform.Platform;

public class MacPlatform
extends Platform {
    @Override
    protected String _getHostMacAddress() {
        try {
            Process p = Runtime.getRuntime().exec("ifconfig");
            BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = is.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(" ");
                line = is.readLine();
            }
            is.close();
            int status = p.waitFor();
            if (status != 0) {
                logger.warn((Object)("ifconfig returned s=" + status + " " + sb.toString()));
                return null;
            }
            Pattern macPattern = Pattern.compile(".*(\\w\\w:\\w\\w:\\w\\w:\\w\\w:\\w\\w:\\w\\w).*");
            Matcher macMatcher = macPattern.matcher(sb.toString());
            if (macMatcher.matches()) {
                return macMatcher.group(1);
            }
            logger.warn((Object)("Cannot find mac address " + sb.toString()));
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"Error in ifconfig", (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error in ifconfig", (Throwable)e);
            return null;
        }
    }
}

