/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.platform;

import com.Ostermiller.util.Browser;
import java.applet.AppletContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Applet;
import org.titmuss.softsqueeze.platform.LinuxPlatform;
import org.titmuss.softsqueeze.platform.MacPlatform;
import org.titmuss.softsqueeze.platform.WindowsPlatform;
import org.titmuss.softsqueeze.util.Util;

public class Platform {
    protected static Logger logger = Logger.getLogger((String)"platform");
    public static final boolean JRE_1_3_PLUS;
    public static final boolean JRE_1_4_PLUS;
    public static final boolean JRE_1_5_PLUS;
    public static final boolean JRE_1_6_PLUS;
    private static Platform instance;
    private static BasicService basicService;
    private static AppletContext appletContext;
    private byte[] macAddress;

    public static Platform init() {
        return Platform.init(null);
    }

    public static Platform init(Applet applet) {
        if (instance != null) {
            return instance;
        }
        String os = System.getProperty("os.name");
        instance = !JRE_1_4_PLUS ? new Platform() : (os.indexOf("Windows") != -1 ? new WindowsPlatform() : (os.indexOf("Linux") != -1 ? new LinuxPlatform() : (os.indexOf("Mac OS X") != -1 ? new MacPlatform() : new Platform())));
        if (applet != null) {
            appletContext = applet.getAppletContext();
        } else {
            try {
                basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            }
            catch (UnavailableServiceException e) {
                logger.debug((Object)"JNLP basic service unavailable");
                Browser.init();
            }
        }
        logger.debug((Object)("os='" + os + "' platform=" + instance));
        return instance;
    }

    public static byte[] getMacAddress() {
        if (instance == null) {
            throw new IllegalArgumentException("Platform not initialised");
        }
        return instance._getMacAddress();
    }

    public static String macAddressToString(byte[] macAddress) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < macAddress.length; ++i) {
            buf.append(Integer.toString(macAddress[i] >> 4 & 0xF, 16));
            buf.append(Integer.toString(macAddress[i] & 0xF, 16));
            if (i >= macAddress.length - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public static byte[] parseMacAddress(String mac) {
        byte[] macAddress = new byte[6];
        String[] hex = Util.split(mac, ":-");
        for (int i = 0; i < Math.min(hex.length, macAddress.length); ++i) {
            macAddress[i] = (byte)Integer.parseInt(hex[i], 16);
        }
        return macAddress;
    }

    public static boolean displayUrl(URL url) {
        return Platform._displayUrl(url);
    }

    public static boolean displayUrl(String url) {
        try {
            return Platform.displayUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Malformed URL: " + url));
            return false;
        }
    }

    protected Platform() {
    }

    protected byte[] _getMacAddress() {
        if (this.macAddress != null) {
            return this.macAddress;
        }
        if (!JRE_1_4_PLUS) {
            try {
                InetAddress localaddr = InetAddress.getLocalHost();
                byte[] ipAddress = localaddr.getAddress();
                this.macAddress = new byte[6];
                for (int i = 0; i < 4; ++i) {
                    this.macAddress[i + 2] = ipAddress[i];
                }
                logger.debug((Object)("using ipaddress as mac address: " + Platform.macAddressToString(this.macAddress)));
                return this.macAddress;
            }
            catch (UnknownHostException localaddr) {
                // empty catch block
            }
        }
        this.macAddress = new byte[6];
        for (int i = 0; i < this.macAddress.length; ++i) {
            this.macAddress[i] = (byte)(Math.random() * 255.0);
        }
        logger.debug((Object)("using random mac address: " + Platform.macAddressToString(this.macAddress)));
        return this.macAddress;
    }

    protected String _getHostMacAddress() {
        return null;
    }

    protected static boolean _displayUrl(URL url) {
        try {
            if (appletContext != null) {
                logger.debug((Object)"using applet showDocument");
                appletContext.showDocument(url, "softsqueeze");
                return true;
            }
            if (basicService != null) {
                logger.debug((Object)"using jnlp showDocument");
                return basicService.showDocument(url);
            }
            logger.debug((Object)"using ostermiller-utils displayURL");
            Browser.displayURL(url.toString());
            return true;
        }
        catch (IOException e) {
            logger.error((Object)("Error displaying url=" + url), (Throwable)e);
            return false;
        }
    }

    static {
        boolean temp = false;
        try {
            StrictMath.abs(1.0);
            temp = true;
        }
        catch (Error error) {
            // empty catch block
        }
        JRE_1_3_PLUS = temp;
        if (temp) {
            temp = false;
            try {
                " ".subSequence(0, 0);
                temp = true;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        JRE_1_4_PLUS = temp;
        if (temp) {
            temp = false;
            try {
                " ".codePointAt(0);
                temp = true;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        JRE_1_5_PLUS = temp;
        if (temp) {
            temp = false;
            try {
                " ".isEmpty();
                temp = true;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        JRE_1_6_PLUS = temp;
    }
}

