/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinObject;
import org.titmuss.softsqueeze.util.Util;
import org.w3c.dom.Element;

public abstract class Action
extends SkinObject
implements MouseMotionListener,
MouseWheelListener,
MouseListener,
KeyListener {
    protected static final Logger logger = Logger.getLogger(Action.class);
    private int maskRGB;
    protected String script;
    protected String[] arg;
    private String label;
    private String keybinding;

    protected Action(Skin skin, Element e) {
        super(skin, e);
        this.maskRGB = this.parseHexAttribute(e, "maskrgb", 0);
        this.label = this.parseStringAttribute(e, "label", null);
        this.keybinding = this.parseStringAttribute(e, "keybinding", null);
        this.script = this.parseStringAttribute(e, "script", null);
        this.arg = Util.split(this.script, "(,)");
    }

    public int getMaskRGB() {
        return this.maskRGB;
    }

    public String getLabel() {
        return this.label;
    }

    public String getKeybinding() {
        return this.keybinding;
    }

    public boolean isKnobAction() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected Container getWindowForEvent(AWTEvent e) {
        if (this.arg.length > 1) {
            return this.skin.getContainer(this.arg[1]);
        }
        Container c = (Container)e.getSource();
        while (!(c instanceof Window) && c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }
}

