/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.net.ProtocolListener;
import org.titmuss.softsqueeze.skin.Action;
import org.titmuss.softsqueeze.skin.Skin;
import org.w3c.dom.Element;

public class KnobAction
extends Action
implements ProtocolListener {
    private int index = 0;
    private int length = 0;
    private int sync = 0;
    private int flags = 0;
    private int ircode2 = this.arg[1].startsWith("0x") ? Integer.parseInt(this.arg[1].substring(2), 16) : Integer.parseInt(this.arg[1]);
    private int ircode3 = this.arg[2].startsWith("0x") ? Integer.parseInt(this.arg[2].substring(2), 16) : Integer.parseInt(this.arg[2]);
    private long lastUpdate = 0L;
    private boolean accel = false;

    public KnobAction(Skin skin, Element e) {
        super(skin, e);
        this.squeeze.getProtocol().addProtocolListener("knob", this);
    }

    protected void dispose() {
        this.squeeze.getProtocol().removeProtocolListener("knob", this);
    }

    @Override
    public boolean isKnobAction() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 2: {
                this.squeeze.sendIR(1, 1, this.ircode2);
                break;
            }
            case 3: {
                this.squeeze.sendIR(1, 1, this.ircode3);
            }
        }
    }

    @Override
    public synchronized void mouseWheelMoved(MouseWheelEvent e) {
        long t = e.getWhen() - this.lastUpdate;
        this.lastUpdate = e.getWhen();
        this.accel = t < 20L && this.length > 24;
        int newindex = this.index + (this.accel ? e.getWheelRotation() * 10 : e.getWheelRotation());
        if (this.length != 0) {
            if (t < 500L && (newindex < 0 || newindex >= this.length)) {
                if (newindex < 0) {
                    newindex = 0;
                }
                if (newindex >= this.length) {
                    newindex = this.length - 1;
                }
                if (newindex != this.index) {
                    this.index = newindex;
                    this.squeeze.sendKnob(this.index, this.sync);
                }
                return;
            }
            if (newindex < 0 && (this.flags & 1) == 0) {
                newindex = this.length - 1;
            }
            if (newindex >= this.length && (this.flags & 1) == 0) {
                newindex = 0;
            }
        }
        if (newindex != this.index) {
            logger.debug((Object)("mouse wheel moved " + newindex + " length " + this.length));
            this.index = newindex;
            this.squeeze.sendKnob(this.index, this.sync);
        }
    }

    @Override
    public synchronized void slimprotoCmd(String cmd, byte[] buf, int off, int len) {
        this.index = Protocol.unpackN4(buf, off);
        if (len > 10) {
            this.length = Protocol.unpackN4(buf, off + 4);
            this.sync = buf[off + 8];
            this.flags = buf[off + 9];
        }
        logger.debug((Object)("knob command " + this.index + " " + this.length + " " + this.sync + " " + this.flags));
    }

    @Override
    public void slimprotoConnected() {
    }

    @Override
    public void slimprotoDisconnected() {
    }
}

