/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.titmuss.softsqueeze.display.LcdDisplay;
import org.titmuss.softsqueeze.display.LcdDisplayListener;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.w3c.dom.Element;

public class LcdPanel
extends SkinComponent {
    private int scale;
    private int xdiv;
    private int offset;
    private Color fgColor;
    private Color bgColor;

    public LcdPanel(Skin skin, Element e) {
        super(skin, e);
        this.scale = this.parseIntAttribute(e, "scale", 1);
        this.xdiv = this.parseIntAttribute(e, "xdiv", 1);
        this.offset = this.parseIntAttribute(e, "offset", 0);
        this.fgColor = this.parseColorAttribute(e, "fgcolor", Color.green);
        this.bgColor = this.parseColorAttribute(e, "bgcolor", null);
    }

    @Override
    public JComponent createComponent() {
        LcdJPanel panel = new LcdJPanel(this.squeeze.getLcdDisplay());
        panel.setScale(this.scale);
        panel.setWidth(this.xdiv);
        panel.setForeground(this.fgColor);
        if (this.bgColor != null) {
            panel.setBackground(this.bgColor);
        }
        this.squeeze.getLcdDisplay().setColour(this.fgColor, this.bgColor);
        return panel;
    }

    private class LcdJPanel
    extends JPanel
    implements LcdDisplayListener {
        private static final long serialVersionUID = -7331225089982532986L;
        private LcdDisplay display;
        private int scale = 1;
        private int xdiv = 1;
        private int width = 320;
        private int height = 32;
        private Image frame;

        public LcdJPanel(LcdDisplay display) {
            this.display = display;
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.setOpaque(true);
        }

        @Override
        public void updateDisplay(LcdDisplay display, Image frame) {
            this.frame = frame;
            this.repaint();
        }

        public int getScale() {
            return this.scale;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public void setWidth(int xdiv) {
            this.width /= xdiv;
        }

        @Override
        public void setBackground(Color background) {
            super.setBackground(background);
            this.setOpaque(true);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(insets.left + this.width * this.scale + insets.right, insets.top + this.height * this.scale + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.display.addListener(this);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.display.removeListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.frame != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(this.frame, 0, 0, this.width * this.scale, this.height * this.scale, LcdPanel.this.offset, 0, LcdPanel.this.offset + this.width, this.height, this);
            }
        }
    }
}

