/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.music.SongList;
import org.titmuss.softsqueeze.music.SongListTable;
import org.titmuss.softsqueeze.net.CliListener;
import org.titmuss.softsqueeze.net.CliMessage;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.w3c.dom.Element;

public class Playlist
extends SkinComponent
implements AncestorListener,
CliListener {
    protected Color fgcolor;
    protected Color bgcolor;
    protected Font font;
    private SongList songList;
    private long tstamp = 0L;

    public Playlist(Skin skin, Element e) {
        super(skin, e);
        this.fgcolor = this.parseColorAttribute(e, "fgcolor", null);
        this.bgcolor = this.parseColorAttribute(e, "bgcolor", null);
        this.font = this.parseFontAttribute(e, "font", "fontsize", null);
        this.songList = new SongList();
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(this.bgcolor);
        panel.setForeground(this.fgcolor);
        panel.setFont(this.font);
        SongListTable table = new SongListTable(this.songList);
        table.addAncestorListener(this);
        table.setAllColumnsVisible(false);
        table.setColumnVisible("Title", true);
        table.setColumnVisible("Album", true);
        table.setColumnVisible("Artist", true);
        table.setColumnVisible("Genre", true);
        table.setColumnVisible("Duration", true);
        table.setColumnVisible("down", true);
        table.setColumnVisible("up", true);
        table.setColumnVisible("delete", true);
        panel.add((Component)table, "Center");
        return panel;
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        logger.debug((Object)"Playlist ancestor added");
        this.cliConnected();
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
        logger.debug((Object)"Playlist ancestor removed");
        this.squeeze.getCLI().removeFilter(new CliMessage(Config.getProperty("macaddress"), "newsong"), this);
        this.squeeze.getCLI().removeFilter(new CliMessage(Config.getProperty("macaddress"), "playlist"), this);
        this.squeeze.getCLI().removeFilter(new CliMessage(Config.getProperty("macaddress"), "playlistcontrol"), this);
    }

    private void refresh() {
    }

    @Override
    public void cliMessage(CliMessage reply) {
        long now = System.currentTimeMillis();
        if (this.tstamp + 500L >= now) {
            return;
        }
        this.tstamp = now;
        this.songList.loadPlaylist(this.squeeze.getCLI(), Config.getProperty("macaddress"));
    }

    @Override
    public void cliConnected() {
        this.squeeze.getCLI().addFilter(new CliMessage(Config.getProperty("macaddress"), "newsong"), this);
        this.squeeze.getCLI().addFilter(new CliMessage(Config.getProperty("macaddress"), "playlist"), this);
        this.squeeze.getCLI().addFilter(new CliMessage(Config.getProperty("macaddress"), "playlistcontrol"), this);
        this.songList.loadPlaylist(this.squeeze.getCLI(), Config.getProperty("macaddress"));
    }

    @Override
    public void cliDisconnected() {
    }
}

