/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.titmuss.softsqueeze.music.SongList;
import org.titmuss.softsqueeze.music.SongListTable;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.w3c.dom.Element;

public class SearchPanel
extends SkinComponent {
    protected Color fgcolor;
    protected Color bgcolor;
    protected Font font;
    private SongList songList;

    public SearchPanel(Skin skin, Element e) {
        super(skin, e);
        this.fgcolor = this.parseColorAttribute(e, "fgcolor", null);
        this.bgcolor = this.parseColorAttribute(e, "bgcolor", null);
        this.font = this.parseFontAttribute(e, "font", "fontsize", null);
    }

    @Override
    public JComponent createComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(this.bgcolor);
        panel.setForeground(this.fgcolor);
        panel.setFont(this.font);
        JTextField searchField = new JTextField();
        searchField.setFont(this.font);
        SearchFieldListener listener = new SearchFieldListener();
        searchField.getDocument().addDocumentListener(listener);
        searchField.addActionListener(listener);
        this.songList = new SongList();
        SongListTable table = new SongListTable(this.songList);
        table.setAllColumnsVisible(false);
        table.setColumnVisible("Title", true);
        table.setColumnVisible("Album", true);
        table.setColumnVisible("Artist", true);
        table.setColumnVisible("Genre", true);
        table.setColumnVisible("Duration", true);
        table.setColumnVisible("play", true);
        table.setColumnVisible("add", true);
        panel.add((Component)searchField, "North");
        panel.add((Component)table, "Center");
        return panel;
    }

    private class SearchFieldListener
    implements ActionListener,
    DocumentListener {
        private SearchFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf = (JTextField)e.getSource();
            SearchPanel.this.songList.searchSongs(SearchPanel.this.squeeze.getCLI(), "search:" + tf.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                Document d = e.getDocument();
                this.dynamicSearch(d.getText(0, d.getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                Document d = e.getDocument();
                this.dynamicSearch(d.getText(0, d.getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            try {
                Document d = e.getDocument();
                this.dynamicSearch(d.getText(0, d.getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void dynamicSearch(String str) {
            if (str.length() == 0) {
                SearchPanel.this.songList.clear();
            } else if (str.length() > 2) {
                SearchPanel.this.songList.searchSongs(SearchPanel.this.squeeze.getCLI(), "search:" + str);
            }
        }
    }
}

