/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.skin.Action;
import org.titmuss.softsqueeze.skin.ButtonAction;
import org.titmuss.softsqueeze.skin.IRAction;
import org.titmuss.softsqueeze.skin.KnobAction;
import org.titmuss.softsqueeze.skin.LcdPanel;
import org.titmuss.softsqueeze.skin.Playlist;
import org.titmuss.softsqueeze.skin.SearchPanel;
import org.titmuss.softsqueeze.skin.SkinApplet;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.titmuss.softsqueeze.skin.SkinGroup;
import org.titmuss.softsqueeze.skin.SkinWindow;
import org.titmuss.softsqueeze.skin.SwitchAction;
import org.titmuss.softsqueeze.skin.WindowAction;
import org.titmuss.softsqueeze.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Skin {
    private static Logger logger = Logger.getLogger((String)"skin");
    private Softsqueeze squeeze;
    private String skinname;
    private String skindir;
    private HashMap components = new HashMap();
    private HashMap containers = new HashMap();
    private HashMap windows = new LinkedHashMap();
    private HashMap actionsRGB = new HashMap();
    private HashMap actionsKey = new HashMap();
    private Action knobAction;
    private String configPrefix;
    private Element config;
    private int deviceid;
    private TrayIcon trayIcon = null;

    public Skin(Softsqueeze squeeze) {
        this(squeeze, "excession");
    }

    public Skin(Softsqueeze squeeze, String skin) {
        this.squeeze = squeeze;
        this.skinname = skin;
        this.skindir = "/skin/" + this.skinname + "/";
        this.configPrefix = "skin." + this.skinname + ".";
        this.deviceid = Config.getIntegerProperty("deviceid");
        this.loadSkin(this.skinname + ".xml");
        for (SkinWindow window : this.windows.values()) {
            Container container = window.createContainer();
            if (container == null) continue;
            this.containers.put(window.getId(), container);
        }
        this.createSystemTray();
    }

    public URL getResource(String res) {
        if (res.startsWith("/")) {
            res = res.substring(1);
        }
        return this.getClass().getResource(this.skindir + res);
    }

    public Softsqueeze getSoftSqueeze() {
        return this.squeeze;
    }

    public String getSkinName() {
        return this.skinname;
    }

    public int getDeviceId() {
        return this.deviceid;
    }

    public void dispose() {
        for (Container window : this.containers.values()) {
            if (!(window instanceof Window)) continue;
            ((Window)window).dispose();
        }
        for (SkinComponent c : this.components.values()) {
            c.dispose();
        }
        if (this.trayIcon != null) {
            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(this.trayIcon);
        }
    }

    public Container getContainer(String id) {
        return (Window)this.containers.get(id);
    }

    public Iterator containerIterator() {
        return this.containers.entrySet().iterator();
    }

    public SkinWindow getSkinWindow(String id) {
        id = this.var(id);
        return (SkinWindow)this.windows.get(id);
    }

    public SkinComponent getSkinComponent(String id) {
        id = this.var(id);
        return (SkinComponent)this.components.get(id);
    }

    public SkinWindow getSkinWindow(Container window) {
        for (Map.Entry e : this.containers.entrySet()) {
            if (e.getValue() != window) continue;
            return this.getSkinWindow((String)e.getKey());
        }
        return null;
    }

    public boolean evalBoolean(String bool) {
        String[] str = Util.split(bool, "=");
        if (str.length > 1) {
            return this.var(str[0]).equals(str[1]);
        }
        return this.var(str[0]).equalsIgnoreCase("true");
    }

    private String var(String str) {
        if (str.startsWith("$")) {
            String var = str.substring(2, str.length() - 1);
            str = Config.getProperty(this.configPrefix + var);
        }
        return str;
    }

    public Action getActionRGB(int rgb) {
        return (Action)this.actionsRGB.get(new Integer(rgb));
    }

    public Action getActionKey(KeyStroke key) {
        return (Action)this.actionsKey.get(key);
    }

    public Action getKnobAction() {
        return this.knobAction;
    }

    public String getConfigPrefix() {
        return this.configPrefix;
    }

    public Element getSkinConfig() {
        return this.config;
    }

    private void loadSkin(String file) {
        try {
            logger.debug((Object)("Loading skin " + file));
            URL url = this.getClass().getResource(this.skindir + file);
            if (url == null) {
                logger.warn((Object)("Skin not found: " + this.skindir + file));
                return;
            }
            DocumentBuilderFactory xmlfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder xmlbuilder = xmlfactory.newDocumentBuilder();
            xmlbuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                    if (arg1.endsWith("skin.dtd")) {
                        return new InputSource(Skin.class.getResourceAsStream("/skin/skin.dtd"));
                    }
                    return null;
                }
            });
            Document doc = xmlbuilder.parse(url.toString());
            Element xmlskin = doc.getDocumentElement();
            this.loadSkin(xmlskin);
        }
        catch (IOException e) {
            logger.error((Object)"Cannot load skin.xml", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Cannot load skin.xml", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)"Cannot load skin.xml", (Throwable)e);
        }
    }

    private void loadSkin(Element xmlskin) {
        NodeList kids = xmlskin.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            SkinWindow c;
            Node n = kids.item(i);
            String node = n.getNodeName();
            if (node.equals("If")) {
                String test = ((Element)n).getAttribute("test");
                if (!this.evalBoolean(test)) continue;
                this.loadSkin((Element)n);
                continue;
            }
            if (node.equals("Include")) {
                String include = ((Element)n).getAttribute("file");
                this.loadSkin(include);
                continue;
            }
            if (node.equals("Config")) {
                this.loadConfig((Element)n);
                continue;
            }
            if (node.equals("Elements")) {
                this.loadElement((Element)n);
                continue;
            }
            if (node.equals("Window")) {
                c = new SkinWindow(this, (Element)n);
                this.windows.put(c.getId(), c);
                continue;
            }
            if (node.equals("Set")) {
                String name = ((Element)n).getAttribute("name");
                String value = ((Element)n).getAttribute("value");
                if (!name.equalsIgnoreCase("deviceid")) continue;
                this.deviceid = Integer.parseInt(value);
                continue;
            }
            if (node.equals("Applet") && this.squeeze.getApplet() != null) {
                c = new SkinApplet(this, (Element)n);
                this.windows.put(c.getId(), c);
                continue;
            }
            if (!node.equals("Action")) continue;
            String script = ((Element)n).getAttribute("script");
            Action action = script.startsWith("drag(") ? new WindowAction(this, (Element)n) : (script.startsWith("ir(") ? new IRAction(this, (Element)n) : (script.startsWith("switch(") ? new SwitchAction(this, (Element)n) : (script.startsWith("knob(") ? new KnobAction(this, (Element)n) : new ButtonAction(this, (Element)n))));
            this.actionsRGB.put(new Integer(action.getMaskRGB()), action);
            this.addActionKey(action);
            if (!action.isKnobAction()) continue;
            this.knobAction = action;
        }
    }

    private void loadConfig(Element config) {
        this.config = (Element)config.cloneNode(true);
        NodeList kids = config.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            String val;
            Node n = kids.item(i);
            String node = n.getNodeName();
            String id = null;
            String def = null;
            if (node.equals("Select")) {
                id = ((Element)n).getAttribute("id");
                NodeList kids2 = ((Element)n).getChildNodes();
                for (int j = 0; j < kids2.getLength(); ++j) {
                    Node option = kids2.item(j);
                    if (!option.getNodeName().equals("Option")) continue;
                    String val2 = ((Element)option).getAttribute("value");
                    String isDefault = ((Element)option).getAttribute("default");
                    if (j == 0) {
                        def = val2;
                    }
                    if (isDefault == null || !isDefault.equalsIgnoreCase("true")) continue;
                    def = val2;
                    break;
                }
            }
            if (id == null || def == null || (val = Config.getProperty(this.configPrefix + id)) != null) continue;
            Config.putProperty(this.configPrefix + id, def);
        }
    }

    private void loadElement(Element e1) {
        NodeList kids = e1.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node n = kids.item(j);
            if (n.getNodeType() != 1) continue;
            String node = n.getNodeName();
            SkinComponent comp = null;
            if (node.equals("VfPanel")) {
                comp = new LcdPanel(this, (Element)n);
            } else if (node.equals("SearchPanel")) {
                comp = new SearchPanel(this, (Element)n);
            } else if (node.equals("Playlist")) {
                comp = new Playlist(this, (Element)n);
            } else if (node.equals("GroupDef")) {
                comp = new SkinGroup(this, (Element)n);
            } else {
                logger.warn((Object)("Unknown component: " + node));
                continue;
            }
            String id = comp.getId();
            if (this.components.get(id) != null) {
                logger.warn((Object)("Component " + id + " is defined multiple times"));
            }
            this.components.put(id, comp);
        }
    }

    private void addActionKey(Action action) {
        String keystroke = action.getKeybinding();
        if (keystroke == null) {
            return;
        }
        String[] keys = Util.split(keystroke, ",");
        for (int i = 0; i < keys.length; ++i) {
            KeyStroke pkey = KeyStroke.getKeyStroke(keys[i]);
            if (pkey == null) {
                logger.warn((Object)("Cannot parse keybinding " + keystroke));
            }
            this.actionsKey.put(pkey, action);
        }
    }

    protected void addMenuItems(Menu menu) {
        MenuItem playItem = new MenuItem("Play");
        playItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Skin.this.squeeze.sendIR(1, 1, 1988694255);
            }
        });
        menu.add(playItem);
        MenuItem pauseItem = new MenuItem("Pause");
        pauseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Skin.this.squeeze.sendIR(1, 1, 1988698335);
            }
        });
        menu.add(pauseItem);
        MenuItem fwdItem = new MenuItem("Next");
        fwdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Skin.this.squeeze.sendIR(1, 1, 1988730975);
            }
        });
        menu.add(fwdItem);
        MenuItem rewItem = new MenuItem("Previous");
        rewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Skin.this.squeeze.sendIR(1, 1, 1988739135);
            }
        });
        menu.add(rewItem);
        menu.add(new MenuItem("-"));
        MenuItem hideItem = new MenuItem("Hide");
        hideItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SkinWindow w : Skin.this.windows.values()) {
                    if (!w.isVisible()) continue;
                    w.setIconified(true);
                }
            }
        });
        menu.add(hideItem);
        MenuItem exitItem = new MenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Skin.this.squeeze.exit();
            }
        });
        menu.add(exitItem);
    }

    public void createSystemTray() {
        if (Platform.JRE_1_6_PLUS && SystemTray.isSupported() && Config.getBooleanProperty("skin.systemtray")) {
            SystemTray tray = SystemTray.getSystemTray();
            PopupMenu popup = new PopupMenu();
            this.addMenuItems(popup);
            Image image = Toolkit.getDefaultToolkit().getImage(this.getResource("icon.png"));
            this.trayIcon = new TrayIcon(image, "SoftSqueeze", popup);
            this.trayIcon.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    for (SkinWindow w : Skin.this.windows.values()) {
                        if (!w.isIconified()) continue;
                        w.setIconified(false);
                    }
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                logger.error((Object)e);
            }
        }
    }
}

