/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.titmuss.softsqueeze.skin.Action;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.titmuss.softsqueeze.skin.SkinObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SkinGroup
extends SkinComponent {
    private Color bgColor;
    private ArrayList children = new ArrayList();
    private BufferedImage background;
    private BufferedImage backlight;
    private BufferedImage mask;
    private BufferedImage roll;
    private BufferedImage down;
    private GraphicsConfiguration gc;
    HashMap downCache = new HashMap();
    HashMap rollCache = new HashMap();

    public SkinGroup(Skin skin, Element e) {
        super(skin, e);
        this.bgColor = this.parseColorAttribute(e, "bgcolor", null);
        this.background = this.parseBufferedImageAttribute(e, "background", null);
        this.backlight = this.parseBufferedImageAttribute(e, "backlight", null);
        this.mask = this.parseBufferedImageAttribute(e, "mask", null);
        this.roll = this.parseBufferedImageAttribute(e, "roll", null);
        this.down = this.parseBufferedImageAttribute(e, "down", null);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        this.gc = gs.getDefaultConfiguration();
        NodeList parts = e.getElementsByTagName("*");
        for (int j = 0; j < parts.getLength(); ++j) {
            Element e2 = (Element)parts.item(j);
            this.children.add(e2);
        }
    }

    @Override
    public void dispose() {
        if (this.mask != null) {
            this.mask.flush();
            this.mask = null;
        }
        if (this.roll != null) {
            this.roll.flush();
            this.roll = null;
        }
        if (this.down != null) {
            this.down.flush();
            this.down = null;
        }
    }

    @Override
    public JComponent createComponent() {
        BackgroundPanel panel = new BackgroundPanel();
        panel.setLayout(new AbsoluteLayout());
        panel.setPreferredSize(new Dimension(this.width, this.height));
        if (this.bgColor != null) {
            panel.setBackground(this.bgColor);
        }
        if (this.background != null) {
            panel.setBackgroundImage(this.background);
        }
        if (this.mask != null) {
            ActionDispatcher dispatcher = new ActionDispatcher(panel);
            panel.addMouseMotionListener(dispatcher);
            panel.addMouseWheelListener(dispatcher);
            panel.addMouseListener(dispatcher);
        }
        for (Element e2 : this.children) {
            String id = e2.getAttribute("id");
            SkinComponent comp = this.skin.getSkinComponent(id);
            if (comp == null) {
                logger.error((Object)("Unknown component: " + id));
                continue;
            }
            comp.addToPanel(panel, e2);
        }
        return panel;
    }

    private class ActionDispatcher
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    ActionListener {
        private BackgroundPanel panel;
        private Action mouseOver = null;
        private Action mouseDrag = null;
        private Timer backlightTimer = null;

        ActionDispatcher(BackgroundPanel panel) {
            this.panel = panel;
        }

        private void updateImage(boolean isClicked) {
            if (this.mouseOver == null) {
                this.panel.setOverlayImage(null, null);
                return;
            }
            if (SkinGroup.this.backlight != null && isClicked) {
                SkinObject.logger.debug((Object)"backlight on");
                if (this.backlightTimer == null) {
                    this.backlightTimer = new Timer(10000, this);
                    this.panel.setBackgroundImage(SkinGroup.this.backlight);
                } else {
                    this.backlightTimer.restart();
                }
            }
            SkinObject.logger.debug((Object)"before overlay processing");
            if (isClicked && SkinGroup.this.down != null) {
                ImageTile tile = (ImageTile)SkinGroup.this.downCache.get(this.mouseOver);
                if (tile == null) {
                    tile = new ImageTile(this.mouseOver.getMaskRGB(), SkinGroup.this.down);
                    SkinGroup.this.downCache.put(this.mouseOver, tile);
                }
                this.panel.setOverlayImage(tile.img, tile.area);
            } else if (!isClicked && SkinGroup.this.roll != null) {
                ImageTile tile = (ImageTile)SkinGroup.this.rollCache.get(this.mouseOver);
                if (tile == null) {
                    tile = new ImageTile(this.mouseOver.getMaskRGB(), SkinGroup.this.roll);
                    SkinGroup.this.rollCache.put(this.mouseOver, tile);
                }
                this.panel.setOverlayImage(tile.img, tile.area);
            } else {
                this.panel.setOverlayImage(null, null);
                return;
            }
            SkinObject.logger.debug((Object)"after overlay processing");
        }

        private Action getAction(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (x < 0 || x >= SkinGroup.this.mask.getWidth() || y < 0 || y >= SkinGroup.this.mask.getHeight()) {
                return null;
            }
            int rgb = SkinGroup.this.mask.getRGB(x, y) & 0xFFFFFF;
            return SkinGroup.this.skin.getActionRGB(rgb);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mouseDrag != null) {
                this.mouseDrag.mouseDragged(e);
                return;
            }
            Action action = this.getAction(e);
            if (action != null) {
                action.mouseDragged(e);
            }
            this.mouseDrag = action;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Action action = this.getAction(e);
            if (this.mouseOver == action) {
                return;
            }
            if (this.mouseOver != null) {
                this.mouseOver.mouseExited(e);
            }
            if (action != null) {
                action.mouseEntered(e);
            }
            this.mouseOver = action;
            this.updateImage(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    Action action1 = this.getAction(e);
                    if (action1 == null) break;
                    action1.mouseClicked(e);
                    break;
                }
                case 2: 
                case 3: {
                    Action action2 = SkinGroup.this.skin.getKnobAction();
                    if (action2 == null) break;
                    action2.mouseClicked(e);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    Action action = this.getAction(e);
                    if (action == null) break;
                    action.mousePressed(e);
                    this.updateImage(true);
                    break;
                }
                case 2: 
                case 3: {
                    Action action2 = SkinGroup.this.skin.getKnobAction();
                    if (action2 == null) break;
                    action2.mousePressed(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDrag = null;
            switch (e.getButton()) {
                case 1: {
                    Action action = this.getAction(e);
                    if (action != null) {
                        action.mouseReleased(e);
                        this.updateImage(false);
                    }
                }
                case 2: 
                case 3: {
                    Action action2 = SkinGroup.this.skin.getKnobAction();
                    if (action2 == null) break;
                    action2.mouseReleased(e);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Action action = this.getAction(e);
            if (action != null) {
                action.mouseEntered(e);
            }
            this.mouseOver = action;
            this.updateImage(false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.mouseOver != null) {
                this.mouseOver.mouseExited(e);
            }
            this.mouseOver = null;
            this.updateImage(false);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Action action2 = SkinGroup.this.skin.getKnobAction();
            if (action2 != null) {
                action2.mouseWheelMoved(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (SkinGroup.this.backlight != null) {
                SkinObject.logger.debug((Object)"backlight off");
                this.backlightTimer.stop();
                this.backlightTimer = null;
                this.panel.setBackgroundImage(SkinGroup.this.background);
            }
        }
    }

    private class ImageTile {
        Image img;
        Rectangle area;

        private ImageTile(int rgb, BufferedImage source) {
            rgb = 0xFF000000 | rgb;
            int minx = SkinGroup.this.background.getWidth(null);
            int miny = SkinGroup.this.background.getHeight(null);
            int maxx = 0;
            int maxy = 0;
            BufferedImage target = SkinGroup.this.gc.createCompatibleImage(minx, miny, 2);
            for (int x = 0; x < SkinGroup.this.background.getWidth(); ++x) {
                for (int y = 0; y < SkinGroup.this.background.getHeight(); ++y) {
                    if (SkinGroup.this.mask.getRGB(x, y) != rgb) {
                        target.setRGB(x, y, SkinGroup.this.background.getRGB(x, y));
                        continue;
                    }
                    target.setRGB(x, y, source.getRGB(x, y));
                    if (x < minx) {
                        minx = x;
                    } else if (x > maxx) {
                        maxx = x;
                    }
                    if (y < miny) {
                        miny = y;
                        continue;
                    }
                    if (y <= maxy) continue;
                    maxy = y;
                }
            }
            this.area = new Rectangle(minx, miny, maxx - minx, maxy - miny);
            SkinObject.logger.debug((Object)("rgb " + rgb + " source " + source + " area " + this.area));
            this.img = SkinGroup.this.gc.createCompatibleImage(this.area.width, this.area.height, 2);
            Graphics g = this.img.getGraphics();
            g.drawImage(target, 0, 0, this.area.width, this.area.height, this.area.x, this.area.y, this.area.x + this.area.width, this.area.y + this.area.height, null);
        }
    }

    private class AbsoluteLayout
    implements LayoutManager {
        private AbsoluteLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Component[] clist = parent.getComponents();
            for (int i = 0; i < clist.length; ++i) {
                Component c = clist[i];
                Point pt = c.getLocation();
                Dimension size = c.getPreferredSize();
                c.setBounds(pt.x + insets.left, pt.y + insets.top, size.width, size.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            if (parent instanceof JComponent && ((JComponent)parent).isPreferredSizeSet()) {
                Dimension size = parent.getPreferredSize();
                SkinObject.logger.debug((Object)("using preferred size " + size));
                Insets insets = parent.getInsets();
                return new Dimension(insets.left + (int)size.getWidth() + insets.right, insets.top + (int)size.getHeight() + insets.bottom);
            }
            int x = 0;
            int y = 0;
            Component[] clist = parent.getComponents();
            for (int i = 0; i < clist.length; ++i) {
                Component c = clist[i];
                Rectangle bounds = c.getBounds();
                x = Math.max(x, (int)bounds.getMaxX());
                y = Math.max(y, (int)bounds.getMaxY());
            }
            Insets insets = parent.getInsets();
            return new Dimension(insets.left + x + insets.right, insets.top + y + insets.bottom);
        }
    }

    private class BackgroundPanel
    extends JComponent {
        private static final long serialVersionUID = 272225765159584276L;
        private Image image;
        private Image overlay;
        private Rectangle clip;

        public BackgroundPanel() {
            this.setOpaque(true);
            this.setFocusable(false);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public void setBackground(Color background) {
            super.setBackground(background);
            this.setOpaque(true);
        }

        public void setBackgroundImage(Image image) {
            this.image = image;
            this.repaint();
        }

        public void setOverlayImage(Image newOverlay, Rectangle newClip) {
            if (newOverlay != null || this.overlay != null) {
                if (newOverlay == null) {
                    this.overlay = null;
                    this.repaint(this.clip);
                    this.clip = null;
                } else if (this.overlay == null) {
                    this.overlay = newOverlay;
                    this.repaint(newClip);
                    this.clip = newClip;
                } else {
                    this.overlay = newOverlay;
                    Rectangle union = new Rectangle(this.clip);
                    union = union.union(newClip);
                    this.repaint(union);
                    this.clip = newClip;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            SkinObject.logger.debug((Object)("gx clip " + g.getClip() + " ov clip " + this.clip));
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
            if (this.overlay != null) {
                g.drawImage(this.overlay, this.clip.x, this.clip.y, this.clip.x + this.clip.width, this.clip.y + this.clip.height, 0, 0, this.clip.width, this.clip.height, null);
            }
        }
    }
}

