/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.util.Util;
import org.w3c.dom.Element;

public abstract class SkinObject {
    protected static Logger logger = Logger.getLogger((String)"skin");
    protected Softsqueeze squeeze;
    protected Skin skin;
    protected String id;
    protected String name;
    protected int width;
    protected int height;

    public SkinObject(Skin skin, Element e) {
        this.squeeze = skin.getSoftSqueeze();
        this.skin = skin;
        this.id = e.getAttribute("id");
        this.name = e.getAttribute("name");
        this.width = this.parseIntAttribute(e, "width", -1);
        this.height = this.parseIntAttribute(e, "height", -1);
    }

    public String getId() {
        return this.id;
    }

    protected int parseIntAttribute(Element e, String name, int def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        return Integer.parseInt(val);
    }

    protected int parseHexAttribute(Element e, String name, int def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        if (val.startsWith("0x")) {
            return Integer.parseInt(val.substring(2), 16);
        }
        return Integer.parseInt(val.substring(2));
    }

    protected String parseStringAttribute(Element e, String name, String def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        return val;
    }

    protected boolean parseBooleanAttribute(Element e, String name, boolean def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        return val.equalsIgnoreCase("true");
    }

    protected ImageIcon parseImageAttribute(Element e, String name, ImageIcon def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        logger.debug((Object)("loading image: " + val));
        URL url = this.skin.getResource(val);
        if (url == null) {
            logger.warn((Object)("No image: " + val));
            return null;
        }
        return new ImageIcon(url);
    }

    protected BufferedImage parseBufferedImageAttribute(Element e, String name, BufferedImage def) {
        try {
            String val = e.getAttribute(name);
            if (val.equals("")) {
                return def;
            }
            logger.debug((Object)("loading image: " + val));
            URL url = this.skin.getResource(val);
            if (url == null) {
                logger.warn((Object)("No image: " + val));
                return null;
            }
            return ImageIO.read(url);
        }
        catch (IOException e1) {
            logger.warn((Object)("Exception loading image " + name), (Throwable)e1);
            return null;
        }
    }

    protected Color parseColorAttribute(Element e, String name, Color def) {
        String val = e.getAttribute(name);
        if (val.equals("")) {
            return def;
        }
        return Color.decode(val);
    }

    protected Font parseFontAttribute(Element e, String fontName, String sizeName, Font def) {
        String val = e.getAttribute(this.name);
        if (val.equals("")) {
            return def;
        }
        int size = this.parseIntAttribute(e, sizeName, 10);
        String[] fonts = Util.split(val, ",");
        for (int i = 0; i < fonts.length; ++i) {
            Font font = new Font(fonts[i], 0, size);
            if (font == null) continue;
            return font;
        }
        return def;
    }
}

