/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import com.l2fprod.gui.nativeskin.NativeSkin;
import com.l2fprod.gui.region.ImageRegion;
import com.l2fprod.gui.region.Region;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.MemoryImageSource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.titmuss.softsqueeze.config.Config;
import org.titmuss.softsqueeze.config.ConfigListener;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.skin.Action;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinComponent;
import org.titmuss.softsqueeze.skin.SkinObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SkinWindow
extends SkinObject
implements ConfigListener {
    private ImageIcon icon;
    private String owner;
    private String configid;
    private boolean visible;
    private boolean iconfied;
    private boolean fullscreen;
    private int x;
    private int y;
    private int sx;
    private int sy;
    private String child = null;
    private boolean fullscreenDisplayMode = false;
    private DisplayMode oldDisplayMode;
    private Image windowmask = null;
    private static HashSet hiddenWindows = new HashSet();
    private static Container fullscreenWindow = null;
    private static Cursor transparentCursor = null;

    public SkinWindow(Skin skin, Element e) {
        super(skin, e);
        Config.addConfigListener(this);
        this.icon = this.parseImageAttribute(e, "icon", null);
        this.owner = this.parseStringAttribute(e, "owner", null);
        this.visible = this.parseBooleanAttribute(e, "visible", true);
        this.fullscreen = this.parseBooleanAttribute(e, "fullscreen", false);
        this.windowmask = this.parseBufferedImageAttribute(e, "windowmask", null);
        this.configid = this.parseStringAttribute(e, "configid", this.id);
        if (!this.configid.startsWith(skin.getSkinName())) {
            this.configid = skin.getSkinName() + "." + this.configid;
        }
        this.sx = this.x = this.parseIntAttribute(e, "x", 100);
        this.sy = this.y = this.parseIntAttribute(e, "y", 100);
        NodeList kids = e.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node n = kids.item(i);
            if (n.getNodeType() != 1) continue;
            this.child = this.parseStringAttribute((Element)n, "id", this.child);
        }
        int pX = Config.getIntegerProperty(this.configid + ".x");
        int pY = Config.getIntegerProperty(this.configid + ".y");
        if (pX != -1 && pY != -1) {
            logger.debug((Object)("Window location from config: " + this.id + " @ " + pX + "," + pY));
            this.x = pX;
            this.y = pY;
        }
    }

    public Container createContainer() {
        SkinComponent comp;
        Container contentPane;
        Window window;
        if (this.owner == null) {
            logger.debug((Object)("Creating JFrame for window=" + this.id));
            JFrame frame = new JFrame(this.name);
            frame.setDefaultCloseOperation(3);
            if (Platform.JRE_1_4_PLUS) {
                frame.setUndecorated(true);
            }
            if (this.icon != null) {
                frame.setIconImage(this.icon.getImage());
            }
            window = frame;
            contentPane = frame.getContentPane();
        } else {
            logger.debug((Object)("Creating JDialog for window=" + this.id + " owner=" + this.owner));
            JFrame ownerFrame = (JFrame)this.skin.getContainer(this.owner);
            JDialog dialog = new JDialog(ownerFrame, this.name, false);
            dialog.setDefaultCloseOperation(1);
            if (Platform.JRE_1_4_PLUS) {
                dialog.setUndecorated(true);
            }
            window = dialog;
            contentPane = dialog.getContentPane();
        }
        window.setLocation(this.x, this.y);
        if (Platform.JRE_1_4_PLUS) {
            window.setFocusable(true);
            window.setFocusTraversalKeysEnabled(false);
        }
        if (Platform.JRE_1_5_PLUS) {
            window.setAlwaysOnTop(Config.getBooleanProperty("skin.alwaysontop"));
        }
        window.addKeyListener(new WindowKeyListener());
        if (Config.getBooleanProperty("skin.touchscreen")) {
            window.setCursor(this.getTransparentCursor());
        }
        if ((comp = this.skin.getSkinComponent(this.child)) == null) {
            logger.warn((Object)("Cannot find Element: " + this.child));
        } else {
            contentPane.add(comp.createComponent());
        }
        window.pack();
        String pVisible = Config.getProperty(this.configid + ".v");
        if (pVisible != null) {
            logger.debug((Object)("Got window visible pref for " + this.id + "=" + this.visible));
            this.visible = pVisible.equalsIgnoreCase("true");
        }
        this.setVisible(this.visible, window);
        if (this.windowmask != null && NativeSkin.isSupported()) {
            try {
                ImageRegion region = new ImageRegion(this.windowmask);
                NativeSkin.getInstance().setWindowRegion(window, (Region)region, true);
                this.windowmask = null;
            }
            catch (Throwable e) {
                logger.error((Object)("Cannot create window mask" + e));
            }
        }
        return window;
    }

    @Override
    public void configSet(String key, String value) {
        Window window;
        if (key.equals("alwaysontop") && (window = (Window)this.skin.getContainer(this.id)) != null) {
            window.setAlwaysOnTop(Config.getBooleanProperty("skin.alwaysontop"));
        }
        if (key.equals("skin.touchscreen")) {
            window = (Window)this.skin.getContainer(this.id);
            if (Config.getBooleanProperty("skin.touchscreen")) {
                window.setCursor(this.getTransparentCursor());
            } else {
                window.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void setVisible(boolean visible) {
        Container window = this.skin.getContainer(this.id);
        this.setVisible(visible, window);
    }

    private void setVisible(boolean visible, Container window) {
        if (fullscreenWindow != null && fullscreenWindow != window) {
            if (visible) {
                hiddenWindows.add(window);
            } else {
                hiddenWindows.remove(window);
            }
            return;
        }
        window.setVisible(visible);
        if (visible && this.isOffScreen(window)) {
            window.setLocation(this.sx, this.sy);
        }
        if (this.fullscreen && window instanceof Window) {
            this.fullscreen(visible, (Window)window);
        }
        Config.putProperty(this.configid + ".v", visible ? "true" : "false");
    }

    public boolean isVisible() {
        Container window = this.skin.getContainer(this.id);
        return window.isVisible();
    }

    public void setIconified(boolean iconified) {
        Container window = this.skin.getContainer(this.id);
        this.setIconified(iconified, window);
    }

    public void setIconified(boolean iconified, Container window) {
        if (Platform.JRE_1_6_PLUS && SystemTray.isSupported() && Config.getBooleanProperty("skin.systemtray") && this.visible) {
            window.setVisible(!iconified);
        }
        if (window instanceof Frame) {
            ((Frame)window).setExtendedState(iconified ? 1 : 0);
        }
        this.iconfied = iconified;
    }

    public boolean isIconified() {
        return this.iconfied;
    }

    public static boolean isFullscreen(Container window) {
        return fullscreenWindow == window;
    }

    public void setPosition(int x, int y) {
        Config.putIntegerProperty(this.configid + ".x", x);
        Config.putIntegerProperty(this.configid + ".y", y);
    }

    private void fullscreen(boolean zoom, Window window) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getScreenDevices()[0];
        if (!zoom) {
            logger.debug((Object)"leaving fullscreen");
            if (this.fullscreenDisplayMode) {
                if (this.oldDisplayMode != null) {
                    device.setDisplayMode(this.oldDisplayMode);
                }
                device.setFullScreenWindow(null);
                this.fullscreenDisplayMode = false;
                this.oldDisplayMode = null;
            }
            for (Container c : hiddenWindows) {
                c.setVisible(true);
            }
            hiddenWindows.clear();
            fullscreenWindow = null;
            return;
        }
        logger.debug((Object)"going fullscreen");
        this.oldDisplayMode = device.getDisplayMode();
        DisplayMode[] modes = device.getDisplayModes();
        DisplayMode mode = null;
        int bitdepth = 0;
        int refreshRate = 0;
        for (int j = 0; j < modes.length; ++j) {
            logger.debug((Object)("display mode: w=" + modes[j].getWidth() + " h=" + modes[j].getHeight() + " bitdepth=" + modes[j].getBitDepth() + " refreshRate=" + modes[j].getRefreshRate()));
            if (modes[j].getWidth() != this.width || modes[j].getHeight() != this.height || modes[j].getBitDepth() < bitdepth || modes[j].getBitDepth() > this.oldDisplayMode.getBitDepth() || modes[j].getRefreshRate() < refreshRate || modes[j].getRefreshRate() > this.oldDisplayMode.getRefreshRate()) continue;
            mode = modes[j];
            bitdepth = modes[j].getBitDepth();
            refreshRate = modes[j].getRefreshRate();
        }
        fullscreenWindow = window;
        Iterator i = this.skin.containerIterator();
        while (i.hasNext()) {
            Container c = (Container)((Map.Entry)i.next()).getValue();
            if (!c.isVisible() || c == window) continue;
            hiddenWindows.add(c);
            c.setVisible(false);
        }
        if (mode != null) {
            this.fullscreenDisplayMode = true;
            device.setFullScreenWindow(window);
            device.setDisplayMode(mode);
        } else {
            logger.debug((Object)"no suitable display mode found");
            this.fullscreenDisplayMode = false;
            window.setBounds(0, 0, this.oldDisplayMode.getWidth(), this.oldDisplayMode.getHeight());
            window.setBackground(Color.BLACK);
        }
    }

    private boolean isOffScreen(Container window) {
        int top = window.getY();
        int left = window.getX();
        int bottom = top + window.getHeight();
        int right = left + window.getWidth();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            Rectangle bounds = gs[i].getDefaultConfiguration().getBounds();
            if (!((double)bottom >= bounds.getY()) || !((double)top <= bounds.getY() + bounds.getHeight()) || !((double)right >= bounds.getX()) || !((double)left <= bounds.getX() + bounds.getWidth())) continue;
            return false;
        }
        return true;
    }

    private Cursor getTransparentCursor() {
        if (transparentCursor != null) {
            return transparentCursor;
        }
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisiblecursor");
        return transparentCursor;
    }

    protected class WindowKeyListener
    implements KeyListener {
        protected WindowKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            Action a = SkinWindow.this.skin.getActionKey(key);
            if (a != null) {
                a.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            Action a = SkinWindow.this.skin.getActionKey(key);
            if (a != null) {
                a.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            Action a = SkinWindow.this.skin.getActionKey(key);
            if (a != null) {
                a.keyReleased(e);
            }
        }
    }
}

