/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.skin;

import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.titmuss.softsqueeze.platform.Platform;
import org.titmuss.softsqueeze.skin.Action;
import org.titmuss.softsqueeze.skin.Skin;
import org.titmuss.softsqueeze.skin.SkinWindow;
import org.w3c.dom.Element;

class WindowAction
extends Action {
    private Point orig = null;
    private boolean dragGroup = false;
    private HashMap windowpos = null;
    private int dx;
    private int dy;
    private final int SNAP = 15;

    protected WindowAction(Skin skin, Element e) {
        super(skin, e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Container window = this.getWindowForEvent(e);
        window.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Container window = this.getWindowForEvent(e);
        if (Platform.JRE_1_5_PLUS) {
            this.orig = MouseInfo.getPointerInfo().getLocation();
        } else {
            this.orig = e.getPoint();
            this.dy = 0;
            this.dx = 0;
        }
        this.dragGroup = !e.isControlDown() && !e.isMetaDown();
        this.windowpos = new HashMap();
        Iterator i = this.skin.containerIterator();
        while (i.hasNext()) {
            Map.Entry map = (Map.Entry)i.next();
            Window frame = (Window)map.getValue();
            if (!this.dragGroup && frame != window) continue;
            this.windowpos.put(frame, frame.getLocation());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.orig = null;
        Container window = this.getWindowForEvent(e);
        Iterator i = this.skin.containerIterator();
        while (i.hasNext()) {
            Map.Entry map = (Map.Entry)i.next();
            String id = (String)map.getKey();
            Window frame = (Window)map.getValue();
            if (!this.dragGroup && frame != window) continue;
            this.skin.getSkinWindow(id).setPosition(frame.getX(), frame.getY());
        }
        this.windowpos = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Window frame;
        Map.Entry map;
        Point p;
        if (this.orig == null) {
            return;
        }
        Container window = this.getWindowForEvent(e);
        if (SkinWindow.isFullscreen(window)) {
            return;
        }
        if (Platform.JRE_1_5_PLUS) {
            p = MouseInfo.getPointerInfo().getLocation();
            this.dx = (int)(p.getX() - this.orig.getX());
            this.dy = (int)(p.getY() - this.orig.getY());
        } else {
            p = e.getPoint();
            this.dx += (int)(p.getX() - this.orig.getX());
            this.dy += (int)(p.getY() - this.orig.getY());
        }
        Iterator i = this.skin.containerIterator();
        while (i.hasNext()) {
            map = (Map.Entry)i.next();
            frame = (Window)map.getValue();
            if (!this.dragGroup && frame != window) continue;
            Point fp = (Point)this.windowpos.get(frame);
            Point xy = new Point(fp);
            xy.translate(this.dx, this.dy);
            this.snapScreen(xy, frame);
            this.dx = (int)(xy.getX() - fp.getX());
            this.dy = (int)(xy.getY() - fp.getY());
        }
        i = this.skin.containerIterator();
        while (i.hasNext()) {
            map = (Map.Entry)i.next();
            frame = (Window)map.getValue();
            if (!this.dragGroup && frame != window) continue;
            Point xy = new Point((Point)this.windowpos.get(frame));
            xy.translate(this.dx, this.dy);
            if (!this.dragGroup) {
                this.snapWindow(xy, window);
            }
            frame.setLocation(xy);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void snapWindow(Point xy, Container frame) {
        int top = (int)xy.getY();
        int left = (int)xy.getX();
        int bottom = top + frame.getHeight();
        int right = left + frame.getWidth();
        Iterator i = this.skin.containerIterator();
        while (i.hasNext()) {
            Map.Entry map = (Map.Entry)i.next();
            Window f = (Window)map.getValue();
            if (f == frame || !f.isShowing()) continue;
            Point fxy = f.getLocation();
            fxy.translate(0, f.getHeight());
            if (Math.abs((double)top - fxy.getY()) < 15.0) {
                xy.setLocation(xy.getX(), fxy.getY());
            }
            if (Math.abs((double)top - (fxy = f.getLocation()).getY()) < 15.0) {
                xy.setLocation(xy.getX(), fxy.getY());
            }
            if (Math.abs((double)bottom - (fxy = f.getLocation()).getY()) < 15.0) {
                xy.setLocation(xy.getX(), fxy.getY() - (double)frame.getHeight());
            }
            fxy = f.getLocation();
            fxy.translate(0, f.getHeight());
            if (Math.abs((double)bottom - fxy.getY()) < 15.0) {
                xy.setLocation(xy.getX(), fxy.getY() - (double)frame.getHeight());
            }
            fxy = f.getLocation();
            fxy.translate(f.getWidth(), 0);
            if (Math.abs((double)left - fxy.getX()) < 15.0) {
                xy.setLocation(fxy.getX(), xy.getY());
            }
            if (Math.abs((double)left - (fxy = f.getLocation()).getX()) < 15.0) {
                xy.setLocation(fxy.getX(), xy.getY());
            }
            fxy = f.getLocation();
            fxy.translate(0, 0);
            if (Math.abs((double)right - fxy.getX()) < 15.0) {
                xy.setLocation(fxy.getX() - (double)frame.getWidth(), xy.getY());
            }
            fxy = f.getLocation();
            fxy.translate(f.getWidth(), 0);
            if (Math.abs((double)right - fxy.getX()) < 15.0) {
                xy.setLocation(fxy.getX() - (double)frame.getWidth(), xy.getY());
            }
            int hmid = left + frame.getWidth() / 2;
            fxy = f.getLocation();
            fxy.translate(f.getWidth() / 2, 0);
            if (Math.abs((double)hmid - fxy.getX()) < 15.0) {
                xy.setLocation(fxy.getX() - (double)(frame.getWidth() / 2), xy.getY());
            }
            int vmid = top + frame.getHeight() / 2;
            fxy = f.getLocation();
            fxy.translate(0, f.getHeight() / 2);
            if (!(Math.abs((double)vmid - fxy.getY()) < 15.0)) continue;
            xy.setLocation(xy.getX(), fxy.getY() - (double)(frame.getHeight() / 2));
        }
    }

    private void snapScreen(Point xy, Window frame) {
        int top = (int)xy.getY();
        int left = (int)xy.getX();
        int bottom = top + frame.getHeight();
        int right = left + frame.getWidth();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            Rectangle bounds = gs[i].getDefaultConfiguration().getBounds();
            logger.debug((Object)("screen " + i + ": " + bounds));
            if (Math.abs((double)top - bounds.getY()) < 15.0) {
                xy.setLocation(xy.getX(), bounds.getY());
            }
            if (Math.abs((double)bottom - bounds.getY() - bounds.getHeight()) < 15.0) {
                xy.setLocation(xy.getX(), bounds.getY() + bounds.getHeight() - (double)frame.getHeight());
            }
            if (Math.abs((double)left - bounds.getX()) < 15.0) {
                xy.setLocation(bounds.getX(), xy.getY());
            }
            if (!(Math.abs((double)right - (bounds.getX() + bounds.getWidth())) < 15.0)) continue;
            xy.setLocation(bounds.getX() + bounds.getWidth() - (double)frame.getWidth(), xy.getY());
        }
    }
}

