/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.util;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static String[] split(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        int n = tok.countTokens();
        String[] split = new String[n];
        int i = 0;
        while (tok.hasMoreTokens()) {
            split[i] = tok.nextToken().trim();
            ++i;
        }
        return split;
    }

    public static List xmlSelectNodes(Node node, String xpathExpression) {
        LinkedList list = new LinkedList();
        String[] path = Util.split(xpathExpression, "/");
        Util.xmlSelectNodes0(list, node, path, 0);
        return list;
    }

    private static void xmlSelectNodes0(List list, Node node, String[] path, int n) {
        if (n == path.length) {
            list.add(node);
            return;
        }
        if (path[n].equals("..")) {
            Util.xmlSelectNodes0(list, node.getParentNode(), path, n + 1);
            return;
        }
        NodeList kids = node.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node kid = kids.item(i);
            if (!kid.getNodeName().equals(path[n])) continue;
            Util.xmlSelectNodes0(list, kid, path, n + 1);
        }
    }

    public static Node xmlSelectSingleNode(Node node, String xpathExpression) {
        List list = Util.xmlSelectNodes(node, xpathExpression);
        if (list.isEmpty()) {
            return null;
        }
        return (Node)list.get(0);
    }

    public static String xmlGetText(Node node) {
        NodeList kids = node.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node kid = kids.item(i);
            if (kid.getNodeName().equals("#text")) {
                return kid.getNodeValue();
            }
            if (!kid.getNodeName().equals("#cdata-section")) continue;
            return kid.getNodeValue();
        }
        return null;
    }

    public static String xmlValueOf(Node node, String xpathExpression) {
        List nodes = Util.xmlSelectNodes(node, xpathExpression);
        StringBuffer buf = new StringBuffer();
        for (Node n : nodes) {
            String str = Util.xmlGetText(n);
            if (str == null) continue;
            buf.append(str);
        }
        return buf.toString();
    }
}

