/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.visualizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.sound.sampled.AudioFormat;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.display.LcdDisplay;
import org.titmuss.softsqueeze.net.Protocol;

public abstract class Visualizer
implements Runnable {
    protected static final Logger logger = Logger.getLogger((String)"visualizer");
    protected int[] visParam;
    private byte[] buf = new byte[0];
    protected long bufEpoch;
    protected int bufLen;
    protected int[] channelPosition = new int[2];
    protected boolean[] channelFlipped = new boolean[2];
    protected int[] barWidth = new int[2];
    protected int[] barSpacing = new int[2];
    protected int[][] barVal = new int[2][];
    protected int[][] barLvl = new int[2][];
    protected int[] barIntensity = new int[2];
    protected int[] capIntensity = new int[2];
    protected int channels = 2;
    protected int sampleSize = 2;
    protected float frameRate = 44100.0f;
    protected boolean isBigEndian = false;
    protected boolean isMono = false;
    protected int displayRate = 30;
    private Softsqueeze squeeze;
    private LcdDisplay display;
    protected boolean running = true;

    public Visualizer(Softsqueeze squeeze, byte[] buf, int off, int len) {
        this.squeeze = squeeze;
        this.display = squeeze.getLcdDisplay();
        this.displayRate = 30;
        int n = ++off;
        ++off;
        int visLen = buf[n] & 0xFF;
        this.visParam = new int[visLen];
        for (int i = 0; i < visLen && off < len; off += 4, ++i) {
            this.visParam[i] = Protocol.unpackN4(buf, off);
        }
    }

    public synchronized void init() {
        Thread t = new Thread((Runnable)this, "Visualizer");
        t.setDaemon(true);
        this.running = true;
        t.start();
    }

    public synchronized void play() {
    }

    public synchronized void pause() {
        this.flush();
    }

    public synchronized void flush() {
        int i;
        this.bufEpoch = 0L;
        for (i = 0; i < this.barVal[0].length; ++i) {
            this.barVal[0][i] = 0;
        }
        if (!this.isMono) {
            for (i = 0; i < this.barVal[1].length; ++i) {
                this.barVal[1][i] = 0;
            }
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.notifyAll();
        if (this.display != null) {
            this.display.updateVisualizer(this);
        }
    }

    public void setAudioFormat(AudioFormat format) {
        this.frameRate = format.getFrameRate();
        this.sampleSize = format.getSampleSizeInBits() / 8;
        this.channels = format.getChannels();
        this.isBigEndian = format.isBigEndian();
    }

    public synchronized void write(byte[] b, int offset, int len) {
        if (this.buf.length < len) {
            this.buf = new byte[len];
        }
        System.arraycopy(b, offset, this.buf, 0, len);
        this.bufLen = len;
        this.bufEpoch = System.currentTimeMillis();
        this.notifyAll();
        logger.debug((Object)"write sample");
    }

    protected int getSample(int offset) {
        if (this.isBigEndian) {
            return this.buf[offset] << 8 | this.buf[offset + 1] & 0xFF;
        }
        return this.buf[offset] & 0xFF | this.buf[offset + 1] << 8;
    }

    @Override
    public synchronized void run() {
        while (this.running) {
            while (this.running && this.bufLen == 0) {
                logger.debug((Object)"paused");
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.debug((Object)"unpaused");
            }
            while (this.running && this.bufLen > 0) {
                long now = System.currentTimeMillis();
                long offsetTime = now - this.bufEpoch;
                int offset = (int)((float)offsetTime / 1000.0f * this.frameRate) * this.channels * this.sampleSize;
                logger.debug((Object)("offsetTime=" + offsetTime + " offset=" + offset + " len=" + this.bufLen));
                if (offset >= 0 && offset < this.bufLen) {
                    this.visualize(this.buf, offset, this.bufLen);
                }
                if (this.display != null) {
                    this.display.updateVisualizer(this);
                }
                try {
                    this.wait((long)(2000.0 / (double)this.displayRate));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract void visualize(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, Color[] col) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(1, 1.0f));
        g2.fillRect(0, 0, 640, 32);
        g2.setComposite(AlphaComposite.Src);
        if (!this.running) {
            return;
        }
        boolean allZero = true;
        for (int ch = 0; ch < (this.isMono ? 1 : 2); ++ch) {
            int i;
            int pos;
            if (!this.channelFlipped[ch]) {
                pos = this.channelPosition[ch];
                g2.setColor(col[this.barIntensity[ch]]);
                for (i = 0; i < this.barVal[ch].length; ++i) {
                    g2.fillRect(pos, 30 - this.barVal[ch][i], this.barWidth[ch], this.barVal[ch][i] + 1);
                    pos += this.barWidth[ch] + this.barSpacing[ch];
                }
                pos = this.channelPosition[ch];
                g2.setColor(col[this.capIntensity[ch]]);
                for (i = 0; i < this.barVal[ch].length; ++i) {
                    if (this.barLvl[ch][i] > 0) {
                        int[] nArray = this.barLvl[ch];
                        int n = i;
                        nArray[n] = nArray[n] - 1;
                    }
                    if (this.barLvl[ch][i] < this.barVal[ch][i]) {
                        this.barLvl[ch][i] = this.barVal[ch][i];
                    }
                    if (this.barLvl[ch][i] != 0) {
                        allZero = false;
                    }
                    g2.fillRect(pos, 30 - this.barLvl[ch][i], this.barWidth[ch], 1);
                    pos += this.barWidth[ch] + this.barSpacing[ch];
                }
                continue;
            }
            pos = this.channelPosition[ch];
            g2.setColor(col[this.barIntensity[ch]]);
            for (i = this.barVal[ch].length - 1; i >= 0; --i) {
                g2.fillRect(pos, 30 - this.barVal[ch][i], this.barWidth[ch], this.barVal[ch][i] + 1);
                pos += this.barWidth[ch] + this.barSpacing[ch];
            }
            pos = this.channelPosition[ch];
            g2.setColor(col[this.capIntensity[ch]]);
            for (i = this.barVal[ch].length - 1; i >= 0; --i) {
                if (this.barLvl[ch][i] > 0) {
                    int[] nArray = this.barLvl[ch];
                    int n = i;
                    nArray[n] = nArray[n] - 1;
                }
                if (this.barLvl[ch][i] < this.barVal[ch][i]) {
                    this.barLvl[ch][i] = this.barVal[ch][i];
                }
                if (this.barLvl[ch][i] != 0) {
                    allZero = false;
                }
                g2.fillRect(pos, 30 - this.barLvl[ch][i], this.barWidth[ch], 1);
                pos += this.barWidth[ch] + this.barSpacing[ch];
            }
        }
        if (allZero) {
            Visualizer visualizer = this;
            synchronized (visualizer) {
                this.bufLen = 0;
            }
        }
    }
}

