/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.visualizer;

import jnt.FFT.ComplexFloatFFT_Radix2;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.visualizer.Visualizer;

public class VisualizerSpectrumAnalyser
extends Visualizer {
    private static final int[] POWER_MAP = new int[]{0, 362, 2048, 5643, 11585, 20238, 31925, 46935, 65536, 87975, 114486, 145290, 180595, 220603, 265506, 315488, 370727, 431397, 497664, 569690, 647634, 731649, 821886, 918490, 1021605, 1131370, 1247924, 1371400, 1501931, 1639645, 1784670, 1937131};
    private static final double TWOPI = Math.PI * 2;
    private static final int CHUNK_SIZE = 512;
    private static final int COLUMNS_PER_FRAME = 640;
    private static final int MIN_FFT_INPUT_SAMPLES = 128;
    private static final int MIN_SUBBANDS = 32;
    private static final int MAX_SAMPLE_WINDOW = 1024;
    private double[] filterWindow;
    private double[] preemphasis;
    private int[] channelWidth = new int[2];
    private int[] subbandsInBar = new int[2];
    private int[] numBars = new int[2];
    private boolean[] clipSubbands = new boolean[2];
    private int numSubbands;
    private int sampleWindow;
    private int numWindows = 0;
    private boolean bandwidthHalf = false;
    private double preemphasisDbPerKhz;
    private int samplesInChunk = 0;
    private int numReads = 0;
    private ComplexFloatFFT_Radix2 fft;

    public VisualizerSpectrumAnalyser(Softsqueeze squeeze, byte[] buf, int off, int len) {
        super(squeeze, buf, off, len);
        this.isMono = this.visParam[0] == 1;
        this.bandwidthHalf = this.visParam[1] == 1;
        this.preemphasisDbPerKhz = this.visParam[2] >> 16;
        this.channelPosition[0] = this.visParam[3];
        this.channelWidth[0] = this.visParam[4];
        this.channelFlipped[0] = this.visParam[5] > 0;
        this.barWidth[0] = this.visParam[6];
        this.barSpacing[0] = this.visParam[7];
        this.clipSubbands[0] = this.visParam[8] > 0;
        this.barIntensity[0] = this.visParam[9];
        this.capIntensity[0] = this.visParam[10];
        if (!this.isMono) {
            this.channelPosition[1] = this.visParam[11];
            this.channelWidth[1] = this.visParam[12];
            this.channelFlipped[1] = this.visParam[13] > 0;
            this.barWidth[1] = this.visParam[14];
            this.barSpacing[1] = this.visParam[15];
            this.clipSubbands[1] = this.visParam[16] > 0;
            this.barIntensity[1] = this.visParam[17];
            this.capIntensity[1] = this.visParam[18];
        } else {
            this.channelPosition[1] = -1;
        }
        for (int ch = 0; ch < 2; ++ch) {
            if (this.channelWidth[ch] > 640) {
                this.channelWidth[ch] = 640;
            }
            if (this.channelPosition[ch] + this.channelWidth[ch] <= 640) continue;
            this.channelPosition[ch] = 640 - this.channelWidth[ch];
        }
        int barSize = this.barWidth[0] + this.barSpacing[0];
        this.numSubbands = this.channelWidth[0] / barSize;
        int l2int = 0;
        for (int shiftsubbands = this.numSubbands; shiftsubbands != 1; shiftsubbands >>= 1) {
            ++l2int;
        }
        this.numSubbands = 1 << l2int;
        if (this.clipSubbands[0]) {
            this.numSubbands <<= 1;
        }
        this.numBars[0] = this.numSubbands;
        if (this.numSubbands < 32) {
            this.subbandsInBar[0] = 32 / this.numSubbands;
            this.numSubbands = 32;
        } else {
            this.subbandsInBar[0] = 1;
        }
        if (this.clipSubbands[0]) {
            this.numBars[0] = this.channelWidth[0] / barSize;
        }
        this.barVal[0] = new int[this.numBars[0]];
        this.barLvl[0] = new int[this.numBars[0]];
        if (!this.isMono) {
            barSize = this.barWidth[1] + this.barSpacing[1];
            this.numBars[1] = this.channelWidth[1] / barSize;
            this.subbandsInBar[1] = 1;
            if (this.numBars[1] > this.numSubbands) {
                this.numBars[1] = this.numSubbands;
            } else if (!this.clipSubbands[1]) {
                int s;
                this.subbandsInBar[1] = 1;
                for (s = this.numSubbands; s > this.numBars[1]; s >>= 1) {
                    this.subbandsInBar[1] = this.subbandsInBar[1] + 1;
                }
                this.numBars[1] = s;
            }
            this.barVal[1] = new int[this.numBars[1]];
            this.barLvl[1] = new int[this.numBars[1]];
        }
        this.sampleWindow = this.numSubbands * 2;
        this.fft = new ComplexFloatFFT_Radix2(this.sampleWindow);
        this.numWindows = this.sampleWindow < 128 ? 128 / this.sampleWindow : 1;
        this.samplesInChunk = 128;
        if (this.bandwidthHalf) {
            this.samplesInChunk >>= 1;
        }
        this.numReads = this.sampleWindow <= this.samplesInChunk ? 1 : this.sampleWindow / this.samplesInChunk;
        logger.debug((Object)("numSubbands = " + this.numSubbands));
        logger.debug((Object)("sampleWindow = " + this.sampleWindow));
        logger.debug((Object)("samplesInChunk = " + this.samplesInChunk));
        logger.debug((Object)("numReads = " + this.numReads));
        logger.debug((Object)("numWindows = " + this.numWindows));
        logger.debug((Object)("bandwidthHalf = " + this.bandwidthHalf));
        logger.debug((Object)("subbandsInBar = " + this.subbandsInBar[0]));
        double const1 = 0.54;
        double const2 = 0.46;
        this.filterWindow = new double[1024];
        for (int w = 0; w < this.sampleWindow; ++w) {
            this.filterWindow[w] = const1 - const2 * Math.cos(Math.PI * 2 * (double)w / (double)this.sampleWindow);
        }
        double subbandWidth = 22.05 / (double)this.numSubbands;
        double freqSum = 0.0;
        double scaleDB = 0.0;
        this.preemphasis = new double[this.numSubbands];
        for (int s = 0; s < this.numSubbands; ++s) {
            while (freqSum > 1.0) {
                freqSum -= 1.0;
                scaleDB += this.preemphasisDbPerKhz;
            }
            this.preemphasis[s] = scaleDB != 0.0 ? Math.pow(10.0, scaleDB / 10.0) : 1.0;
            freqSum += subbandWidth;
        }
    }

    @Override
    protected void visualize(byte[] buf, int offset, int bufLen) {
        float[] avgPower = new float[this.numSubbands * 2];
        for (int w = 0; w < this.numWindows; ++w) {
            int numRead;
            float[] fftData = new float[this.sampleWindow * 2];
            int fftPtr = 0;
            for (int r = 0; r < this.numReads && (numRead = Math.min(bufLen - offset, 512)) >= 512; ++r) {
                for (int s = 0; s < this.samplesInChunk; ++s) {
                    int sample;
                    if (this.bandwidthHalf) {
                        sample = this.getSample(offset);
                        sample += this.getSample(offset + 4);
                        fftData[fftPtr++] = (float)(this.filterWindow[s] * (double)(sample >>= 1));
                        sample = this.getSample(offset + 2);
                        sample += this.getSample(offset + 6);
                        fftData[fftPtr++] = (float)(this.filterWindow[s] * (double)(sample >>= 1));
                        offset += 8;
                        continue;
                    }
                    sample = this.getSample(offset);
                    fftData[fftPtr++] = (float)(this.filterWindow[s] * (double)sample);
                    sample = this.getSample(offset + 2);
                    fftData[fftPtr++] = (float)(this.filterWindow[s] * (double)sample);
                    offset += 4;
                }
            }
            this.fft.transform(fftData);
            int avgPtr = 0;
            for (int s = 1; s <= this.numSubbands; ++s) {
                int ck = s * 2;
                int cnk = this.sampleWindow * 2 - ck;
                float r = (fftData[ck] + fftData[cnk]) / 2.0f;
                float i = (fftData[ck + 1] - fftData[cnk + 1]) / 2.0f;
                int n = avgPtr++;
                avgPower[n] = avgPower[n] + (r * r + i * i) / (float)this.numWindows;
                r = (fftData[cnk + 1] + fftData[ck + 1]) / 2.0f;
                i = (fftData[cnk] - fftData[ck]) / 2.0f;
                int n2 = avgPtr++;
                avgPower[n2] = avgPower[n2] + (r * r + i * i) / (float)this.numWindows;
            }
        }
        int prePtr = 0;
        int avgPtr = 0;
        for (int p = 0; p < this.numSubbands; ++p) {
            long product = (long)((double)avgPower[avgPtr] * this.preemphasis[prePtr]);
            avgPower[avgPtr++] = (int)(product >>= 16);
            product = (long)((double)avgPower[avgPtr] * this.preemphasis[prePtr]);
            avgPower[avgPtr++] = (int)(product >>= 16);
            ++prePtr;
        }
        block5: for (int ch = 0; ch < (this.isMono ? 1 : 2); ++ch) {
            int powerSum = 0;
            int inBar = 0;
            int currBar = 0;
            avgPtr = ch == 0 ? 0 : 1;
            for (int s = 0; s < this.numSubbands; ++s) {
                powerSum = (int)((float)powerSum + avgPower[avgPtr] / (float)this.subbandsInBar[ch]);
                if (this.isMono) {
                    powerSum = (int)((float)powerSum + avgPower[avgPtr + 1] / (float)this.subbandsInBar[ch]);
                }
                if (++inBar == this.subbandsInBar[ch]) {
                    if (this.isMono) {
                        powerSum >>= 2;
                    }
                    powerSum <<= 3;
                    int val = 0;
                    for (int i = 31; i > 0; --i) {
                        if (powerSum < POWER_MAP[i]) continue;
                        val = i;
                        break;
                    }
                    this.barVal[ch][currBar++] = val;
                    if (currBar == this.numBars[ch]) continue block5;
                    inBar = 0;
                    powerSum = 0;
                }
                avgPtr += 2;
            }
        }
    }
}

