/*
 * Decompiled with CFR 0.152.
 */
package org.titmuss.softsqueeze.visualizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.titmuss.softsqueeze.Softsqueeze;
import org.titmuss.softsqueeze.net.Protocol;
import org.titmuss.softsqueeze.visualizer.Visualizer;

public class VisualizerVUMeter
extends Visualizer {
    private static final Logger logger = Logger.getLogger((String)"visualizer");
    private static final int SAMPLE_WINDOW = 1024;
    private static final int[] DIGITAL_RMS_MAP = new int[]{0, 10, 57, 159, 326, 570, 900, 1323, 1847, 2480, 3227};
    private static final int[] ANALOG_RMS_MAP = new int[]{0, 1, 4, 8, 14, 22, 33, 46, 62, 81, 102, 128, 156, 188, 223, 262, 305, 352, 403, 459, 518, 582, 650, 724, 801, 884, 972, 1064, 1162, 1264, 1372, 1486, 1605, 1729, 1859, 1995, 2136, 2284, 2437, 2596, 2761, 2933, 3111, 3295, 3485, 3682, 3885, 4096};
    private static final int RENDER_DIGITAL = 0;
    private static final int RENDER_ANALOG = 1;
    private static final int RENDER_CUSTOM = 2;
    private int renderStyle;
    private int damping;
    private boolean[] barReversed = new boolean[2];
    private static Image analogImage;

    public VisualizerVUMeter(Softsqueeze squeeze, byte[] buf, int off, int len) {
        super(squeeze, buf, off, len);
        int p = 0;
        this.isMono = this.visParam[p++] == 1;
        switch (this.visParam[p++]) {
            case 0: {
                this.renderStyle = 0;
                break;
            }
            case 1: {
                this.renderStyle = 1;
                analogImage = null;
                break;
            }
            case 2: {
                this.renderStyle = 2;
            }
        }
        this.channelPosition[0] = this.visParam[p++];
        this.barWidth[0] = Math.abs(this.visParam[p]);
        this.barReversed[0] = this.visParam[p++] < 0;
        this.barVal[0] = new int[1];
        this.barLvl[0] = new int[1];
        if (!this.isMono) {
            this.channelPosition[1] = this.visParam[p++];
            this.barWidth[1] = Math.abs(this.visParam[p]);
            this.barReversed[1] = this.visParam[p++] < 0;
            this.barVal[1] = new int[1];
            this.barLvl[1] = new int[1];
        } else {
            this.channelPosition[1] = -1;
        }
        this.damping = p < this.visParam.length ? this.visParam[p++] : 0;
        this.displayRate = p < this.visParam.length ? this.visParam[p++] : 30;
    }

    @Override
    protected void visualize(byte[] buf, int offset, int bufLen) {
        int numAccumulated = 0;
        int numRead = Math.min(bufLen - offset, 1024);
        int numSamples = numRead / (2 * this.sampleSize);
        int[] sampleAccumulator = new int[2];
        for (int j = 0; j < numSamples; ++j) {
            int sample = this.getSample(offset) >> 8;
            int sampleSq = sample * sample;
            sampleAccumulator[0] = sampleAccumulator[0] + (sampleSq & 0xFFFF);
            sample = this.getSample(offset += 2) >> 8;
            sampleSq = sample * sample;
            sampleAccumulator[1] = sampleAccumulator[1] + (sampleSq & 0xFFFF);
            offset += 2;
        }
        numAccumulated += numSamples;
        if (this.isMono) {
            sampleAccumulator[0] = sampleAccumulator[0] + sampleAccumulator[1];
            sampleAccumulator[0] = sampleAccumulator[0] / (2 * numAccumulated);
        } else {
            sampleAccumulator[0] = sampleAccumulator[0] / numAccumulated;
            sampleAccumulator[1] = sampleAccumulator[1] / numAccumulated;
        }
        this.barVal[0][0] = sampleAccumulator[0];
        this.barVal[1][0] = sampleAccumulator[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics g, Color[] col) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(1, 1.0f));
        g2.fillRect(0, 0, 640, 32);
        g2.setComposite(AlphaComposite.Src);
        if (!this.running) {
            return;
        }
        int[] rmsMap = this.renderStyle == 0 ? DIGITAL_RMS_MAP : ANALOG_RMS_MAP;
        block8: for (int ch = 0; ch < 2; ++ch) {
            int val = 0;
            for (int i = rmsMap.length - 1; i > 0; --i) {
                if (this.barVal[ch][0] < rmsMap[i]) continue;
                val = i;
                break;
            }
            switch (this.damping) {
                case 0: {
                    if (this.barLvl[ch][0] > 0) {
                        int[] nArray = this.barLvl[ch];
                        nArray[0] = nArray[0] - 1;
                    }
                    if (this.barLvl[ch][0] >= val) continue block8;
                    this.barLvl[ch][0] = val;
                    continue block8;
                }
                case 1: {
                    if (this.barLvl[ch][0] < val) {
                        int[] nArray = this.barLvl[ch];
                        nArray[0] = nArray[0] + 1;
                        continue block8;
                    }
                    if (this.barLvl[ch][0] <= 0) continue block8;
                    int[] nArray = this.barLvl[ch];
                    nArray[0] = nArray[0] - 1;
                    continue block8;
                }
                case 2: {
                    this.barLvl[ch][0] = val;
                }
            }
        }
        if (this.renderStyle == 0) {
            this.renderDigital(g2, col, 0);
            if (!this.isMono) {
                this.renderDigital(g2, col, 1);
            }
        } else {
            this.renderAnalog(g2, col, 0);
            if (!this.isMono) {
                this.renderAnalog(g2, col, 1);
            }
        }
        if (this.barLvl[0][0] == 0 && this.barLvl[1][0] == 0) {
            VisualizerVUMeter visualizerVUMeter = this;
            synchronized (visualizerVUMeter) {
                this.bufLen = 0;
            }
        }
    }

    private void renderDigital(Graphics2D g2, Color[] col, int ch) {
        int pos = this.channelPosition[ch];
        for (int i = 0; i < this.barLvl[ch][0] + 1; ++i) {
            if (i <= 2) {
                g2.setColor(col[1]);
            } else if (i <= 6) {
                g2.setColor(col[2]);
            } else {
                g2.setColor(col[3]);
            }
            g2.fillRect(pos, 30 - i * 3, this.barWidth[ch], 2);
        }
    }

    private void renderAnalog(Graphics2D g2, Color[] col, int ch) {
        if (analogImage == null) {
            if (this.renderStyle != 1) {
                return;
            }
            this.loadImage(col);
        }
        int pos = this.channelPosition[ch];
        int offset = -this.barWidth[ch] * this.barLvl[ch][0];
        AffineTransform t = AffineTransform.getTranslateInstance(offset + pos, 0.0);
        g2.setClip(pos, 0, this.barWidth[ch], 32);
        if (this.barReversed[ch]) {
            t.preConcatenate(AffineTransform.getScaleInstance(-1.0, 1.0));
        }
        g2.drawImage(analogImage, t, null);
    }

    private void loadImage(Color[] col) {
        try {
            InputStream is = this.getClass().getResourceAsStream("vumeter.png");
            analogImage = this.changeColor(ImageIO.read(is), col[3]);
            is.close();
        }
        catch (IOException e) {
            logger.error((Object)"Cannot read analogue vu meter image", (Throwable)e);
        }
    }

    public Image changeColor(BufferedImage image, Color newColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        double r = (double)newColor.getRed() / 255.0;
        double g = (double)newColor.getGreen() / 255.0;
        double b = (double)newColor.getBlue() / 255.0;
        BufferedImage img = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgba = image.getRGB(x, y);
                int red = rgba >> 16 & 0xFF;
                int green = rgba >> 8 & 0xFF;
                int blue = rgba & 0xFF;
                int alpha = rgba >> 24 & 0xFF;
                red = (int)((double)red * r);
                green = (int)((double)green * g);
                blue = (int)((double)blue * b);
                rgba = alpha << 24 | red << 16 | green << 8 | blue;
                img.setRGB(x, y, rgba);
            }
        }
        return img;
    }

    public static void uploadGraphic(byte[] buf, int off, int len) {
        int frameOffset = Protocol.unpackN4(buf, off);
        int frameLength = len - (off += 4) - 4;
        if (frameOffset == 0) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            analogImage = gc.createCompatibleImage(15360, 32, 1);
        }
        Graphics2D g2 = (Graphics2D)analogImage.getGraphics();
        Color[] color = new Color[]{Color.BLACK, new Color(2669332), new Color(2001935), new Color(3340826)};
        for (int i = 0; i < frameLength; ++i) {
            int x = (frameOffset + i) / 8;
            int y = 32 - (frameOffset + i) % 8 * 4;
            byte dots = buf[off++];
            for (int j = 0; j < 8; j += 2) {
                int c = dots >> j & 3;
                g2.setColor(color[c]);
                g2.drawLine(x, y, x, y - 1);
                --y;
            }
        }
    }
}

